/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.processing.ProcessingException;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELException;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Resource;
import org.camunda.bpm.engine.impl.juel.Builder;
import org.camunda.bpm.engine.impl.juel.IdentifierNode;
import org.camunda.bpm.engine.impl.juel.Tree;
import org.camunda.bpm.model.bpmn.Query;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.camunda.bpm.model.bpmn.instance.CompletionCondition;
import org.camunda.bpm.model.bpmn.instance.ConditionExpression;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.LoopCardinality;
import org.camunda.bpm.model.bpmn.instance.LoopCharacteristics;
import org.camunda.bpm.model.bpmn.instance.Script;
import org.camunda.bpm.model.bpmn.instance.ScriptTask;
import org.camunda.bpm.model.bpmn.instance.SendTask;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaFormData;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaFormField;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaIn;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaOut;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaScript;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaTaskListener;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.InputExpression;
import org.camunda.bpm.model.dmn.instance.Output;
import org.camunda.bpm.model.dmn.instance.Text;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public final class ProcessVariableReader {
    private final Map<String, String> decisionRefToPathMap;
    private final BpmnScanner bpmnScanner;
    public static final Logger LOGGER = Logger.getLogger(ProcessVariableReader.class.getName());

    public ProcessVariableReader(Map<String, String> decisionRefToPathMap, BpmnScanner scanner) {
        this.decisionRefToPathMap = decisionRefToPathMap;
        this.bpmnScanner = scanner;
    }

    public Map<String, ProcessVariable> getVariablesFromElement(BpmnElement element) {
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        processVariables.putAll(this.getVariablesFromTask(element));
        processVariables.putAll(this.searchVariablesFromSequenceFlow(element));
        processVariables.putAll(this.searchExtensionsElements(element));
        processVariables.putAll(this.getVariablesFromParameters(element));
        processVariables.putAll(this.getVariablesFromNames(element));
        return processVariables;
    }

    private Map<String, ProcessVariable> getVariablesFromNames(BpmnElement element) {
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeElementId = null;
        if (scopeElement != null) {
            scopeElementId = scopeElement.getAttributeValue("id");
        }
        ArrayList<String> signalRefs = this.bpmnScanner.getSignalRefs(element.getBaseElement().getId());
        ArrayList<String> messagesRefs = this.bpmnScanner.getMessageRefs(element.getBaseElement().getId());
        ArrayList<String> signalVariables = this.getSignalVariables(signalRefs, element);
        ArrayList<String> messageVariables = this.getMessageVariables(messagesRefs, element);
        for (String variable : messageVariables) {
            processVariables.put(variable, new ProcessVariable(variable, element, ElementChapter.General, KnownElementFieldType.Message, element.getProcessdefinition(), VariableOperation.READ, scopeElementId));
        }
        for (String variable : signalVariables) {
            processVariables.put(variable, new ProcessVariable(variable, element, ElementChapter.General, KnownElementFieldType.Signal, element.getProcessdefinition(), VariableOperation.READ, scopeElementId));
        }
        return processVariables;
    }

    private ArrayList<String> getSignalVariables(ArrayList<String> signalRefs, BpmnElement element) {
        ArrayList<String> names = new ArrayList<String>();
        for (String signalID : signalRefs) {
            names.add(this.bpmnScanner.getSignalName(signalID));
        }
        ArrayList<String> variables = new ArrayList<String>();
        for (String signalName : names) {
            variables.addAll(this.checkExpressionForReadVariable(signalName, element));
        }
        return variables;
    }

    private ArrayList<String> getMessageVariables(ArrayList<String> messageRefs, BpmnElement element) {
        ArrayList<String> names = new ArrayList<String>();
        for (String messageID : messageRefs) {
            names.add(this.bpmnScanner.getMessageName(messageID));
        }
        ArrayList<String> variables = new ArrayList<String>();
        for (String messageName : names) {
            variables.addAll(this.checkExpressionForReadVariable(messageName, element));
        }
        return variables;
    }

    private Map<String, ProcessVariable> getVariablesFromParameters(BpmnElement element) {
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeElementId = null;
        if (scopeElement != null) {
            scopeElementId = scopeElement.getAttributeValue("id");
        }
        ArrayList<String> outVar = this.bpmnScanner.getOutputVariables(element.getBaseElement().getId());
        ArrayList<String> inVar = this.bpmnScanner.getInputVariables(element.getBaseElement().getId());
        ArrayList<String> varValues = this.bpmnScanner.getInOutputVariablesValue(element.getBaseElement().getId());
        for (String name : outVar) {
            processVariables.put(name, new ProcessVariable(name, element, ElementChapter.InputOutput, KnownElementFieldType.OutputParameter, element.getProcessdefinition(), VariableOperation.WRITE, scopeElementId));
        }
        ArrayList<String> varValueClean = new ArrayList<String>();
        for (String expression : varValues) {
            varValueClean.addAll(this.checkExpressionForReadVariable(expression, element));
        }
        varValueClean.removeAll(inVar);
        for (String var : varValueClean) {
            processVariables.put(var, new ProcessVariable(var, element, ElementChapter.InputOutput, KnownElementFieldType.OutputParameter, element.getProcessdefinition(), VariableOperation.READ, scopeElementId));
        }
        for (String name : outVar) {
            processVariables.put(name, new ProcessVariable(name, element, ElementChapter.InputOutput, KnownElementFieldType.OutputParameter, element.getProcessdefinition(), VariableOperation.WRITE, scopeElementId));
        }
        return processVariables;
    }

    private Map<String, ProcessVariable> searchExtensionsElements(BpmnElement element) {
        ExtensionElements extensionElements;
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeElementId = null;
        if (scopeElement != null) {
            scopeElementId = scopeElement.getAttributeValue("id");
        }
        if ((extensionElements = baseElement.getExtensionElements()) != null) {
            processVariables.putAll(this.getVariablesFromExecutionListener(element, extensionElements, scopeElementId));
            processVariables.putAll(this.getVariablesFromTaskListener(element, extensionElements, scopeElementId));
            processVariables.putAll(this.getVariablesFromFormData(element, extensionElements, scopeElementId));
            processVariables.putAll(this.searchVariablesInInputOutputExtensions(element, extensionElements, scopeElementId));
        }
        return processVariables;
    }

    private Map<String, ProcessVariable> getVariablesFromExecutionListener(BpmnElement element, ExtensionElements extensionElements, String scopeId) {
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaExecutionListener.class).list();
        for (CamundaExecutionListener listener : listenerList) {
            String l_delegateExpression;
            String l_expression = listener.getCamundaExpression();
            if (l_expression != null) {
                processVariables.putAll(this.findVariablesInExpression(l_expression, element, ElementChapter.ExecutionListener, KnownElementFieldType.Expression, scopeId));
            }
            if ((l_delegateExpression = listener.getCamundaDelegateExpression()) != null) {
                processVariables.putAll(this.findVariablesInExpression(l_delegateExpression, element, ElementChapter.ExecutionListener, KnownElementFieldType.DelegateExpression, scopeId));
            }
            processVariables.putAll(this.getVariablesFromJavaDelegate(listener.getCamundaClass(), element, ElementChapter.ExecutionListener, KnownElementFieldType.Class, scopeId));
            CamundaScript script = listener.getCamundaScript();
            if (script == null || script.getCamundaScriptFormat() == null || !script.getCamundaScriptFormat().equals("groovy")) continue;
            String inlineScript = script.getTextContent();
            if (inlineScript != null && inlineScript.trim().length() > 0) {
                processVariables.putAll(this.searchProcessVariablesInCode(element, ElementChapter.ExecutionListener, KnownElementFieldType.InlineScript, null, scopeId, inlineScript));
                continue;
            }
            String resourcePath = script.getCamundaResource();
            if (resourcePath == null) continue;
            processVariables.putAll(this.getVariablesFromGroovyScript(resourcePath, element, ElementChapter.ExecutionListener, KnownElementFieldType.ExternalScript, scopeId));
        }
        return processVariables;
    }

    private Map<String, ProcessVariable> getVariablesFromTaskListener(BpmnElement element, ExtensionElements extensionElements, String scopeId) {
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaTaskListener.class).list();
        for (CamundaTaskListener listener : listenerList) {
            String l_delegateExpression;
            String l_expression = listener.getCamundaExpression();
            if (l_expression != null) {
                processVariables.putAll(this.findVariablesInExpression(l_expression, element, ElementChapter.TaskListener, KnownElementFieldType.Expression, scopeId));
            }
            if ((l_delegateExpression = listener.getCamundaDelegateExpression()) != null) {
                processVariables.putAll(this.findVariablesInExpression(l_delegateExpression, element, ElementChapter.TaskListener, KnownElementFieldType.DelegateExpression, scopeId));
            }
            processVariables.putAll(this.getVariablesFromJavaDelegate(listener.getCamundaClass(), element, ElementChapter.TaskListener, KnownElementFieldType.Class, scopeId));
            CamundaScript script = listener.getCamundaScript();
            if (script == null || script.getCamundaScriptFormat() == null || !script.getCamundaScriptFormat().equals("groovy")) continue;
            String inlineScript = script.getTextContent();
            if (inlineScript != null && inlineScript.trim().length() > 0) {
                processVariables.putAll(this.searchProcessVariablesInCode(element, ElementChapter.TaskListener, KnownElementFieldType.InlineScript, null, scopeId, inlineScript));
                continue;
            }
            String resourcePath = script.getCamundaResource();
            if (resourcePath == null) continue;
            processVariables.putAll(this.getVariablesFromGroovyScript(resourcePath, element, ElementChapter.TaskListener, KnownElementFieldType.ExternalScript, scopeId));
        }
        return processVariables;
    }

    private Map<String, ProcessVariable> getVariablesFromFormData(BpmnElement element, ExtensionElements extensionElements, String scopeElementId) {
        CamundaFormData formData;
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        Query formDataQuery = extensionElements.getElementsQuery().filterByType(CamundaFormData.class);
        if (formDataQuery.count() > 0 && (formData = (CamundaFormData)formDataQuery.singleResult()) != null) {
            Collection formFields = formData.getCamundaFormFields();
            for (CamundaFormField field : formFields) {
                processVariables.put(field.getCamundaId(), new ProcessVariable(field.getCamundaId(), element, ElementChapter.FormData, KnownElementFieldType.FormField, null, VariableOperation.WRITE, scopeElementId));
            }
        }
        return processVariables;
    }

    private Map<String, ProcessVariable> searchVariablesInInputOutputExtensions(BpmnElement element, ExtensionElements extensionElements, String scopeId) {
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof CallActivity) {
            List inputAssociations = extensionElements.getElementsQuery().filterByType(CamundaIn.class).list();
            for (CamundaIn inputAssociation : inputAssociations) {
                String source = inputAssociation.getCamundaSource();
                if (source == null || source.isEmpty()) continue;
                processVariables.put(source, new ProcessVariable(source, element, ElementChapter.InputData, KnownElementFieldType.CamundaIn, null, VariableOperation.READ, scopeId));
            }
            List outputAssociations = extensionElements.getElementsQuery().filterByType(CamundaOut.class).list();
            for (CamundaOut outputAssociation : outputAssociations) {
                String target = outputAssociation.getCamundaTarget();
                if (target == null || target.isEmpty()) continue;
                processVariables.put(target, new ProcessVariable(target, element, ElementChapter.OutputData, KnownElementFieldType.CamundaOut, null, VariableOperation.WRITE, scopeId));
            }
        }
        return processVariables;
    }

    private Map<String, ProcessVariable> searchVariablesFromSequenceFlow(BpmnElement element) {
        Map<String, ProcessVariable> variables = new HashMap<String, ProcessVariable>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof SequenceFlow) {
            ConditionExpression expression;
            SequenceFlow flow = (SequenceFlow)baseElement;
            BpmnModelElementInstance scopeElement = flow.getScope();
            String scopeId = null;
            if (scopeElement != null) {
                scopeId = scopeElement.getAttributeValue("id");
            }
            if ((expression = flow.getConditionExpression()) != null) {
                if (expression.getLanguage() != null && expression.getLanguage().equals("groovy")) {
                    String inlineScript = expression.getTextContent();
                    if (inlineScript != null && inlineScript.trim().length() > 0) {
                        variables.putAll(this.searchProcessVariablesInCode(element, ElementChapter.Details, KnownElementFieldType.InlineScript, scopeId, null, inlineScript));
                    } else {
                        String resourcePath = expression.getCamundaResource();
                        if (resourcePath != null) {
                            variables.putAll(this.getVariablesFromGroovyScript(resourcePath, element, ElementChapter.Details, KnownElementFieldType.ExternalScript, scopeId));
                        }
                    }
                } else if (expression.getTextContent().trim().length() > 0) {
                    variables = this.findVariablesInExpression(expression.getTextContent(), element, ElementChapter.Details, KnownElementFieldType.Expression, scopeId);
                }
            }
        }
        return variables;
    }

    private Map<String, ProcessVariable> getVariablesFromTask(BpmnElement element) {
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeId = null;
        if (scopeElement != null) {
            scopeId = scopeElement.getAttributeValue("id");
        }
        if (baseElement instanceof ServiceTask || baseElement instanceof SendTask || baseElement instanceof BusinessRuleTask) {
            String fileName;
            String t_decisionRef;
            String t_resultVariable;
            ArrayList<String> t_fieldInjectionExpressions;
            String t_delegateExpression;
            String t_expression = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "expression");
            if (t_expression != null) {
                processVariables.putAll(this.findVariablesInExpression(t_expression, element, ElementChapter.Details, KnownElementFieldType.Expression, scopeId));
            }
            if ((t_delegateExpression = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "delegateExpression")) != null) {
                processVariables.putAll(this.findVariablesInExpression(t_delegateExpression, element, ElementChapter.Details, KnownElementFieldType.DelegateExpression, scopeId));
            }
            if ((t_fieldInjectionExpressions = this.bpmnScanner.getFieldInjectionExpression(baseElement.getId())) != null && !t_fieldInjectionExpressions.isEmpty()) {
                for (String t_fieldInjectionExpression : t_fieldInjectionExpressions) {
                    processVariables.putAll(this.findVariablesInExpression(t_fieldInjectionExpression, element, ElementChapter.FieldInjections, KnownElementFieldType.Expression, scopeId));
                }
            }
            if ((t_resultVariable = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "resultVariable")) != null && t_resultVariable.trim().length() > 0) {
                processVariables.put(t_resultVariable, new ProcessVariable(t_resultVariable, element, ElementChapter.Details, KnownElementFieldType.ResultVariable, null, VariableOperation.WRITE, scopeId));
            }
            processVariables.putAll(this.getVariablesFromJavaDelegate(baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class"), element, ElementChapter.Details, KnownElementFieldType.Class, scopeId));
            if (baseElement instanceof BusinessRuleTask && (t_decisionRef = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "decisionRef")) != null && t_decisionRef.trim().length() > 0 && this.decisionRefToPathMap != null && (fileName = this.decisionRefToPathMap.get(t_decisionRef)) != null) {
                processVariables.putAll(this.readDmnFile(t_decisionRef, fileName, element, ElementChapter.Details, KnownElementFieldType.DMN, scopeId));
            }
        } else if (baseElement instanceof UserTask) {
            String followUpDate;
            String dueDate;
            String candidateGroups;
            String candidateUsers;
            UserTask userTask = (UserTask)baseElement;
            String assignee = userTask.getCamundaAssignee();
            if (assignee != null) {
                processVariables.putAll(this.findVariablesInExpression(assignee, element, ElementChapter.Details, KnownElementFieldType.Assignee, scopeId));
            }
            if ((candidateUsers = userTask.getCamundaCandidateUsers()) != null) {
                processVariables.putAll(this.findVariablesInExpression(candidateUsers, element, ElementChapter.Details, KnownElementFieldType.CandidateUsers, scopeId));
            }
            if ((candidateGroups = userTask.getCamundaCandidateGroups()) != null) {
                processVariables.putAll(this.findVariablesInExpression(candidateGroups, element, ElementChapter.Details, KnownElementFieldType.CandidateGroups, scopeId));
            }
            if ((dueDate = userTask.getCamundaDueDate()) != null) {
                processVariables.putAll(this.findVariablesInExpression(dueDate, element, ElementChapter.Details, KnownElementFieldType.DueDate, scopeId));
            }
            if ((followUpDate = userTask.getCamundaFollowUpDate()) != null) {
                processVariables.putAll(this.findVariablesInExpression(followUpDate, element, ElementChapter.Details, KnownElementFieldType.FollowUpDate, scopeId));
            }
        } else if (baseElement instanceof ScriptTask) {
            String resultVariable;
            ScriptTask scriptTask = (ScriptTask)baseElement;
            if (scriptTask.getScriptFormat() != null && scriptTask.getScriptFormat().equals("groovy")) {
                Script script = scriptTask.getScript();
                if (script != null && script.getTextContent() != null && script.getTextContent().trim().length() > 0) {
                    processVariables.putAll(this.searchProcessVariablesInCode(element, ElementChapter.Details, KnownElementFieldType.InlineScript, null, scopeId, script.getTextContent()));
                } else {
                    String resourcePath = scriptTask.getCamundaResource();
                    if (resourcePath != null) {
                        processVariables.putAll(this.getVariablesFromGroovyScript(resourcePath, element, ElementChapter.Details, KnownElementFieldType.ExternalScript, scopeId));
                    }
                }
            }
            if ((resultVariable = scriptTask.getCamundaResultVariable()) != null && resultVariable.trim().length() > 0) {
                processVariables.put(resultVariable, new ProcessVariable(resultVariable, element, ElementChapter.Details, KnownElementFieldType.ResultVariable, null, VariableOperation.WRITE, scopeId));
            }
        } else if (baseElement instanceof CallActivity) {
            String caseRef;
            CallActivity callActivity = (CallActivity)baseElement;
            String calledElement = callActivity.getCalledElement();
            if (calledElement != null && calledElement.trim().length() > 0) {
                processVariables.putAll(this.findVariablesInExpression(calledElement, element, ElementChapter.Details, KnownElementFieldType.CalledElement, scopeId));
            }
            if ((caseRef = callActivity.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "caseRef")) != null && caseRef.trim().length() > 0) {
                processVariables.putAll(this.findVariablesInExpression(caseRef, element, ElementChapter.Details, KnownElementFieldType.CaseRef, scopeId));
            }
        }
        processVariables.putAll(this.searchVariablesInMultiInstanceTask(element));
        return processVariables;
    }

    private Map<String, ProcessVariable> searchVariablesInMultiInstanceTask(BpmnElement element) {
        ModelElementInstance loopCharacteristics;
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeId = null;
        if (scopeElement != null) {
            scopeId = scopeElement.getAttributeValue("id");
        }
        if ((loopCharacteristics = baseElement.getUniqueChildElementByType(LoopCharacteristics.class)) != null) {
            String completionConditionExpression;
            ModelElementInstance completionCondition;
            String cardinality;
            ModelElementInstance loopCardinality;
            String elementVariable;
            String collectionName = loopCharacteristics.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "collection");
            if (collectionName != null && collectionName.trim().length() > 0) {
                processVariables.put(collectionName, new ProcessVariable(collectionName, element, ElementChapter.MultiInstance, KnownElementFieldType.CollectionElement, null, VariableOperation.READ, scopeId));
            }
            if ((elementVariable = loopCharacteristics.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "elementVariable")) != null && elementVariable.trim().length() > 0) {
                processVariables.put(elementVariable, new ProcessVariable(elementVariable, element, ElementChapter.MultiInstance, KnownElementFieldType.ElementVariable, null, VariableOperation.READ, scopeId));
            }
            if ((loopCardinality = loopCharacteristics.getUniqueChildElementByType(LoopCardinality.class)) != null && (cardinality = loopCardinality.getTextContent()) != null && cardinality.trim().length() > 0) {
                processVariables.putAll(this.findVariablesInExpression(cardinality, element, ElementChapter.MultiInstance, KnownElementFieldType.LoopCardinality, scopeId));
            }
            if ((completionCondition = loopCharacteristics.getUniqueChildElementByType(CompletionCondition.class)) != null && (completionConditionExpression = completionCondition.getTextContent()) != null && completionConditionExpression.trim().length() > 0) {
                processVariables.putAll(this.findVariablesInExpression(completionConditionExpression, element, ElementChapter.MultiInstance, KnownElementFieldType.CompletionCondition, scopeId));
            }
        }
        return processVariables;
    }

    private Map<String, ProcessVariable> getVariablesFromJavaDelegate(String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        String filePath = "";
        if (classFile != null && classFile.trim().length() > 0) {
            filePath = classFile.replaceAll("\\.", "/") + ".java";
        }
        Map<String, ProcessVariable> variables = this.readResourceFile(filePath, element, chapter, fieldType, scopeId);
        return variables;
    }

    private Map<String, ProcessVariable> getVariablesFromGroovyScript(String groovyFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        Map<String, ProcessVariable> variables = this.readResourceFile(groovyFile, element, chapter, fieldType, scopeId);
        return variables;
    }

    private Map<String, ProcessVariable> readResourceFile(String fileName, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        Map<String, ProcessVariable> variables = new HashMap<String, ProcessVariable>();
        if (fileName != null && fileName.trim().length() > 0) {
            try {
                DirectoryScanner directoryScanner = new DirectoryScanner();
                if (RuntimeConfig.getInstance().isTest()) {
                    if (fileName.endsWith(".java")) {
                        directoryScanner.setBasedir("src/test/java/");
                    } else {
                        directoryScanner.setBasedir("src/test/resources/");
                    }
                } else if (fileName.endsWith(".java")) {
                    directoryScanner.setBasedir("src/main/java/");
                } else {
                    directoryScanner.setBasedir("src/main/resources/");
                }
                Resource s = directoryScanner.getResource(fileName);
                if (s.isExists()) {
                    InputStreamReader resource = new InputStreamReader(new FileInputStream(s.toString()));
                    String methodBody = IOUtils.toString((Reader)resource);
                    variables = this.searchProcessVariablesInCode(element, chapter, fieldType, fileName, scopeId, methodBody);
                } else {
                    LOGGER.warning("Class " + fileName + " does not exist");
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("resource '" + fileName + "' could not be read: " + ex.getMessage());
            }
        }
        return variables;
    }

    private Map<String, ProcessVariable> readDmnFile(String decisionId, String fileName, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        InputStream resource;
        HashMap<String, ProcessVariable> variables = new HashMap<String, ProcessVariable>();
        if (fileName != null && fileName.trim().length() > 0 && (resource = RuntimeConfig.getInstance().getClassLoader().getResourceAsStream(fileName)) != null) {
            DmnModelInstance modelInstance = Dmn.readModelFromStream((InputStream)resource);
            Decision decision = (Decision)modelInstance.getModelElementById(decisionId);
            Collection inputExpressions = decision.getModelInstance().getModelElementsByType(InputExpression.class);
            for (InputExpression inputExpression : inputExpressions) {
                Text variable = inputExpression.getText();
                variables.put(variable.getTextContent(), new ProcessVariable(variable.getTextContent(), element, chapter, fieldType, fileName, VariableOperation.READ, scopeId));
            }
            Collection outputs = decision.getModelInstance().getModelElementsByType(Output.class);
            for (Output output : outputs) {
                String variable = output.getName();
                variables.put(variable, new ProcessVariable(variable, element, chapter, fieldType, fileName, VariableOperation.WRITE, scopeId));
            }
        }
        return variables;
    }

    private Map<String, ProcessVariable> searchProcessVariablesInCode(BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String fileName, String scopeId, String code) {
        HashMap<String, ProcessVariable> variables = new HashMap<String, ProcessVariable>();
        variables.putAll(this.searchReadProcessVariablesInCode(element, chapter, fieldType, fileName, scopeId, code));
        variables.putAll(this.searchWrittenProcessVariablesInCode(element, chapter, fieldType, fileName, scopeId, code));
        variables.putAll(this.searchRemovedProcessVariablesInCode(element, chapter, fieldType, fileName, scopeId, code));
        return variables;
    }

    private Map<String, ProcessVariable> searchReadProcessVariablesInCode(BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String fileName, String scopeId, String code) {
        HashMap<String, ProcessVariable> variables = new HashMap<String, ProcessVariable>();
        String FILTER_PATTERN = "'|\"| ";
        String COMMENT_PATTERN = "//.*";
        String IMPORT_PATTERN = "import .*";
        String PACKAGE_PATTERN = "package .*";
        String cleanedCode = code.replaceAll("//.*", "").replaceAll("import .*", "").replaceAll("package .*", "").replaceAll("'|\"| ", "");
        Pattern getVariablePatternRuntimeService = Pattern.compile("\\.getVariable\\((.*),(\\w+)\\)");
        Matcher matcherRuntimeService = getVariablePatternRuntimeService.matcher(cleanedCode);
        while (matcherRuntimeService.find()) {
            String match = matcherRuntimeService.group(2);
            variables.put(match, new ProcessVariable(match, element, chapter, fieldType, fileName, VariableOperation.READ, scopeId));
        }
        Pattern getVariablePatternDelegateExecution = Pattern.compile("\\.getVariable\\((\\w+)\\)");
        Matcher matcherDelegateExecution = getVariablePatternDelegateExecution.matcher(cleanedCode);
        while (matcherDelegateExecution.find()) {
            String match = matcherDelegateExecution.group(1);
            variables.put(match, new ProcessVariable(match, element, chapter, fieldType, fileName, VariableOperation.READ, scopeId));
        }
        return variables;
    }

    private Map<String, ProcessVariable> searchWrittenProcessVariablesInCode(BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String fileName, String scopeId, String code) {
        HashMap<String, ProcessVariable> variables = new HashMap<String, ProcessVariable>();
        String FILTER_PATTERN = "'|\"| ";
        String COMMENT_PATTERN = "//.*";
        String IMPORT_PATTERN = "import .*";
        String PACKAGE_PATTERN = "package .*";
        String cleanedCode = code.replaceAll("//.*", "").replaceAll("import .*", "").replaceAll("package .*", "").replaceAll("'|\"| ", "");
        Pattern setVariablePatternRuntimeService = Pattern.compile("\\.setVariable\\((.*),(\\w+),(.*)\\)");
        Matcher matcherPatternRuntimeService = setVariablePatternRuntimeService.matcher(cleanedCode);
        while (matcherPatternRuntimeService.find()) {
            String match = matcherPatternRuntimeService.group(2);
            variables.put(match, new ProcessVariable(match, element, chapter, fieldType, fileName, VariableOperation.WRITE, scopeId));
        }
        Pattern setVariablePatternDelegateExecution = Pattern.compile("\\.setVariable\\((\\w+),(.*)\\)");
        Matcher matcherPatternDelegateExecution = setVariablePatternDelegateExecution.matcher(cleanedCode);
        while (matcherPatternDelegateExecution.find()) {
            String match = matcherPatternDelegateExecution.group(1);
            variables.put(match, new ProcessVariable(match, element, chapter, fieldType, fileName, VariableOperation.WRITE, scopeId));
        }
        return variables;
    }

    private Map<String, ProcessVariable> searchRemovedProcessVariablesInCode(BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String fileName, String scopeId, String code) {
        HashMap<String, ProcessVariable> variables = new HashMap<String, ProcessVariable>();
        String FILTER_PATTERN = "'|\"| ";
        String COMMENT_PATTERN = "//.*";
        String IMPORT_PATTERN = "import .*";
        String PACKAGE_PATTERN = "package .*";
        String cleanedCode = code.replaceAll("//.*", "").replaceAll("import .*", "").replaceAll("package .*", "").replaceAll("'|\"| ", "");
        Pattern removeVariablePatternRuntimeService = Pattern.compile("\\.removeVariable\\((.*),(\\w+)\\)");
        Matcher matcherRuntimeService = removeVariablePatternRuntimeService.matcher(cleanedCode);
        while (matcherRuntimeService.find()) {
            String match = matcherRuntimeService.group(2);
            variables.put(match, new ProcessVariable(match, element, chapter, fieldType, fileName, VariableOperation.DELETE, scopeId));
        }
        Pattern removeVariablePatternDelegateExecution = Pattern.compile("\\.removeVariable\\((\\w+)\\)");
        Matcher matcherDelegateExecution = removeVariablePatternDelegateExecution.matcher(cleanedCode);
        while (matcherDelegateExecution.find()) {
            String match = matcherDelegateExecution.group(1);
            variables.put(match, new ProcessVariable(match, element, chapter, fieldType, fileName, VariableOperation.DELETE, scopeId));
        }
        return variables;
    }

    private Map<String, ProcessVariable> findVariablesInExpression(String expression, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        HashMap<String, ProcessVariable> variables = new HashMap<String, ProcessVariable>();
        Pattern pattern = Pattern.compile("\\$\\{(\\w)*\\(.*\\)\\}");
        Matcher matcher = pattern.matcher(expression);
        if (matcher.matches()) {
            return variables;
        }
        try {
            String filteredExpression = expression.replaceAll("[\\w]+\\.", "");
            Builder treeBuilder = new Builder();
            Tree tree = treeBuilder.build(filteredExpression);
            Iterable identifierNodes = tree.getIdentifierNodes();
            for (IdentifierNode node : identifierNodes) {
                String className = this.isBean(node.getName());
                if (className != null) {
                    variables.putAll(this.getVariablesFromJavaDelegate(className, element, chapter, fieldType, scopeId));
                    continue;
                }
                variables.put(node.getName(), new ProcessVariable(node.getName(), element, chapter, fieldType, null, VariableOperation.READ, scopeId));
            }
            variables.putAll(this.searchWrittenProcessVariablesInCode(element, chapter, fieldType, null, scopeId, expression));
            variables.putAll(this.searchRemovedProcessVariablesInCode(element, chapter, fieldType, null, scopeId, expression));
        }
        catch (ELException e) {
            throw new ProcessingException("EL expression " + expression + " in " + element.getProcessdefinition() + ", element ID: " + element.getBaseElement().getId() + ", Type: " + fieldType.getDescription() + " couldn't be parsed", e);
        }
        return variables;
    }

    private ArrayList<String> checkExpressionForReadVariable(String expression, BpmnElement element) {
        ArrayList<String> variables = new ArrayList<String>();
        try {
            String filteredExpression = expression.replaceAll("[\\w]+\\.", "");
            Builder treeBuilder = new Builder();
            Tree tree = treeBuilder.build(filteredExpression);
            Iterable identifierNodes = tree.getIdentifierNodes();
            for (IdentifierNode node : identifierNodes) {
                if (this.isBean(node.getName()) != null) continue;
                variables.add(node.getName());
            }
        }
        catch (ELException e) {
            throw new ProcessingException("EL expression " + expression + " in " + element.getProcessdefinition() + ", element ID: " + element.getBaseElement().getId() + ", Type: " + (Object)((Object)KnownElementFieldType.Expression) + " couldn't be parsed", e);
        }
        return variables;
    }

    private String isBean(String variable) {
        if (RuntimeConfig.getInstance().getBeanMapping() != null) {
            return RuntimeConfig.getInstance().getBeanMapping().get(variable);
        }
        return null;
    }
}

