/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.JsOutputWriter;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import de.viadee.bpm.vPAV.processing.ConfigItemNotFoundException;
import de.viadee.bpm.vPAV.processing.ElementGraphBuilder;
import de.viadee.bpm.vPAV.processing.checker.CheckerFactory;
import de.viadee.bpm.vPAV.processing.checker.ElementChecker;
import de.viadee.bpm.vPAV.processing.checker.ProcessVariablesModelChecker;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.graph.IGraph;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.xml.sax.SAXException;

public class BpmnModelDispatcher {
    private static Logger logger = Logger.getLogger(BpmnModelDispatcher.class.getName());

    private BpmnModelDispatcher() {
    }

    public static Collection<CheckerIssue> dispatchWithVariables(File processdefinition, Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, Map<String, Collection<String>> messageIdToVariables, Map<String, Collection<String>> processIdToVariables, Collection<String> resourcesNewestVersions, Map<String, Rule> conf) throws ConfigItemNotFoundException {
        BpmnScanner bpmnScanner = BpmnModelDispatcher.createScanner(processdefinition);
        BpmnModelInstance modelInstance = Bpmn.readModelFromFile((File)processdefinition);
        Collection baseElements = modelInstance.getModelElementsByType(BaseElement.class);
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(decisionRefToPathMap, processIdToPathMap, messageIdToVariables, processIdToVariables, bpmnScanner);
        Collection<IGraph> graphCollection = graphBuilder.createProcessGraph(modelInstance, processdefinition.getPath(), new ArrayList<String>());
        Map<AnomalyContainer, List<Path>> invalidPathMap = graphBuilder.createInvalidPaths(graphCollection);
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Rule processVariablesModelRule = conf.get(BpmnModelDispatcher.getClassName(ProcessVariablesModelChecker.class));
        if (processVariablesModelRule == null) {
            throw new ConfigItemNotFoundException(BpmnModelDispatcher.getClassName(ProcessVariablesModelChecker.class) + " not found");
        }
        if (processVariablesModelRule.isActive()) {
            ProcessVariablesModelChecker processVarChecker = new ProcessVariablesModelChecker(processVariablesModelRule, invalidPathMap);
            issues.addAll(processVarChecker.check(modelInstance));
        }
        Collection<ElementChecker> checkerInstances = BpmnModelDispatcher.createCheckerSingletons(resourcesNewestVersions, conf, bpmnScanner, issues);
        BpmnModelDispatcher.executeCheckers(processdefinition, baseElements, graphBuilder, issues, checkerInstances);
        BpmnModelDispatcher.writeVarsInJS(processdefinition, baseElements, graphBuilder);
        return issues;
    }

    public static Collection<CheckerIssue> dispatchWithoutVariables(File processdefinition, Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, Collection<String> resourcesNewestVersions, Map<String, Rule> conf) throws ConfigItemNotFoundException {
        BpmnScanner bpmnScanner = BpmnModelDispatcher.createScanner(processdefinition);
        BpmnModelInstance modelInstance = Bpmn.readModelFromFile((File)processdefinition);
        Collection baseElements = modelInstance.getModelElementsByType(BaseElement.class);
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(decisionRefToPathMap, processIdToPathMap, bpmnScanner);
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Collection<ElementChecker> checkerInstances = BpmnModelDispatcher.createCheckerSingletons(resourcesNewestVersions, conf, bpmnScanner, issues);
        BpmnModelDispatcher.executeCheckers(processdefinition, baseElements, graphBuilder, issues, checkerInstances);
        BpmnModelDispatcher.writeVarsInJS(processdefinition, baseElements, graphBuilder);
        return issues;
    }

    private static void executeCheckers(File processdefinition, Collection<BaseElement> baseElements, ElementGraphBuilder graphBuilder, Collection<CheckerIssue> issues, Collection<ElementChecker> checkerInstances) {
        for (BaseElement baseElement : baseElements) {
            BpmnElement element = graphBuilder.getElement(baseElement.getId());
            if (element == null) {
                element = new BpmnElement(processdefinition.getPath(), baseElement);
            }
            for (ElementChecker checker : checkerInstances) {
                issues.addAll(checker.check(element));
            }
        }
    }

    public static BpmnScanner createScanner(File processdefinition) {
        BpmnScanner bpmnScanner;
        try {
            bpmnScanner = new BpmnScanner(processdefinition.getPath());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Model couldn't be parsed");
        }
        return bpmnScanner;
    }

    private static void writeVarsInJS(File processdefinition, Collection<BaseElement> baseElements, ElementGraphBuilder graphBuilder) {
        JsOutputWriter jWriter = new JsOutputWriter();
        try {
            jWriter.writeVars(baseElements, graphBuilder, processdefinition);
        }
        catch (OutputWriterException e) {
            logger.warning("Processvariables couldn't be written");
        }
    }

    private static Collection<ElementChecker> createCheckerSingletons(Collection<String> resourcesNewestVersions, Map<String, Rule> conf, BpmnScanner bpmnScanner, Collection<CheckerIssue> issues) throws ConfigItemNotFoundException {
        Collection<ElementChecker> checkerCollection = CheckerFactory.createCheckerInstances(conf, resourcesNewestVersions, bpmnScanner);
        return checkerCollection;
    }

    private static String getClassName(Class<?> clazz) {
        return clazz.getSimpleName();
    }
}

