/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.output;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.viadee.bpm.vPAV.output.IssueOutputWriter;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;

public class JsonOutputWriter
implements IssueOutputWriter {
    @Override
    public void write(Collection<CheckerIssue> issues) throws OutputWriterException {
        String json = JsonOutputWriter.transformToJsonDatastructure(issues);
        if (json != null && !json.isEmpty()) {
            try {
                OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/bpmn_validation.json"), StandardCharsets.UTF_8);
                osWriter.write(json);
                osWriter.close();
            }
            catch (IOException ex) {
                throw new OutputWriterException("json output couldn't be written");
            }
        }
    }

    private static String transformToJsonDatastructure(Collection<CheckerIssue> issues) {
        JsonArray jsonIssues = new JsonArray();
        if (issues != null && issues.size() > 0) {
            for (CheckerIssue issue : issues) {
                JsonObject obj = new JsonObject();
                obj.addProperty("id", issue.getId());
                obj.addProperty("bpmnFile", issue.getBpmnFile());
                obj.addProperty("ruleName", issue.getRuleName());
                obj.addProperty("ruleDescription", issue.getRuleDescription());
                obj.addProperty("elementId", issue.getElementId());
                obj.addProperty("elementName", issue.getElementName());
                obj.addProperty("classification", issue.getClassification().name());
                obj.addProperty("resourceFile", issue.getResourceFile());
                obj.addProperty("variable", issue.getVariable());
                obj.addProperty("anomaly", issue.getAnomaly() == null ? null : issue.getAnomaly().getDescription());
                JsonArray jsonPaths = new JsonArray();
                List<Path> paths = issue.getInvalidPaths();
                if (paths != null && paths.size() > 0) {
                    for (Path path : paths) {
                        JsonArray jsonPath = new JsonArray();
                        List<BpmnElement> elements = path.getElements();
                        for (BpmnElement element : elements) {
                            JsonObject jsonElement = new JsonObject();
                            String id = element.getBaseElement().getId();
                            String name = element.getBaseElement().getAttributeValue("name");
                            jsonElement.addProperty("elementId", id);
                            jsonElement.addProperty("elementName", name == null ? null : name.replaceAll("\n", ""));
                            jsonPath.add((JsonElement)jsonElement);
                        }
                        jsonPaths.add((JsonElement)jsonPath);
                    }
                }
                obj.add("paths", (JsonElement)jsonPaths);
                obj.addProperty("message", issue.getMessage());
                obj.addProperty("elementDescription", issue.getElementDescription());
                jsonIssues.add((JsonElement)obj);
            }
        }
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonIssues);
    }
}

