/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.output;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.viadee.bpm.vPAV.AbstractRunner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.output.IssueOutputWriter;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import de.viadee.bpm.vPAV.processing.ElementGraphBuilder;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class JsOutputWriter
implements IssueOutputWriter {
    private static Logger logger = Logger.getLogger(JsOutputWriter.class.getName());

    @Override
    public void write(Collection<CheckerIssue> issues) throws OutputWriterException {
        String json = JsOutputWriter.transformToJsonDatastructure(issues, "elementsToMark");
        String json_noIssues = JsOutputWriter.transformToJsonDatastructure(this.getNoIssues(issues), "noIssuesElements");
        String bpmn = this.transformToXMLDatastructure();
        String wrongCheckers = JsOutputWriter.transformToJsDatastructure(AbstractRunner.getIncorrectCheckers());
        String defaultCheckers = JsOutputWriter.transformDefaultRulesToJsDatastructure(this.extractExternalCheckers(RuntimeConfig.getInstance().getActiveRules()));
        String issueSeverity = JsOutputWriter.transformSeverityToJsDatastructure(this.createIssueSeverity(issues));
        String ignoredIssues = this.transformIgnoredIssuesToJsDatastructure(AbstractRunner.getIgnoredIssuesMap());
        this.writeJS(json, json_noIssues, bpmn, wrongCheckers, defaultCheckers, issueSeverity, ignoredIssues);
    }

    private Map<String, CriticalityEnum> createIssueSeverity(Collection<CheckerIssue> issues) {
        HashMap<String, CriticalityEnum> issueSeverity = new HashMap<String, CriticalityEnum>();
        for (CheckerIssue issue : issues) {
            if (!issueSeverity.containsKey(issue.getElementId())) {
                issueSeverity.put(issue.getElementId(), issue.getClassification());
                continue;
            }
            if (!issueSeverity.containsKey(issue.getElementId()) || !((CriticalityEnum)((Object)issueSeverity.get(issue.getElementId()))).equals((Object)CriticalityEnum.WARNING) || !issue.getClassification().equals((Object)CriticalityEnum.ERROR)) continue;
            issueSeverity.put(issue.getElementId(), issue.getClassification());
        }
        return issueSeverity;
    }

    private ArrayList<String> extractExternalCheckers(ArrayList<String> activeRules) {
        ArrayList<String> defaultRules = new ArrayList<String>();
        for (String entry : RuntimeConfig.getInstance().getViadeeRules()) {
            if (!activeRules.contains(entry)) continue;
            defaultRules.add(entry);
        }
        return defaultRules;
    }

    private void writeJS(String json, String json_noIssues, String bpmn, String wrongCheckers, String defaultCheckers, String issueSeverity, String ignoredIssues) throws OutputWriterException {
        if (json != null && !json.isEmpty()) {
            try {
                FileWriter file = new FileWriter("target/vPAV/js/bpmn_model.js");
                file.write(bpmn);
                file.close();
                OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/bpmn_validation.js"), StandardCharsets.UTF_8);
                osWriter.write(json);
                osWriter.close();
                OutputStreamWriter osWriterSuccess = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/bpmn_validation_success.js"), StandardCharsets.UTF_8);
                osWriterSuccess.write(json_noIssues);
                osWriterSuccess.close();
                if (wrongCheckers != null && !wrongCheckers.isEmpty() && defaultCheckers != null && !defaultCheckers.isEmpty()) {
                    OutputStreamWriter wrongAndDefaultCheckers = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/checkers.js"), StandardCharsets.UTF_8);
                    wrongAndDefaultCheckers.write(wrongCheckers);
                    wrongAndDefaultCheckers.write(defaultCheckers);
                    wrongAndDefaultCheckers.close();
                } else if ((wrongCheckers == null || wrongCheckers.isEmpty()) && defaultCheckers != null && !defaultCheckers.isEmpty()) {
                    OutputStreamWriter defaultCheckerJS = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/checkers.js"), StandardCharsets.UTF_8);
                    defaultCheckerJS.write(defaultCheckers);
                    defaultCheckerJS.close();
                }
                if (issueSeverity != null && !issueSeverity.isEmpty()) {
                    OutputStreamWriter issueSeverityWriter = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/issue_severity.js"), StandardCharsets.UTF_8);
                    issueSeverityWriter.write(issueSeverity);
                    issueSeverityWriter.close();
                }
                if (ignoredIssues != null && !ignoredIssues.isEmpty()) {
                    OutputStreamWriter ignoredIssuesWriter = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/ignoredIssues.js"), StandardCharsets.UTF_8);
                    ignoredIssuesWriter.write(ignoredIssues);
                    ignoredIssuesWriter.close();
                }
            }
            catch (IOException ex) {
                throw new OutputWriterException("js output couldn't be written");
            }
        }
    }

    public void writeVars(Collection<BaseElement> baseElements, ElementGraphBuilder graphBuilder, File processdefinition) throws OutputWriterException {
        String modelVariables = "";
        try {
            FileWriter writer = new FileWriter("target/vPAV/js/tmp.js", true);
            for (BaseElement baseElement : baseElements) {
                BpmnElement element = graphBuilder.getElement(baseElement.getId());
                if (element == null) {
                    element = new BpmnElement(processdefinition.getPath(), baseElement);
                }
                modelVariables = modelVariables + this.transformToString(element);
            }
            writer.write(modelVariables);
            writer.close();
        }
        catch (IOException e) {
            logger.warning("Processvariables couldn't be written");
        }
    }

    public static void finish() {
        String jsFile = "var proz_vars = [\n";
        if (new File("target/vPAV/js/tmp.js").exists()) {
            try {
                byte[] encoded = Files.readAllBytes(Paths.get("target/vPAV/js/tmp.js", new String[0]));
                jsFile = jsFile + new String(encoded, "UTF-8");
                if (jsFile.contains(",")) {
                    jsFile = jsFile.length() > 1 ? jsFile.substring(0, jsFile.lastIndexOf(44)) : jsFile;
                }
                jsFile = jsFile + "];";
                new File("target/vPAV/js/tmp.js").delete();
                if (new File("target/vPAV/js/processVariables.js").exists()) {
                    new File("target/vPAV/js/processVariables.js").delete();
                }
                FileWriter writer = new FileWriter("target/vPAV/js/processVariables.js", false);
                writer.write(jsFile);
                writer.close();
            }
            catch (IOException e) {
                logger.warning("Processvariables couldn't be written");
            }
        }
    }

    private String transformToString(BpmnElement element) {
        String elementString = "";
        String read = "";
        String write = "";
        String delete = "";
        if (!element.getProcessVariables().isEmpty()) {
            elementString = elementString + "{\n\"elementId\" : \"" + element.getBaseElement().getId() + "\",\n";
            elementString = elementString + "\"bpmnFile\" : \"" + JsOutputWriter.replace(File.separator, "\\\\", element.getProcessdefinition()) + "\",\n";
            if (element.getBaseElement().getAttributeValue("name") != null) {
                elementString = elementString + "\"elementName\" : \"" + element.getBaseElement().getAttributeValue("name").trim().replace('\n', ' ') + "\",\n";
            }
            for (Map.Entry<String, ProcessVariable> entry : element.getProcessVariables().entrySet()) {
                entry.getValue().getOperation();
                if (entry.getValue().getOperation().equals((Object)VariableOperation.READ)) {
                    read = read + "\"" + entry.getValue().getName() + "\",";
                }
                if (entry.getValue().getOperation().equals((Object)VariableOperation.WRITE)) {
                    write = write + "\"" + entry.getValue().getName() + "\",";
                }
                if (!entry.getValue().getOperation().equals((Object)VariableOperation.DELETE)) continue;
                delete = delete + "\"" + entry.getValue().getName() + "\",";
            }
            elementString = elementString + "\"read\" : [" + (read.length() > 1 ? read.substring(0, read.length() - 1) : read) + "],\n";
            elementString = elementString + "\"write\" : [" + (write.length() > 1 ? write.substring(0, write.length() - 1) : write) + "],\n";
            elementString = elementString + "\"delete\" : [" + (delete.length() > 1 ? delete.substring(0, delete.length() - 1) : delete) + "]\n";
            elementString = elementString + "},\n\n";
        }
        return elementString;
    }

    private Collection<CheckerIssue> getNoIssues(Collection<CheckerIssue> issues) {
        ArrayList<CheckerIssue> newIssues = new ArrayList<CheckerIssue>();
        for (String bpmnFilename : AbstractRunner.getModelPath()) {
            ArrayList<CheckerIssue> modelIssues = new ArrayList<CheckerIssue>();
            modelIssues.addAll(issues);
            for (CheckerIssue issue : issues) {
                String prettyBpmnFilename = JsOutputWriter.replace(File.separator, "\\", issue.getBpmnFile());
                if (prettyBpmnFilename.equals("src\\main\\resources\\" + bpmnFilename)) continue;
                modelIssues.remove(issue);
            }
            for (String ruleName : RuntimeConfig.getInstance().getActiveRules()) {
                ArrayList<CheckerIssue> ruleIssues = new ArrayList<CheckerIssue>();
                ruleIssues.addAll(modelIssues);
                for (CheckerIssue issue : modelIssues) {
                    if (issue.getRuleName().equals(ruleName)) continue;
                    ruleIssues.remove(issue);
                }
                if (!ruleIssues.isEmpty()) continue;
                newIssues.add(new CheckerIssue(ruleName, null, CriticalityEnum.SUCCESS, "src\\main\\resources\\" + bpmnFilename, null, "", "", null, null, null, "No issues found", null));
            }
        }
        return newIssues;
    }

    private String transformToXMLDatastructure() throws OutputWriterException {
        String output = "var diagramXMLSource = [\n";
        try {
            for (String bpmnFilename : AbstractRunner.getModelPath()) {
                String prettyBpmnFileName = JsOutputWriter.replace(File.separator, "\\\\", bpmnFilename);
                output = output + "{\"name\":\"" + prettyBpmnFileName + "\",\n \"xml\": \"";
                output = output + this.convertBpmnFile("src/main/resources/" + bpmnFilename);
                output = output + "\"},\n";
            }
        }
        catch (IOException e) {
            throw new OutputWriterException("bpmnFile not found");
        }
        return output + "];\n";
    }

    private static String replace(String search, String replace, String str) {
        int start = str.indexOf(search);
        while (start != -1) {
            str = str.substring(0, start) + replace + str.substring(start + search.length(), str.length());
            start = str.indexOf(search, start + replace.length());
        }
        return str;
    }

    private String convertBpmnFile(String path) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        String s = new String(encoded);
        s = s.replace("\"", "\\\"");
        s = s.replace('\n', ' ');
        s = s.replace('\r', ' ');
        s = s.replaceAll(">\\u0020*<", "><");
        s = s.replaceAll(">\\u0027*<", "><");
        return s;
    }

    private static String transformToJsonDatastructure(Collection<CheckerIssue> issues, String varName) {
        JsonArray jsonIssues = new JsonArray();
        if (issues != null && issues.size() > 0) {
            for (CheckerIssue issue : issues) {
                JsonObject obj = new JsonObject();
                obj.addProperty("id", issue.getId());
                obj.addProperty("bpmnFile", JsOutputWriter.replace(File.separator, "\\", issue.getBpmnFile()));
                obj.addProperty("ruleName", issue.getRuleName());
                obj.addProperty("ruleDescription", issue.getRuleDescription());
                obj.addProperty("elementId", issue.getElementId());
                obj.addProperty("elementName", issue.getElementName());
                obj.addProperty("classification", issue.getClassification().name());
                obj.addProperty("resourceFile", issue.getResourceFile());
                obj.addProperty("variable", issue.getVariable());
                obj.addProperty("anomaly", issue.getAnomaly() == null ? null : issue.getAnomaly().getDescription());
                JsonArray jsonPaths = new JsonArray();
                List<Path> paths = issue.getInvalidPaths();
                if (paths != null && paths.size() > 0) {
                    for (Path path : paths) {
                        JsonArray jsonPath = new JsonArray();
                        List<BpmnElement> elements = path.getElements();
                        for (BpmnElement element : elements) {
                            JsonObject jsonElement = new JsonObject();
                            String id = element.getBaseElement().getId();
                            String name = element.getBaseElement().getAttributeValue("name");
                            jsonElement.addProperty("elementId", id);
                            jsonElement.addProperty("elementName", name == null ? null : name.replaceAll("\n", ""));
                            jsonPath.add((JsonElement)jsonElement);
                        }
                        jsonPaths.add((JsonElement)jsonPath);
                    }
                }
                obj.add("paths", (JsonElement)jsonPaths);
                obj.addProperty("message", issue.getMessage());
                obj.addProperty("elementDescription", issue.getElementDescription());
                jsonIssues.add((JsonElement)obj);
            }
        }
        return "var " + varName + " = " + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonIssues) + ";";
    }

    private static String transformToJsDatastructure(Map<String, String> wrongCheckers) {
        String varName = "unlocatedCheckers";
        JsonArray jsonIssues = new JsonArray();
        if (wrongCheckers != null && wrongCheckers.size() > 0) {
            for (Map.Entry<String, String> entry : wrongCheckers.entrySet()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("rulename", entry.getKey());
                obj.addProperty("message", entry.getValue());
                jsonIssues.add((JsonElement)obj);
            }
        }
        return "var unlocatedCheckers = " + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonIssues) + ";";
    }

    private static String transformSeverityToJsDatastructure(Map<String, CriticalityEnum> issues) {
        String varName = "issueSeverity";
        JsonArray jsonIssues = new JsonArray();
        if (issues != null && issues.size() > 0) {
            for (Map.Entry<String, CriticalityEnum> entry : issues.entrySet()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("id", entry.getKey());
                obj.addProperty("Criticality", entry.getValue().name().toString());
                jsonIssues.add((JsonElement)obj);
            }
        }
        return "var issueSeverity = " + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonIssues) + ";";
    }

    private String transformIgnoredIssuesToJsDatastructure(Map<String, String> ignoredIssues) {
        String ignoredIssuesList = "ignoredIssues";
        JsonArray ignoredIssesJson = new JsonArray();
        if (ignoredIssues != null && ignoredIssues.size() > 0) {
            for (Map.Entry<String, String> entry : ignoredIssues.entrySet()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("ID", entry.getKey());
                obj.addProperty("Comment", entry.getValue());
                ignoredIssesJson.add((JsonElement)obj);
            }
        }
        return "var ignoredIssues = " + new GsonBuilder().setPrettyPrinting().create().toJson(ignoredIssues) + ";";
    }

    private static String transformDefaultRulesToJsDatastructure(ArrayList<String> defaultCheckers) {
        String varName = "defaultCheckers";
        JsonArray jsonIssues = new JsonArray();
        if (defaultCheckers != null && defaultCheckers.size() > 0) {
            for (String entry : defaultCheckers) {
                JsonObject obj = new JsonObject();
                obj.addProperty("rulename", entry);
                jsonIssues.add((JsonElement)obj);
            }
        }
        return "\n var defaultCheckers = " + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonIssues) + ";";
    }
}

