/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.Setting;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.springframework.context.ApplicationContext;

public class RuntimeConfig {
    private static RuntimeConfig instance;
    private ApplicationContext ctx;
    private Map<String, String> beanMap;
    private ClassLoader classLoader;
    private ResourceBundle resourceBundle;
    private boolean test = false;
    private static Logger logger;
    private final String[] viadeeRules = new String[]{"XorConventionChecker", "TimerExpressionChecker", "JavaDelegateChecker", "NoScriptChecker", "NoExpressionChecker", "EmbeddedGroovyScriptChecker", "VersioningChecker", "DmnTaskChecker", "ProcessVariablesModelChecker", "ProcessVariablesNameConventionChecker", "TaskNamingConventionChecker", "ElementIdConventionChecker", "MessageEventChecker", "FieldInjectionChecker", "BoundaryErrorChecker", "ExtensionChecker", "OverlapChecker", "SignalEventChecker"};
    private ArrayList<String> allActiveRules = new ArrayList();

    private RuntimeConfig() {
    }

    public static RuntimeConfig getInstance() {
        if (instance == null) {
            instance = new RuntimeConfig();
        }
        return instance;
    }

    public String findBeanByName(String string) {
        if (string != null && !string.isEmpty() && this.beanMap != null && !this.beanMap.isEmpty()) {
            return this.beanMap.get(string);
        }
        return null;
    }

    public void setBeanMapping(Map<String, String> beanMap) {
        this.beanMap = beanMap;
    }

    public Map<String, String> getBeanMapping() {
        return this.beanMap;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public ArrayList<String> getActiveRules() {
        return this.allActiveRules;
    }

    public String[] getViadeeRules() {
        return this.viadeeRules;
    }

    public void addActiveRules(Map<String, Rule> rules) {
        for (Map.Entry<String, Rule> entry : rules.entrySet()) {
            Rule rule = entry.getValue();
            if (!rule.isActive() || rule.getName().equals("HasParentRuleSet")) continue;
            this.allActiveRules.add(rule.getName());
        }
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public ApplicationContext getApplicationContext() {
        return this.ctx;
    }

    public void retrieveLocale(Map<String, Rule> rules) throws MalformedURLException {
        try {
            Rule rule = rules.get("language");
            Map<String, Setting> settings = rule.getSettings();
            if (settings.get("locale").getValue().equals("de")) {
                this.getResource("de_DE");
            } else if (settings.get("locale").getValue().equals("en")) {
                this.getResource("en_US");
            }
        }
        catch (NullPointerException e) {
            if (Locale.getDefault().toString().equals("de_DE")) {
                logger.warning("Could not retrieve localization from ruleSet.xml. Default localization: de_DE.");
                this.getResource("de_DE");
            }
            logger.warning("Could not retrieve localization from ruleSet.xml. Default localization: en_US.");
            this.getResource("en_US");
        }
    }

    public void getResource(String locale) throws MalformedURLException {
        this.setResourceBundle(RuntimeConfig.fromClassLoader("messages_" + locale));
    }

    private static ResourceBundle fromClassLoader(String bundleName) throws MalformedURLException {
        URLClassLoader ucl = RuntimeConfig.getInstance().getClassLoader() instanceof URLClassLoader ? (URLClassLoader)RuntimeConfig.getInstance().getClassLoader() : (URLClassLoader)RuntimeConfig.getInstance().getClassLoader().getParent();
        URL[] urls = ucl.getURLs();
        URLClassLoader loader = new URLClassLoader(urls);
        return ResourceBundle.getBundle(bundleName, Locale.getDefault(), loader);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    static {
        logger = Logger.getLogger(RuntimeConfig.class.getName());
    }
}

