/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.RuntimeConfig;
import groovyjarjarasm.asm.ClassReader;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.FieldVisitor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Resource;

public class OuterProcessVariablesScanner {
    private Set<String> javaResources;
    private Map<String, Collection<String>> messageIdToVariableMap = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> processIdToVariableMap = new HashMap<String, Collection<String>>();

    public OuterProcessVariablesScanner(Set<String> javaResources) {
        this.javaResources = javaResources;
    }

    public void scanProcessVariables() throws IOException {
        for (String filePath : this.javaResources) {
            Collection<String> initialProcessVariablesInFilePath;
            String content;
            if (filePath.startsWith("javax") || (content = this.readResourceFile(filePath)) == null || (initialProcessVariablesInFilePath = this.readVariablesOfInnerClassInitialProcessVariables(filePath)).isEmpty()) continue;
            HashSet<String> messageIds = new HashSet<String>();
            messageIds.addAll(this.checkStartProcessByMessageIdPattern(content));
            messageIds.addAll(this.checkCorrelateMessagePattern(content));
            for (String messageId : messageIds) {
                if (this.messageIdToVariableMap.containsKey(messageId)) {
                    Collection<String> existingProcessVariables = this.messageIdToVariableMap.get(messageId);
                    List intersectionProcessVariables = ListUtils.intersection((List)((List)existingProcessVariables), (List)((List)initialProcessVariablesInFilePath));
                    this.messageIdToVariableMap.put(messageId, intersectionProcessVariables);
                    continue;
                }
                this.messageIdToVariableMap.put(messageId, initialProcessVariablesInFilePath);
            }
            Collection<String> processIds = this.checkStartProcessByKeyPattern(content);
            for (String processId : processIds) {
                this.processIdToVariableMap.put(processId, initialProcessVariablesInFilePath);
            }
        }
    }

    public Map<String, Collection<String>> getMessageIdToVariableMap() {
        return this.messageIdToVariableMap;
    }

    public Map<String, Collection<String>> getProcessIdToVariableMap() {
        return this.processIdToVariableMap;
    }

    private String readResourceFile(String filePath) {
        String methodBody = "";
        if (filePath != null && filePath.trim().length() > 0) {
            try {
                DirectoryScanner scanner = new DirectoryScanner();
                if (RuntimeConfig.getInstance().isTest()) {
                    scanner.setBasedir("src/test/java/");
                } else {
                    scanner.setBasedir("src/main/java/");
                }
                Resource s = scanner.getResource(filePath);
                if (s.isExists()) {
                    InputStreamReader resource = new InputStreamReader(new FileInputStream(s.toString()));
                    methodBody = IOUtils.toString((Reader)resource);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("resource '" + filePath + "' could not be read: " + ex.getMessage());
            }
        }
        return methodBody;
    }

    private Collection<String> checkStartProcessByMessageIdPattern(String code) {
        String FILTER_PATTERN = "'|\"| ";
        String cleanedCode = code.replaceAll("'|\"| ", "");
        Pattern pattern = Pattern.compile("\\.startProcessInstanceByMessage\\((\\w+),(.*)");
        Matcher matcher = pattern.matcher(cleanedCode);
        ArrayList<String> messageIds = new ArrayList<String>();
        while (matcher.find()) {
            String match = matcher.group(1);
            messageIds.add(match);
        }
        return messageIds;
    }

    private Collection<String> checkStartProcessByKeyPattern(String code) {
        String FILTER_PATTERN = "'|\"| ";
        String cleanedCode = code.replaceAll("'|\"| ", "");
        Pattern pattern = Pattern.compile("\\.startProcessInstanceByKey\\((\\w+),(.*)");
        Matcher matcher = pattern.matcher(cleanedCode);
        ArrayList<String> processIds = new ArrayList<String>();
        while (matcher.find()) {
            String match = matcher.group(1);
            processIds.add(match);
        }
        return processIds;
    }

    private Collection<String> checkCorrelateMessagePattern(String code) {
        String FILTER_PATTERN = "'|\"| ";
        String cleanedCode = code.replaceAll("'|\"| ", "");
        Pattern pattern = Pattern.compile("\\.correlateMessage\\((\\w+),(.*)");
        Matcher matcher = pattern.matcher(cleanedCode);
        ArrayList<String> messageIds = new ArrayList<String>();
        while (matcher.find()) {
            String match = matcher.group(1);
            messageIds.add(match);
        }
        return messageIds;
    }

    private Collection<String> readVariablesOfInnerClassInitialProcessVariables(String filePath) throws IOException {
        String[] splittedFilePath;
        final ArrayList<String> processVariables = new ArrayList<String>();
        if (filePath != null && (splittedFilePath = filePath.split("\\.")).length > 0) {
            ClassVisitor cl = new ClassVisitor(262144){

                public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                    if (!name.startsWith("this")) {
                        processVariables.add(name);
                    }
                    super.visitField(access, name, desc, signature, value);
                    return null;
                }
            };
            InputStream in = RuntimeConfig.getInstance().getClassLoader().getResourceAsStream(splittedFilePath[0] + "$InitialProcessVariables.class");
            if (in != null) {
                ClassReader classReader = new ClassReader(in);
                classReader.accept(cl, 0);
            }
        }
        return processVariables;
    }
}

