/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.OuterProcessVariablesScanner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.reader.ConfigReaderException;
import de.viadee.bpm.vPAV.config.reader.XmlConfigReader;
import de.viadee.bpm.vPAV.output.JsOutputWriter;
import de.viadee.bpm.vPAV.output.JsonOutputWriter;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import de.viadee.bpm.vPAV.output.RuleSetOutputWriter;
import de.viadee.bpm.vPAV.output.XmlOutputWriter;
import de.viadee.bpm.vPAV.processing.BpmnModelDispatcher;
import de.viadee.bpm.vPAV.processing.ConfigItemNotFoundException;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public abstract class AbstractRunner {
    private static Logger logger = Logger.getLogger(AbstractRunner.class.getName());
    private static FileScanner fileScanner;
    private static OuterProcessVariablesScanner variableScanner;
    private static Collection<CheckerIssue> issues;
    private static Collection<CheckerIssue> filteredIssues;
    private static Map<String, String> ignoredIssuesMap;
    private static Map<String, String> incorrectCheckers;
    private static Map<String, String> fileMapping;
    private static ArrayList<String> allOutputFilesArray;
    private static Map<String, ArrayList<String>> sequenceFlowList;
    private static Map<String, BaseElement> signalNames;
    private static boolean isMisconfigured;
    private static boolean checkProcessVariables;

    public static void viadeeProcessApplicationValidator() {
        Map<String, Rule> rules = AbstractRunner.readConfig();
        AbstractRunner.scanClassPath(rules);
        AbstractRunner.getProcessVariables(rules);
        AbstractRunner.createIssues(rules);
        AbstractRunner.removeIgnoredIssues();
        AbstractRunner.writeOutput(filteredIssues);
        AbstractRunner.copyFiles();
        logger.info("BPMN validation successfully completed");
    }

    private static Map<String, Rule> readConfig() {
        AbstractRunner.createBaseFolder();
        Map<String, Rule> rules = new XmlConfigReader().getDeactivatedRuleSet();
        RuleSetOutputWriter ruleSetOutputWriter = new RuleSetOutputWriter();
        try {
            if (new File("src/test/resources/ruleSet.xml").exists()) {
                Map<String, Rule> localRule = new XmlConfigReader().read("ruleSet.xml");
                if (localRule.containsKey("HasParentRuleSet") && localRule.get("HasParentRuleSet").isActive()) {
                    rules = AbstractRunner.mergeRuleSet(rules, new XmlConfigReader().read("parentRuleSet.xml"));
                    rules = AbstractRunner.mergeRuleSet(rules, localRule);
                } else {
                    rules = AbstractRunner.mergeRuleSet(rules, localRule);
                }
            } else {
                rules = new XmlConfigReader().read("ruleSetDefault.xml");
            }
            ruleSetOutputWriter.write(rules);
            RuntimeConfig.getInstance().addActiveRules(rules);
        }
        catch (ConfigReaderException | OutputWriterException e) {
            throw new RuntimeException(e);
        }
        rules.remove("HasParentRuleSet");
        try {
            RuntimeConfig.getInstance().retrieveLocale(rules);
        }
        catch (MalformedURLException e) {
            logger.warning("Could not read language files. No localization available");
        }
        return rules;
    }

    private static Map<String, Rule> mergeRuleSet(Map<String, Rule> parentRules, Map<String, Rule> childRules) {
        HashMap<String, Rule> finalRules = new HashMap<String, Rule>();
        finalRules.putAll(parentRules);
        finalRules.putAll(childRules);
        return finalRules;
    }

    private static void scanClassPath(Map<String, Rule> rules) {
        fileScanner = new FileScanner(rules);
    }

    private static void getProcessVariables(Map<String, Rule> rules) {
        if (rules.get("ProcessVariablesModelChecker").isActive() || rules.get("ProcessVariablesNameConventionChecker").isActive()) {
            variableScanner = new OuterProcessVariablesScanner(fileScanner.getJavaResourcesFileInputStream());
            AbstractRunner.readOuterProcessVariables(variableScanner);
            AbstractRunner.setCheckProcessVariables(true);
        } else {
            AbstractRunner.setCheckProcessVariables(false);
        }
    }

    private static void createIssues(Map<String, Rule> rules) throws RuntimeException {
        issues = AbstractRunner.checkModels(rules, fileScanner, variableScanner);
    }

    private static void removeIgnoredIssues() throws RuntimeException {
        filteredIssues = AbstractRunner.filterIssues(issues);
    }

    private static void writeOutput(Collection<CheckerIssue> filteredIssues) throws RuntimeException {
        if (filteredIssues.size() > 0) {
            XmlOutputWriter xmlOutputWriter = new XmlOutputWriter();
            JsonOutputWriter jsonOutputWriter = new JsonOutputWriter();
            JsOutputWriter jsOutputWriter = new JsOutputWriter();
            try {
                xmlOutputWriter.write(filteredIssues);
                jsonOutputWriter.write(filteredIssues);
                jsOutputWriter.write(filteredIssues);
            }
            catch (OutputWriterException e) {
                throw new RuntimeException("Output couldn't be written");
            }
        }
        ArrayList<Path> validationFiles = new ArrayList<Path>();
        validationFiles.add(Paths.get("target/vPAV/js/bpmn_validation.js", new String[0]));
        validationFiles.add(Paths.get("target/vPAV/bpmn_validation.json", new String[0]));
        validationFiles.add(Paths.get("target/vPAV/bpmn_validation.xml", new String[0]));
        AbstractRunner.deleteFiles(validationFiles);
        JsOutputWriter jsOutputWriter = new JsOutputWriter();
        try {
            jsOutputWriter.write(filteredIssues);
        }
        catch (OutputWriterException e) {
            throw new RuntimeException("JavaScript File couldn't be written");
        }
    }

    private static void createBaseFolder() throws RuntimeException {
        AbstractRunner.createvPAVFolder();
        AbstractRunner.createImgFolder();
        AbstractRunner.createCssFolder();
        AbstractRunner.createJsFolder();
    }

    private static void createvPAVFolder() {
        boolean success;
        File vPavDir = new File("target/vPAV/");
        if (!vPavDir.exists() && !(success = vPavDir.mkdirs())) {
            throw new RuntimeException("vPAV directory does not exist and could not be created");
        }
    }

    private static void createImgFolder() {
        boolean success;
        File imgDir = new File("target/vPAV/img/");
        if (!imgDir.exists() && !(success = imgDir.mkdirs())) {
            throw new RuntimeException("vPAV/img directory does not exist and could not be created");
        }
    }

    private static void createJsFolder() {
        boolean success;
        File jsDir = new File("target/vPAV/js/");
        if (!jsDir.exists() && !(success = jsDir.mkdirs())) {
            throw new RuntimeException("vPAV/js directory does not exist and could not be created");
        }
    }

    private static void createCssFolder() {
        boolean success;
        File cssDir = new File("target/vPAV/css/");
        if (!cssDir.exists() && !(success = cssDir.mkdirs())) {
            throw new RuntimeException("vPAV/css directory does not exist and could not be created");
        }
    }

    private static void deleteFiles(ArrayList<Path> destinations) {
        for (Path destination : destinations) {
            if (!destination.toFile().exists()) continue;
            destination.toFile().delete();
        }
    }

    private static void copyFiles() throws RuntimeException {
        ArrayList<Path> outputFiles = new ArrayList<Path>();
        for (String file : allOutputFilesArray) {
            outputFiles.add(Paths.get(fileMapping.get(file), file));
        }
        AbstractRunner.deleteFiles(outputFiles);
        for (String file : allOutputFilesArray) {
            AbstractRunner.copyFileToVPAVFolder(file);
        }
    }

    private static ArrayList<String> createAllOutputFilesArray() {
        ArrayList<String> allFiles = new ArrayList<String>();
        allFiles.add("bootstrap.min.js");
        allFiles.add("bpmn-navigated-viewer.js");
        allFiles.add("bpmn.io.viewer.app.js");
        allFiles.add("jquery-3.2.1.min.js");
        allFiles.add("popper.min.js");
        allFiles.add("infoPOM.js");
        allFiles.add("download.js");
        allFiles.add("bootstrap.min.css");
        allFiles.add("viadee.css");
        allFiles.add("MarkerStyle.css");
        allFiles.add("vPAV.png");
        allFiles.add("viadee_weiss.png");
        allFiles.add("GitHub.png");
        allFiles.add("error.png");
        allFiles.add("warning.png");
        allFiles.add("info.png");
        allFiles.add("success.png");
        allFiles.add("dl_button.png");
        allFiles.add("validationResult.html");
        return allFiles;
    }

    private static Map<String, String> createFileFolderMapping() {
        HashMap<String, String> fMap = new HashMap<String, String>();
        fMap.put("bootstrap.min.js", "target/vPAV/js/");
        fMap.put("bpmn-navigated-viewer.js", "target/vPAV/js/");
        fMap.put("bpmn.io.viewer.app.js", "target/vPAV/js/");
        fMap.put("jquery-3.2.1.min.js", "target/vPAV/js/");
        fMap.put("popper.min.js", "target/vPAV/js/");
        fMap.put("infoPOM.js", "target/vPAV/js/");
        fMap.put("download.js", "target/vPAV/js/");
        fMap.put("bootstrap.min.css", "target/vPAV/css/");
        fMap.put("viadee.css", "target/vPAV/css/");
        fMap.put("MarkerStyle.css", "target/vPAV/css/");
        fMap.put("vPAV.png", "target/vPAV/img/");
        fMap.put("viadee_weiss.png", "target/vPAV/img/");
        fMap.put("GitHub.png", "target/vPAV/img/");
        fMap.put("error.png", "target/vPAV/img/");
        fMap.put("warning.png", "target/vPAV/img/");
        fMap.put("info.png", "target/vPAV/img/");
        fMap.put("success.png", "target/vPAV/img/");
        fMap.put("dl_button.png", "target/vPAV/img/");
        fMap.put("validationResult.html", "target/vPAV/");
        return fMap;
    }

    private static void copyFileToVPAVFolder(String file) throws RuntimeException {
        InputStream source = AbstractRunner.class.getClassLoader().getResourceAsStream(file);
        Path destination = Paths.get(fileMapping.get(file) + file, new String[0]);
        try {
            Files.copy(source, destination, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Files couldn't be written");
        }
    }

    private static Collection<CheckerIssue> filterIssues(Collection<CheckerIssue> issues) throws RuntimeException {
        Collection<CheckerIssue> filteredIssues;
        try {
            filteredIssues = AbstractRunner.getFilteredIssues(issues);
        }
        catch (IOException e) {
            throw new RuntimeException("Ignored issues couldn't be read successfully", e);
        }
        Collections.sort((List)filteredIssues);
        return filteredIssues;
    }

    private static Collection<CheckerIssue> getFilteredIssues(Collection<CheckerIssue> issues) throws IOException {
        HashMap<String, CheckerIssue> issuesMap = new HashMap<String, CheckerIssue>();
        for (CheckerIssue issue : issues) {
            if (issuesMap.containsKey(issue.getId())) continue;
            issuesMap.put(issue.getId(), issue);
        }
        Collection<String> ignoredIssues = AbstractRunner.collectIgnoredIssues("src/test/resources/ignoreIssues.txt");
        HashMap<String, CheckerIssue> filteredIssues = new HashMap<String, CheckerIssue>();
        filteredIssues.putAll(issuesMap);
        for (Map.Entry entry : issuesMap.entrySet()) {
            if (!ignoredIssues.contains(entry.getKey())) continue;
            filteredIssues.remove(entry.getKey());
        }
        ArrayList<CheckerIssue> finalFilteredIssues = new ArrayList<CheckerIssue>();
        for (Map.Entry entry : filteredIssues.entrySet()) {
            finalFilteredIssues.add((CheckerIssue)entry.getValue());
        }
        return finalFilteredIssues;
    }

    private static Collection<String> collectIgnoredIssues(String filePath) throws IOException {
        Map<String, String> ignoredIssuesMap = AbstractRunner.getIgnoredIssuesMap();
        ArrayList<String> ignoredIssues = new ArrayList<String>();
        FileReader fileReader = AbstractRunner.createFileReader(filePath);
        if (fileReader != null) {
            String zeile;
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String prevLine = zeile = bufferedReader.readLine();
            while (zeile != null) {
                AbstractRunner.addIgnoredIssue(ignoredIssuesMap, ignoredIssues, zeile, prevLine);
                prevLine = zeile;
                zeile = bufferedReader.readLine();
            }
            bufferedReader.close();
            fileReader.close();
        }
        return ignoredIssues;
    }

    private static FileReader createFileReader(String filePath) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader("src/test/resources/.ignoreIssues");
            if (fileReader != null) {
                logger.warning("Usage of .ignoreIssues is deprecated. Please use ignoreIssues.txt to whitelist issues.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            fileReader = new FileReader(filePath);
        }
        catch (FileNotFoundException ex) {
            logger.info(ex.getMessage());
        }
        return fileReader;
    }

    private static Collection<CheckerIssue> checkModels(Map<String, Rule> rules, FileScanner fileScanner, OuterProcessVariablesScanner variableScanner) throws RuntimeException {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (String pathToModel : fileScanner.getProcessdefinitions()) {
            issues.addAll(AbstractRunner.checkModel(rules, pathToModel, fileScanner, variableScanner));
            AbstractRunner.resetSequenceFlowList();
        }
        AbstractRunner.checkMisconfiguration();
        JsOutputWriter.finish();
        return issues;
    }

    private static Collection<CheckerIssue> checkModel(Map<String, Rule> rules, String processdef, FileScanner fileScanner, OuterProcessVariablesScanner variableScanner) throws RuntimeException {
        Collection<Object> modelIssues = new ArrayList();
        try {
            modelIssues = variableScanner != null ? BpmnModelDispatcher.dispatchWithVariables(new File("src/main/resources/" + processdef), fileScanner.getDecisionRefToPathMap(), fileScanner.getProcessIdToPathMap(), variableScanner.getMessageIdToVariableMap(), variableScanner.getProcessIdToVariableMap(), fileScanner.getResourcesNewestVersions(), rules) : BpmnModelDispatcher.dispatchWithoutVariables(new File("src/main/resources/" + processdef), fileScanner.getDecisionRefToPathMap(), fileScanner.getProcessIdToPathMap(), fileScanner.getResourcesNewestVersions(), rules);
        }
        catch (ConfigItemNotFoundException e) {
            throw new RuntimeException("Config item couldn't be read");
        }
        return modelIssues;
    }

    private static void readOuterProcessVariables(OuterProcessVariablesScanner scanner) throws RuntimeException {
        try {
            scanner.scanProcessVariables();
        }
        catch (IOException e) {
            throw new RuntimeException("Outer process variables couldn't be read: " + e.getMessage());
        }
    }

    private static void checkMisconfiguration() {
        if (AbstractRunner.getIsMisconfigured()) {
            logger.warning("Misconfiguration of rule for ExtensionChecker. Please provide either tasktype or a specific ID of an element.");
        }
    }

    private static Map<String, String> addIgnoredIssue(Map<String, String> ignoredIssuesMap, Collection<String> issues, String row, String prevLine) {
        if (row != null && !row.isEmpty() && !row.trim().startsWith("#")) {
            ignoredIssuesMap.put(row, prevLine);
            issues.add(row);
        }
        return ignoredIssuesMap;
    }

    public static Set<String> getModelPath() {
        return fileScanner.getProcessdefinitions();
    }

    public static Collection<CheckerIssue> getfilteredIssues() {
        return filteredIssues;
    }

    public static boolean getIsMisconfigured() {
        return isMisconfigured;
    }

    public static void setIsMisconfigured(boolean isMisconfigured) {
        AbstractRunner.isMisconfigured = isMisconfigured;
    }

    public static Map<String, ArrayList<String>> getSequenceFlowList() {
        return sequenceFlowList;
    }

    public static void addToSequenceFlowList(String id, ArrayList<String> sequenceFlowList) {
        AbstractRunner.sequenceFlowList.put(id, sequenceFlowList);
    }

    public static void resetSequenceFlowList() {
        sequenceFlowList.clear();
    }

    public static boolean addSignal(BaseElement baseElement, String name) {
        if (!signalNames.containsKey(name)) {
            signalNames.put(name, baseElement);
            return true;
        }
        return false;
    }

    public static BaseElement getSignal(String name) {
        return signalNames.get(name);
    }

    public static void removeElement(String name) {
        signalNames.remove(name);
    }

    public static Map<String, String> getIncorrectCheckers() {
        return incorrectCheckers;
    }

    public static void setIncorrectCheckers(Map.Entry<String, Rule> rule, String message) {
        if (!AbstractRunner.getIncorrectCheckers().containsKey(rule.getValue().getName())) {
            incorrectCheckers.put(rule.getValue().getName(), message);
        }
    }

    public static Map<String, String> getIgnoredIssuesMap() {
        return ignoredIssuesMap;
    }

    public static void setIgnoredIssuesMap(Map<String, String> ignoredIssuesMap) {
        AbstractRunner.ignoredIssuesMap = ignoredIssuesMap;
    }

    public static boolean isCheckProcessVariables() {
        return checkProcessVariables;
    }

    public static void setCheckProcessVariables(boolean checkProcessVariables) {
        AbstractRunner.checkProcessVariables = checkProcessVariables;
    }

    static {
        ignoredIssuesMap = new HashMap<String, String>();
        incorrectCheckers = new HashMap<String, String>();
        fileMapping = AbstractRunner.createFileFolderMapping();
        allOutputFilesArray = AbstractRunner.createAllOutputFilesArray();
        sequenceFlowList = new HashMap<String, ArrayList<String>>();
        signalNames = new HashMap<String, BaseElement>();
        isMisconfigured = false;
        checkProcessVariables = false;
    }
}

