/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.model.graph;

import de.viadee.bpm.vPAV.processing.model.data.Anomaly;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.InOutState;
import de.viadee.bpm.vPAV.processing.model.graph.Edge;
import de.viadee.bpm.vPAV.processing.model.graph.IGraph;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import de.viadee.bpm.vPAV.processing.model.graph.VertexInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Graph
implements IGraph {
    private String processId;
    private Map<BpmnElement, List<Edge>> adjacencyListSucessor;
    private Map<BpmnElement, List<Edge>> adjacencyListPredecessor;
    private Map<BpmnElement, VertexInfo> vertexInfo;
    private Collection<BpmnElement> startNodes = new ArrayList<BpmnElement>();
    private Collection<BpmnElement> endNodes = new ArrayList<BpmnElement>();

    public Graph(String processId) {
        this.processId = processId;
        this.adjacencyListSucessor = new HashMap<BpmnElement, List<Edge>>();
        this.adjacencyListPredecessor = new HashMap<BpmnElement, List<Edge>>();
        this.vertexInfo = new HashMap<BpmnElement, VertexInfo>();
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    @Override
    public void addStartNode(BpmnElement node) {
        this.startNodes.add(node);
    }

    @Override
    public Collection<BpmnElement> getStartNodes() {
        return this.startNodes;
    }

    @Override
    public void addEndNode(BpmnElement node) {
        this.endNodes.add(node);
    }

    @Override
    public Collection<BpmnElement> getEndNodes() {
        return this.endNodes;
    }

    @Override
    public void addVertex(BpmnElement v) {
        if (v == null) {
            throw new IllegalArgumentException("null");
        }
        this.adjacencyListSucessor.put(v, new ArrayList());
        this.adjacencyListPredecessor.put(v, new ArrayList());
        this.vertexInfo.put(v, new VertexInfo(v));
    }

    @Override
    public Collection<BpmnElement> getVertices() {
        return this.vertexInfo.keySet();
    }

    @Override
    public Collection<List<Edge>> getEdges() {
        return this.adjacencyListSucessor.values();
    }

    @Override
    public void addEdge(BpmnElement from, BpmnElement to, int weight) {
        List<Edge> edgeSucessorList = this.adjacencyListSucessor.get(from);
        if (edgeSucessorList == null) {
            throw new IllegalArgumentException("source vertex not in graph");
        }
        Edge newSucessorEdge = new Edge(from, to, weight);
        edgeSucessorList.add(newSucessorEdge);
        List<Edge> edgePredecessorList = this.adjacencyListPredecessor.get(to);
        if (edgePredecessorList == null) {
            throw new IllegalArgumentException("source vertex not in graph");
        }
        Edge newPredecessorEdge = new Edge(to, from, weight);
        edgePredecessorList.add(newPredecessorEdge);
    }

    @Override
    public void removeEdge(BpmnElement from, BpmnElement to) {
        List<Edge> edgeSucessorList = this.adjacencyListSucessor.get(from);
        Edge foundEdge = null;
        for (Edge e : edgeSucessorList) {
            if (!e.from.toString().equals(from.toString()) || !e.to.toString().equals(to.toString())) continue;
            foundEdge = e;
        }
        edgeSucessorList.remove(foundEdge);
        List<Edge> edgePredecessorList = this.adjacencyListPredecessor.get(to);
        foundEdge = null;
        for (Edge e : edgePredecessorList) {
            if (!e.to.toString().equals(from.toString()) || !e.from.toString().equals(to.toString())) continue;
            foundEdge = e;
        }
        edgePredecessorList.remove(foundEdge);
    }

    @Override
    public boolean hasEdge(BpmnElement from, BpmnElement to) {
        return this.getEdge(from, to) != null;
    }

    @Override
    public Edge getEdge(BpmnElement from, BpmnElement to) {
        List<Edge> edgeList = this.adjacencyListSucessor.get(from);
        if (edgeList == null) {
            throw new IllegalArgumentException("source vertex not in graph");
        }
        for (Edge e : edgeList) {
            if (!e.to.equals(to)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void setAnomalyInformation(BpmnElement source) {
        this.setAnomalyInformationRecursive(source, new LinkedList<BpmnElement>());
    }

    private void setAnomalyInformationRecursive(BpmnElement startNode, LinkedList<BpmnElement> currentPath) {
        currentPath.add(startNode);
        boolean isGateway = startNode.getBaseElement().getElementType().getBaseType().getTypeName().equals("gateway");
        boolean isNodeParallelGateway = startNode.getBaseElement().getElementType().getTypeName().equals("parallelGateway");
        boolean isEndEvent = startNode.getBaseElement().getElementType().getTypeName().equals("endEvent") && startNode.getBaseElement().getParentElement().getElementType().getTypeName().equals("process");
        List<Edge> predecessorEdges = this.adjacencyListPredecessor.get(startNode);
        HashMap<String, InOutState> outSuccessors = new HashMap<String, InOutState>();
        if (predecessorEdges != null) {
            for (Edge t : predecessorEdges) {
                if (isGateway) {
                    if (isNodeParallelGateway) {
                        if (outSuccessors.isEmpty()) {
                            outSuccessors.putAll(t.to.getOut());
                            continue;
                        }
                        outSuccessors.putAll(Graph.unionWithStatePrecedence(outSuccessors, t.to.getOut()));
                        continue;
                    }
                    if (outSuccessors.isEmpty()) {
                        outSuccessors.putAll(t.to.getOut());
                        continue;
                    }
                    outSuccessors.putAll(Graph.intersection(outSuccessors, t.to.getOut()));
                    continue;
                }
                outSuccessors.putAll(t.to.getOut());
            }
        }
        startNode.setIn(outSuccessors);
        if (!isEndEvent) {
            startNode.setOut();
        }
        if (startNode.getBaseElement() != null && isEndEvent) {
            currentPath.remove(startNode);
            return;
        }
        List<Edge> edges = this.adjacencyListSucessor.get(startNode);
        for (Edge t : edges) {
            int occurrences = Collections.frequency(currentPath, t.to);
            if (occurrences >= 2) continue;
            this.setAnomalyInformationRecursive(t.to, currentPath);
        }
        currentPath.remove(startNode);
    }

    @Override
    public Map<BpmnElement, List<AnomalyContainer>> getNodesWithAnomalies() {
        HashMap<BpmnElement, List<AnomalyContainer>> anomalies = new HashMap<BpmnElement, List<AnomalyContainer>>();
        for (BpmnElement node : this.adjacencyListSucessor.keySet()) {
            anomalies.putAll(node.getAnomalies());
        }
        return anomalies;
    }

    @Override
    public List<Path> getAllInvalidPaths(BpmnElement source, AnomalyContainer anomaly) {
        List<Path> paths = this.getAllInvalidPathsRecursive(source, anomaly, new LinkedList<BpmnElement>());
        return paths;
    }

    private List<Path> getAllInvalidPathsRecursive(BpmnElement startNode, AnomalyContainer anomaly, LinkedList<BpmnElement> currentPath) {
        ArrayList<Path> invalidPaths = new ArrayList<Path>();
        currentPath.add(startNode);
        List<Edge> edges = this.adjacencyListPredecessor.get(startNode);
        Map<String, InOutState> in = startNode.getIn();
        Map<String, InOutState> out = startNode.getOut();
        List<Path> returnPathsUrAnomaly = this.exitConditionUrAnomaly(startNode, anomaly, currentPath, invalidPaths, in, out);
        List<Path> returnPathsDdDuAnomaly = this.exitConditionDdDuAnomaly(startNode, anomaly, currentPath, invalidPaths, in);
        if (anomaly.getAnomaly() == Anomaly.UR && !in.containsKey(anomaly.getName()) && out.containsKey(anomaly.getName())) {
            return invalidPaths;
        }
        if (returnPathsUrAnomaly != null) {
            return returnPathsUrAnomaly;
        }
        if (returnPathsDdDuAnomaly != null) {
            return returnPathsDdDuAnomaly;
        }
        for (Edge t : edges) {
            if (currentPath.contains(t.to) && t.to != anomaly.getVariable().getElement()) continue;
            invalidPaths.addAll(this.getAllInvalidPathsRecursive(t.to, anomaly, currentPath));
        }
        currentPath.remove(startNode);
        return invalidPaths;
    }

    private List<Path> exitConditionUrAnomaly(BpmnElement startNode, AnomalyContainer anomaly, LinkedList<BpmnElement> currentPath, List<Path> invalidPaths, Map<String, InOutState> in, Map<String, InOutState> out) {
        if (anomaly.getAnomaly() == Anomaly.UR && (this.variableDeleted(anomaly, in, out) || startNode.getBaseElement().getElementType().getTypeName().equals("startEvent") && startNode.getBaseElement().getParentElement().getElementType().getTypeName().equals("process"))) {
            ArrayList<BpmnElement> newPath = new ArrayList<BpmnElement>(currentPath);
            invalidPaths.add(new Path(newPath));
            currentPath.remove(startNode);
            return invalidPaths;
        }
        return null;
    }

    private boolean variableDeleted(AnomalyContainer anomaly, Map<String, InOutState> in, Map<String, InOutState> out) {
        return in.containsKey(anomaly.getName()) && in.get(anomaly.getName()) != InOutState.DELETED && out.containsKey(anomaly.getName()) && out.get(anomaly.getName()) == InOutState.DELETED;
    }

    private List<Path> exitConditionDdDuAnomaly(BpmnElement startNode, AnomalyContainer anomaly, LinkedList<BpmnElement> currentPath, List<Path> invalidPaths, Map<String, InOutState> in) {
        if (startNode.defined().containsKey(anomaly.getName()) && (anomaly.getAnomaly() == Anomaly.DD || anomaly.getAnomaly() == Anomaly.DU) && currentPath.size() > 1) {
            ArrayList<BpmnElement> newPath = new ArrayList<BpmnElement>(currentPath);
            invalidPaths.add(new Path(newPath));
            currentPath.remove(startNode);
            return invalidPaths;
        }
        return null;
    }

    @Override
    public String toString() {
        Set<BpmnElement> keys = this.adjacencyListSucessor.keySet();
        String str = "digraph G {\n";
        for (BpmnElement v : keys) {
            str = str + " ";
            List<Edge> edgeList = this.adjacencyListSucessor.get(v);
            for (Edge edge : edgeList) {
                str = str + edge;
                str = str + "\n";
            }
        }
        str = str + "}";
        return str;
    }

    protected final void clearVertexInfo() {
        for (VertexInfo info : this.vertexInfo.values()) {
            info.clear();
        }
    }

    public static Map<String, InOutState> intersection(Map<String, InOutState> mapA, Map<String, InOutState> mapB) {
        HashMap<String, InOutState> intersectionMap = new HashMap<String, InOutState>();
        HashSet<String> variables = new HashSet<String>();
        variables.addAll(mapA.keySet());
        variables.addAll(mapB.keySet());
        for (String varName : variables) {
            if (mapA.containsKey(varName) && mapB.containsKey(varName)) {
                InOutState state1 = mapA.get(varName);
                InOutState state2 = mapB.get(varName);
                InOutState intersectionElement = Graph.getStatePrecedence(state1, state2);
                intersectionMap.put(varName, intersectionElement);
                continue;
            }
            mapA.remove(varName);
            mapB.remove(varName);
        }
        return intersectionMap;
    }

    public static Map<String, InOutState> unionWithStatePrecedence(Map<String, InOutState> mapA, Map<String, InOutState> mapB) {
        HashMap<String, InOutState> unionMap = new HashMap<String, InOutState>();
        unionMap.putAll(mapA);
        unionMap.putAll(mapB);
        unionMap.putAll(Graph.intersection(mapA, mapB));
        return unionMap;
    }

    private static InOutState getStatePrecedence(InOutState state1, InOutState state2) {
        if (state1 == InOutState.DELETED || state2 == InOutState.DELETED || state1 == InOutState.DELETED && state2 == InOutState.DELETED) {
            return InOutState.DELETED;
        }
        if (state1 == InOutState.READ || state2 == InOutState.READ || state1 == InOutState.READ && state2 == InOutState.READ) {
            return InOutState.READ;
        }
        return InOutState.DEFINED;
    }
}

