/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.model.data;

import de.viadee.bpm.vPAV.processing.model.data.Anomaly;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class CheckerIssue
implements Comparable<CheckerIssue> {
    private String ruleName;
    private String ruleDescription;
    private CriticalityEnum classification;
    private String bpmnFile;
    private String resourceFile;
    private String elementId;
    private String elementName;
    private String variable;
    private Anomaly anomaly;
    private List<Path> invalidPaths;
    private String message;
    private String elementDescription;

    public CheckerIssue(String ruleName, String ruleDescription, CriticalityEnum classification, String bpmnFile, String resourceFile, String elementId, String elementName, String variable, Anomaly anomaly, List<Path> invalidPaths, String message, String elementDescription) {
        this.ruleName = ruleName;
        this.ruleDescription = ruleDescription;
        this.variable = variable;
        this.anomaly = anomaly;
        this.invalidPaths = invalidPaths;
        this.classification = classification;
        this.bpmnFile = bpmnFile;
        this.resourceFile = resourceFile;
        this.elementId = elementId;
        this.elementName = elementName;
        this.message = message;
        this.elementDescription = elementDescription;
    }

    public String getId() {
        return CheckerIssue.getMD5(this.ruleName + "_" + this.bpmnFile + "_" + this.resourceFile + "_" + this.elementId + "_" + this.variable);
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getRuleDescription() {
        return this.ruleDescription;
    }

    public String getVariable() {
        return this.variable;
    }

    public Anomaly getAnomaly() {
        return this.anomaly;
    }

    public List<Path> getInvalidPaths() {
        return this.invalidPaths;
    }

    public CriticalityEnum getClassification() {
        return this.classification;
    }

    public String getBpmnFile() {
        return this.bpmnFile;
    }

    public String getResourceFile() {
        return this.resourceFile;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getElementDescription() {
        return this.elementDescription;
    }

    public void setClassification(CriticalityEnum classification) {
        this.classification = classification;
    }

    public void setBpmnFile(String bpmnFile) {
        this.bpmnFile = bpmnFile;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setElementDescription(String elementDescription) {
        this.elementDescription = elementDescription;
    }

    public void setRuleDescription(String ruleDescription) {
        this.ruleDescription = ruleDescription;
    }

    public static String getMD5(String input) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] messageDigestByteArray = messageDigest.digest(input.getBytes());
            BigInteger number = new BigInteger(1, messageDigestByteArray);
            String hashtext = number.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(CheckerIssue cI) {
        return this.ruleName.compareTo(cI.getRuleName());
    }
}

