/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.model.data;

import de.viadee.bpm.vPAV.processing.model.data.Anomaly;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.InOutState;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class BpmnElement {
    private String processdefinition;
    private BaseElement baseElement;
    private Map<String, InOutState> used = new HashMap<String, InOutState>();
    private Map<String, InOutState> defined = new HashMap<String, InOutState>();
    private Map<String, InOutState> in = new HashMap<String, InOutState>();
    private Map<String, InOutState> out = new HashMap<String, InOutState>();
    private Collection<String> inCa;
    private Collection<String> outCa;
    private Map<String, ProcessVariable> processVariables;

    public BpmnElement(String processdefinition, BaseElement element) {
        this.processdefinition = processdefinition;
        this.baseElement = element;
        this.processVariables = new HashMap<String, ProcessVariable>();
    }

    public String getProcessdefinition() {
        return this.processdefinition;
    }

    public BaseElement getBaseElement() {
        return this.baseElement;
    }

    public Map<String, ProcessVariable> getProcessVariables() {
        return this.processVariables;
    }

    public void setProcessVariables(Map<String, ProcessVariable> variables) {
        this.processVariables = variables;
    }

    public void setProcessVariable(String variableName, ProcessVariable variableObject) {
        this.processVariables.put(variableName, variableObject);
    }

    public int hashCode() {
        return this.baseElement.getId().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof BpmnElement && this.hashCode() == o.hashCode();
    }

    public String toString() {
        return this.baseElement.getId();
    }

    public Map<String, InOutState> getIn() {
        return this.in;
    }

    public Map<String, InOutState> getOut() {
        return this.out;
    }

    public void setIn(Map<String, InOutState> outPredecessor) {
        this.in = outPredecessor;
        if (this.inCa != null) {
            ArrayList<String> removeCandidates = new ArrayList<String>();
            for (String variable : this.in.keySet()) {
                if (this.inCa.contains(variable)) continue;
                removeCandidates.add(variable);
            }
            for (String var : removeCandidates) {
                this.in.remove(var);
            }
        }
    }

    public void setOut() {
        this.out.putAll(this.defined());
        this.changeStatusToRead(this.in);
        this.out.putAll(this.killed());
        if (this.outCa != null) {
            ArrayList<String> removeCandidates = new ArrayList<String>();
            for (String variable : this.out.keySet()) {
                if (!this.outCa.contains(variable)) {
                    removeCandidates.add(variable);
                    continue;
                }
                InOutState state = this.out.get(variable);
                if (state != InOutState.DELETED) continue;
                removeCandidates.add(variable);
            }
            for (String var : removeCandidates) {
                this.out.remove(var);
            }
        }
    }

    private Map<String, InOutState> used() {
        if (this.used.isEmpty()) {
            for (ProcessVariable var : this.processVariables.values()) {
                if (var.getOperation() != VariableOperation.READ) continue;
                this.used.put(var.getName(), InOutState.READ);
            }
        }
        return this.used;
    }

    public Map<String, InOutState> defined() {
        if (this.defined.isEmpty()) {
            for (ProcessVariable var : this.processVariables.values()) {
                if (var.getOperation() != VariableOperation.WRITE) continue;
                this.defined.put(var.getName(), InOutState.DEFINED);
            }
        }
        return this.defined;
    }

    private Map<String, InOutState> killed() {
        HashMap<String, InOutState> killedVariables = new HashMap<String, InOutState>();
        for (ProcessVariable var : this.processVariables.values()) {
            if (var.getOperation() != VariableOperation.DELETE) continue;
            killedVariables.put(var.getName(), InOutState.DELETED);
        }
        return killedVariables;
    }

    public void setInCa(Collection<String> in) {
        this.inCa = in;
    }

    public void setOutCa(Collection<String> out) {
        this.outCa = out;
    }

    public boolean ur(String varName) {
        return (!this.in.containsKey(varName) || this.in.containsKey(varName) && this.in.get(varName) == InOutState.DELETED) && this.used().containsKey(varName);
    }

    public boolean du(String varName) {
        return this.in.containsKey(varName) && this.in.get(varName) == InOutState.DEFINED && this.out.containsKey(varName) && this.out.get(varName) == InOutState.DELETED;
    }

    public boolean dd(String varName) {
        return this.in.containsKey(varName) && this.in.get(varName) == InOutState.DEFINED && this.defined().containsKey(varName);
    }

    public Map<BpmnElement, List<AnomalyContainer>> getAnomalies() {
        HashMap<BpmnElement, List<AnomalyContainer>> anomalyMap = new HashMap<BpmnElement, List<AnomalyContainer>>();
        HashSet<String> variableNames = new HashSet<String>();
        variableNames.addAll(this.used().keySet());
        for (String variableName : this.in.keySet()) {
            if (this.in.get(variableName) != InOutState.DEFINED) continue;
            variableNames.add(variableName);
        }
        ArrayList<AnomalyContainer> anomalies = new ArrayList<AnomalyContainer>();
        for (String variableName : variableNames) {
            if (this.ur(variableName)) {
                anomalies.add(new AnomalyContainer(variableName, Anomaly.UR, this.baseElement.getId(), this.processVariables.get(variableName)));
            }
            if (this.du(variableName)) {
                anomalies.add(new AnomalyContainer(variableName, Anomaly.DU, this.baseElement.getId(), this.processVariables.get(variableName)));
            }
            if (!this.dd(variableName)) continue;
            anomalies.add(new AnomalyContainer(variableName, Anomaly.DD, this.baseElement.getId(), this.processVariables.get(variableName)));
        }
        anomalyMap.put(this, anomalies);
        return anomalyMap;
    }

    private void changeStatusToRead(Map<String, InOutState> inVariables) {
        for (String varName : inVariables.keySet()) {
            if (this.used().containsKey(varName)) {
                this.out.put(varName, InOutState.READ);
                continue;
            }
            this.out.put(varName, inVariables.get(varName));
        }
    }
}

