/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeFactory;
import net.time4j.range.IsoRecurrence;
import net.time4j.range.MomentInterval;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BoundaryEvent;
import org.camunda.bpm.model.bpmn.instance.IntermediateCatchEvent;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.w3c.dom.Element;

public class TimerExpressionChecker
extends AbstractElementChecker {
    final String timeDate = "timeDate";
    final String timeDuration = "timeDuration";
    final String timeCycle = "timeCycle";

    public TimerExpressionChecker(Rule rule, BPMNScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        BaseElement baseElement = element.getBaseElement();
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Map<Object, Object> list = new HashMap();
        if (baseElement.getId() != null && (baseElement instanceof IntermediateCatchEvent || baseElement instanceof StartEvent || baseElement instanceof BoundaryEvent)) {
            list = this.bpmnScanner.getTimerImplementation(baseElement.getId());
            for (Map.Entry<Object, Object> entry : list.entrySet()) {
                String timerDefinition = entry.getValue() != null ? ((Element)entry.getValue()).getParentNode().getTextContent().trim() : "";
                if (timerDefinition != null && !timerDefinition.trim().isEmpty()) {
                    if (entry.getValue() != null && ((Element)entry.getValue()).getNodeName() != null && ((Element)entry.getValue()).getNodeName().contains("timeDate")) {
                        try {
                            DatatypeConverter.parseDateTime((String)timerDefinition);
                        }
                        catch (Exception e) {
                            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, ((Element)entry.getKey()).getAttribute("id"), baseElement.getAttributeValue("name"), null, null, null, "time event '" + CheckName.checkTimer((Element)entry.getKey()) + "' does not follow the ISO 8601 scheme for timeDates.", null));
                        }
                    }
                    if (entry.getValue() != null && ((Element)entry.getValue()).getNodeName() != null && ((Element)entry.getValue()).getNodeName().contains("timeDuration")) {
                        try {
                            DatatypeFactory.newInstance().newDuration(timerDefinition);
                        }
                        catch (Exception e) {
                            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, ((Element)entry.getKey()).getAttribute("id"), baseElement.getAttributeValue("name"), null, null, null, "time event '" + CheckName.checkTimer((Element)entry.getKey()) + "' does not follow the ISO 8601 scheme for timeDuration.", null));
                        }
                    }
                    if (entry.getValue() == null || ((Element)entry.getValue()).getNodeName() == null || !((Element)entry.getValue()).getNodeName().contains("timeCycle")) continue;
                    boolean isCron = false;
                    boolean isDur = false;
                    boolean hasRepeatingIntervals = false;
                    if (!timerDefinition.contains("P") && !timerDefinition.contains("Z") && timerDefinition.contains(" ")) {
                        isCron = true;
                    }
                    if (timerDefinition.startsWith("R")) {
                        hasRepeatingIntervals = true;
                    }
                    if (timerDefinition.startsWith("P") && !timerDefinition.contains("/") && !timerDefinition.contains("--")) {
                        isDur = true;
                    }
                    if (isCron) {
                        try {
                            CronDefinition cronDef = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
                            CronParser cronParser = new CronParser(cronDef);
                            Cron cronJob = cronParser.parse(timerDefinition);
                            cronJob.validate();
                        }
                        catch (IllegalArgumentException e) {
                            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, ((Element)entry.getKey()).getAttribute("id"), baseElement.getAttributeValue("name"), null, null, null, "time event '" + CheckName.checkTimer((Element)entry.getKey()) + "' does not follow the scheme for CRON jobs.", null));
                        }
                    }
                    if (!(isCron || hasRepeatingIntervals || isDur)) {
                        try {
                            MomentInterval.parseISO((String)timerDefinition);
                        }
                        catch (ParseException e) {
                            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, ((Element)entry.getKey()).getAttribute("id"), baseElement.getAttributeValue("name"), null, null, null, "time event '" + CheckName.checkTimer((Element)entry.getKey()) + "' does not follow the ISO 8601 scheme for intervals.", null));
                        }
                    }
                    if (!isCron && hasRepeatingIntervals && !isDur) {
                        try {
                            IsoRecurrence.parseMomentIntervals((String)timerDefinition);
                        }
                        catch (ParseException ex) {
                            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, ((Element)entry.getKey()).getAttribute("id"), baseElement.getAttributeValue("name"), null, null, null, "time event '" + CheckName.checkTimer((Element)entry.getKey()) + "' does not follow the ISO 8601 scheme for repeating intervals.", null));
                        }
                    }
                    if (!isDur || isCron || hasRepeatingIntervals) continue;
                    try {
                        DatatypeFactory.newInstance().newDuration(timerDefinition);
                    }
                    catch (Exception ex) {
                        issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, ((Element)entry.getKey()).getAttribute("id"), baseElement.getAttributeValue("name"), null, null, null, "time event '" + CheckName.checkTimer((Element)entry.getKey()) + "' does not follow the ISO 8601 scheme for durations as interval.", null));
                    }
                    continue;
                }
                if (entry.getValue() == null || ((Element)entry.getValue()).getLocalName() == null || ((Element)entry.getValue()).getLocalName().isEmpty()) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, ((Element)entry.getKey()).getAttribute("id"), baseElement.getAttributeValue("name"), null, null, null, "time event '" + CheckName.checkTimer((Element)entry.getKey()) + "' has no timer definition type specified ", null));
                    continue;
                }
                if (timerDefinition != null && !timerDefinition.trim().isEmpty()) continue;
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, ((Element)entry.getKey()).getAttribute("id"), baseElement.getAttributeValue("name"), null, null, null, "time event '" + CheckName.checkTimer((Element)entry.getKey()) + "' has no timer definition specified ", null));
            }
        }
        return issues;
    }
}

