/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.ProcessingException;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.Task;

public class TaskNamingConventionChecker
extends AbstractElementChecker {
    public TaskNamingConventionChecker(Rule rule, BPMNScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof Task) {
            Collection<ElementConvention> elementConventions = this.rule.getElementConventions();
            if (elementConventions == null || elementConventions.size() < 1 || elementConventions.size() > 1) {
                throw new ProcessingException("task naming convention checker must have one element convention!");
            }
            String patternString = elementConventions.iterator().next().getPattern();
            String taskName = baseElement.getAttributeValue("name");
            if (taskName != null && taskName.trim().length() > 0) {
                Pattern pattern = Pattern.compile(patternString);
                Matcher matcher = pattern.matcher(taskName);
                if (!matcher.matches()) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), null, baseElement.getId(), baseElement.getAttributeValue("name"), null, null, null, "task name '" + taskName + "' is against the naming convention", elementConventions.iterator().next().getDescription()));
                }
            } else {
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), null, baseElement.getId(), baseElement.getAttributeValue("name"), null, null, null, "task name must be specified", null));
            }
        }
        return issues;
    }
}

