/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.ElementFieldTypes;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class ProcessVariablesNameConventionChecker
extends AbstractElementChecker {
    public ProcessVariablesNameConventionChecker(Rule rule, BPMNScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        Collection<CheckerIssue> issues = this.checkNamingConvention(element);
        return issues;
    }

    private Collection<CheckerIssue> checkNamingConvention(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Collection<ElementConvention> elementConventions = this.rule.getElementConventions();
        if (elementConventions != null) {
            for (ElementConvention convention : elementConventions) {
                Pattern pattern = Pattern.compile(convention.getPattern());
                ElementFieldTypes fieldTypes = convention.getElementFieldTypes();
                Collection<String> fieldTypeItems = fieldTypes.getElementFieldTypes();
                for (ProcessVariable variable : element.getProcessVariables().values()) {
                    Matcher patternMatcher;
                    if (variable.getOperation() != VariableOperation.WRITE || fieldTypeItems == null) continue;
                    boolean isInRange = false;
                    isInRange = fieldTypes.isExcluded() ? !fieldTypeItems.contains(variable.getFieldType().name()) : fieldTypeItems.contains(variable.getFieldType().name());
                    if (!isInRange || (patternMatcher = pattern.matcher(variable.getName())).matches()) continue;
                    BaseElement baseElement = element.getBaseElement();
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), variable.getResourceFilePath(), baseElement.getId(), baseElement.getAttributeValue("name"), variable.getName(), null, null, "process variable (" + variable.getName() + ") is against the naming convention " + convention.getName() + " (compare model: " + (Object)((Object)variable.getChapter()) + ", " + variable.getFieldType().getDescription() + ")", convention.getDescription()));
                }
            }
        }
        return issues;
    }
}

