/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.checker.ModelChecker;
import de.viadee.bpm.vPAV.processing.model.data.Anomaly;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class ProcessVariablesModelChecker
implements ModelChecker {
    private final Rule rule;
    private final Map<AnomalyContainer, List<Path>> invalidPathsMap;

    public ProcessVariablesModelChecker(Rule rule, Map<AnomalyContainer, List<Path>> invalidPathsMap) {
        this.rule = rule;
        this.invalidPathsMap = invalidPathsMap;
    }

    @Override
    public Collection<CheckerIssue> check(BpmnModelInstance processdefinition) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (AnomalyContainer anomaly : this.invalidPathsMap.keySet()) {
            List<Path> paths = this.invalidPathsMap.get(anomaly);
            ProcessVariable var = anomaly.getVariable();
            if (paths == null) continue;
            if (anomaly.getAnomaly() == Anomaly.DD) {
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), this.determineCriticality(anomaly.getAnomaly()), var.getElement().getProcessdefinition(), var.getResourceFilePath(), var.getElement().getBaseElement().getId(), var.getElement().getBaseElement().getAttributeValue("name"), var.getName(), anomaly.getAnomaly(), paths, "process variable (" + var.getName() + ") will be overwritten in activity '" + var.getElement().getBaseElement().getAttributeValue("name") + "' without use. (compare model: " + (Object)((Object)var.getChapter()) + ", " + var.getFieldType().getDescription() + ")", null));
                continue;
            }
            if (anomaly.getAnomaly() == Anomaly.DU) {
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), this.determineCriticality(anomaly.getAnomaly()), var.getElement().getProcessdefinition(), var.getResourceFilePath(), var.getElement().getBaseElement().getId(), var.getElement().getBaseElement().getAttributeValue("name"), var.getName(), anomaly.getAnomaly(), paths, "process variable (" + var.getName() + ") will be deleted in activity '" + var.getElement().getBaseElement().getAttributeValue("name") + "' without use. (compare model: " + (Object)((Object)var.getChapter()) + ", " + var.getFieldType().getDescription() + ")", null));
                continue;
            }
            if (anomaly.getAnomaly() != Anomaly.UR) continue;
            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), this.determineCriticality(anomaly.getAnomaly()), var.getElement().getProcessdefinition(), var.getResourceFilePath(), var.getElement().getBaseElement().getId(), var.getElement().getBaseElement().getAttributeValue("name"), var.getName(), anomaly.getAnomaly(), paths, "there is a read access to variable (" + var.getName() + ") in activity '" + var.getElement().getBaseElement().getAttributeValue("name") + "', but no value has been set before. (compare model: " + (Object)((Object)var.getChapter()) + ", " + var.getFieldType().getDescription() + ")", null));
        }
        return issues;
    }

    private CriticalityEnum determineCriticality(Anomaly anomaly) {
        if (anomaly == Anomaly.DD || anomaly == Anomaly.DU) {
            return CriticalityEnum.WARNING;
        }
        return CriticalityEnum.ERROR;
    }
}

