/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.Message;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;

public class MessageEventChecker
extends AbstractElementChecker {
    public MessageEventChecker(Rule rule, BPMNScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement.getElementType().getTypeName().equals("endEvent") || baseElement.getElementType().getTypeName().equals("startEvent") || baseElement.getElementType().getTypeName().equals("intermediateCatchEvent") || baseElement.getElementType().getTypeName().equals("intermediateThrowEvent") || baseElement.getElementType().getTypeName().equals("boundaryEvent")) {
            Event event = (Event)baseElement;
            Collection messageEventDefinitions = event.getChildElementsByType(MessageEventDefinition.class);
            if (messageEventDefinitions != null) {
                for (MessageEventDefinition eventDef : messageEventDefinitions) {
                    if (eventDef == null) continue;
                    Message message = eventDef.getMessage();
                    if (message == null) {
                        issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), null, null, null, "No message has been specified for '" + CheckName.checkName(baseElement) + "'.", null));
                        continue;
                    }
                    if (message.getName() == null || message.getName().isEmpty()) {
                        issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), null, null, null, "No message name has been specified for '" + CheckName.checkName(baseElement) + "'.", null));
                        continue;
                    }
                    if (!message.getName().contains("{") && !message.getName().contains("}")) continue;
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), null, null, null, "Usage of expressions in MessageStartEvent" + CheckName.checkName(baseElement) + "are not allowed", null));
                }
            }
        } else if (baseElement.getElementType().getTypeName().equals("receiveTask")) {
            if (baseElement.getAttributeValue("messageRef") == null || baseElement.getAttributeValue("messageRef").isEmpty()) {
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), null, null, null, "No message has been specified for '" + CheckName.checkName(baseElement) + "'.", null));
            } else if (this.bpmnScanner.getMessageName(baseElement.getAttributeValue("messageRef")) == null || this.bpmnScanner.getMessageName(baseElement.getAttributeValue("messageRef")).isEmpty()) {
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), null, null, null, "No message name has been specified for '" + CheckName.checkName(baseElement) + "'.", null));
            }
        }
        return issues;
    }
}

