/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.Builder;
import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.camunda.bpm.model.bpmn.instance.SendTask;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.UserTask;

public class FieldInjectionChecker
extends AbstractElementChecker {
    private static final Logger LOGGER = Logger.getLogger(FieldInjectionChecker.class.getName());

    public FieldInjectionChecker(Rule rule, BPMNScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        String implementationAttr = null;
        ArrayList<String> executionDelegate = new ArrayList();
        ArrayList<String> executionClass = new ArrayList();
        ArrayList<String> executionExpression = new ArrayList();
        ArrayList<String> taskDelegate = new ArrayList();
        ArrayList<String> taskClass = new ArrayList();
        ArrayList<String> taskExpression = new ArrayList();
        if (bpmnElement instanceof ServiceTask || bpmnElement instanceof BusinessRuleTask || bpmnElement instanceof SendTask) {
            implementationAttr = this.bpmnScanner.getImplementation(bpmnElement.getId());
        }
        if (bpmnElement instanceof UserTask) {
            taskDelegate = this.bpmnScanner.getListener(bpmnElement.getId(), "delegateExpression", "camunda:taskListener");
            taskClass = this.bpmnScanner.getListener(bpmnElement.getId(), "class", "camunda:taskListener");
            taskExpression = this.bpmnScanner.getListener(bpmnElement.getId(), "expression", "camunda:taskListener");
        }
        executionDelegate = this.bpmnScanner.getListener(bpmnElement.getId(), "camunda:executionListener", "camunda:executionListener");
        executionClass = this.bpmnScanner.getListener(bpmnElement.getId(), "class", "camunda:executionListener");
        executionExpression = this.bpmnScanner.getListener(bpmnElement.getId(), "expression", "camunda:executionListener");
        ArrayList<String> fieldInjectionVarNames = this.bpmnScanner.getFieldInjectionVarName(bpmnElement.getId());
        String classAttr = bpmnElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class");
        String delegateExprAttr = bpmnElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "delegateExpression");
        if (implementationAttr != null && !fieldInjectionVarNames.isEmpty() && fieldInjectionVarNames != null && (bpmnElement instanceof ServiceTask || bpmnElement instanceof BusinessRuleTask || bpmnElement instanceof SendTask)) {
            if (implementationAttr.equals("camunda:class")) {
                if (classAttr != null && classAttr.trim().length() != 0) {
                    for (String fieldInjectionVarName : fieldInjectionVarNames) {
                        issues.addAll(this.checkClassFileForVar(element, classAttr, fieldInjectionVarName));
                    }
                }
            } else if (implementationAttr.equals("camunda:delegateExpression") && delegateExprAttr != null && delegateExprAttr.trim().length() != 0) {
                if (RuntimeConfig.getInstance().getBeanMapping() != null) {
                    Builder treeBuilder = new Builder();
                    Tree tree = treeBuilder.build(delegateExprAttr);
                    Iterable identifierNodes = tree.getIdentifierNodes();
                    if (identifierNodes.iterator().hasNext()) {
                        for (IdentifierNode node : identifierNodes) {
                            String classFile = RuntimeConfig.getInstance().getBeanMapping().get(node.getName());
                            if (classFile == null || classFile.trim().length() <= 0) continue;
                            for (String fieldInjectionVarName : fieldInjectionVarNames) {
                                issues.addAll(this.checkClassFileForVar(element, classFile, fieldInjectionVarName));
                            }
                        }
                    } else {
                        for (String fieldInjectionVarName : fieldInjectionVarNames) {
                            issues.addAll(this.checkClassFileForVar(element, delegateExprAttr, fieldInjectionVarName));
                        }
                    }
                } else {
                    for (String fieldInjectionVarName : fieldInjectionVarNames) {
                        issues.addAll(this.checkClassFileForVar(element, delegateExprAttr, fieldInjectionVarName));
                    }
                }
            }
        }
        if (executionClass != null || executionDelegate != null || executionExpression != null && !fieldInjectionVarNames.isEmpty() && fieldInjectionVarNames != null) {
            for (String fieldInjectionVarName : fieldInjectionVarNames) {
                issues.addAll(this.checkListener(element, executionClass, executionDelegate, executionExpression, fieldInjectionVarName));
            }
        }
        if (taskClass != null || taskDelegate != null || taskExpression != null && !fieldInjectionVarNames.isEmpty() && fieldInjectionVarNames != null) {
            for (String fieldInjectionVarName : fieldInjectionVarNames) {
                issues.addAll(this.checkListener(element, taskClass, taskDelegate, taskExpression, fieldInjectionVarName));
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkListener(BpmnElement element, ArrayList<String> aClass, ArrayList<String> aDelegate, ArrayList<String> aExpression, String varName) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        if (aClass == null || aClass.size() > 0) {
            for (String eClass : aClass) {
                if (eClass != null && eClass.trim().length() == 0 || eClass == null) continue;
                issues.addAll(this.checkClassFileForVar(element, eClass, varName));
            }
        }
        if (aDelegate != null && !aDelegate.isEmpty()) {
            for (String eDel : aDelegate) {
                if (eDel == null || eDel.trim().length() == 0 || eDel == null) continue;
                if (RuntimeConfig.getInstance().getBeanMapping() != null) {
                    Builder treeBuilder = new Builder();
                    Tree tree = treeBuilder.build(eDel);
                    Iterable identifierNodes = tree.getIdentifierNodes();
                    if (identifierNodes.iterator().hasNext()) {
                        for (IdentifierNode node : identifierNodes) {
                            String classFile = RuntimeConfig.getInstance().getBeanMapping().get(node.getName());
                            if (classFile == null || classFile.trim().length() <= 0) continue;
                            issues.addAll(this.checkClassFileForVar(element, classFile, varName));
                        }
                        continue;
                    }
                    issues.addAll(this.checkClassFileForVar(element, eDel, varName));
                    continue;
                }
                issues.addAll(this.checkClassFileForVar(element, eDel, varName));
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkClassFileForVar(BpmnElement element, String className, String varName) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        String classPath = className.replaceAll("\\.", "/") + ".java";
        try {
            Class<?> clazz = RuntimeConfig.getInstance().getClassLoader().loadClass(className);
            try {
                Field field = clazz.getDeclaredField(varName);
                if (!field.getType().getName().equals("org.camunda.bpm.engine.impl.el.FixedValue") && !field.getType().getName().equals("org.camunda.bpm.engine.delegate.Expression")) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), classPath, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "the type of the variable '" + varName + "' is incorrect", null));
                }
                if (!Modifier.isPublic(field.getModifiers())) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), classPath, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "the variable '" + varName + "' should be public", null));
                }
                Method[] methods = clazz.getMethods();
                boolean hasMethod = false;
                for (Method method : methods) {
                    if (!method.getName().toLowerCase().contains("set" + varName.toLowerCase())) continue;
                    hasMethod = true;
                }
                if (!hasMethod) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), classPath, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "no setter found for variable '" + varName + "'", null));
                }
            }
            catch (NoSuchFieldException | SecurityException e) {
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), classPath, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "class '" + clazz.getSimpleName() + "' does not declared the variable '" + varName + "'", null));
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning("Class " + className + " does not exist");
        }
        return issues;
    }
}

