/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.AbstractRunner;
import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class ExtensionChecker
extends AbstractElementChecker {
    public ExtensionChecker(Rule rule, BPMNScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        Map<String, Setting> settings = this.rule.getSettings();
        ArrayList<String> whiteList = this.rule.getWhiteList();
        HashMap<String, String> keyPairs = new HashMap<String, String>();
        ArrayList<Setting> optionalSettings = new ArrayList<Setting>();
        ArrayList<Setting> mandatorySettings = new ArrayList<Setting>();
        keyPairs.putAll(this.bpmnScanner.getKeyPairs(bpmnElement.getId()));
        for (Map.Entry<String, Setting> settingsEntry : settings.entrySet()) {
            if (settingsEntry.getValue().getRequired()) {
                mandatorySettings.add(settingsEntry.getValue());
                continue;
            }
            optionalSettings.add(settingsEntry.getValue());
        }
        if (whiteList.contains(bpmnElement.getElementType().getInstanceType().getSimpleName())) {
            issues.addAll(this.checkManExtension(whiteList, mandatorySettings, keyPairs, bpmnElement, element));
            issues.addAll(this.checkOptExtension(whiteList, optionalSettings, keyPairs, bpmnElement, element));
        }
        return issues;
    }

    private Collection<CheckerIssue> checkManExtension(ArrayList<String> whiteList, ArrayList<Setting> settings, Map<String, String> keyPairs, BaseElement bpmnElement, BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (Setting setting : settings) {
            if (this.checkMisconfiguration(setting)) continue;
            if (setting.getType() != null) {
                if (!setting.getType().equals(bpmnElement.getElementType().getInstanceType().getSimpleName())) continue;
                if (setting.getName() != null && keyPairs.containsKey(setting.getName())) {
                    this.checkValue(keyPairs, bpmnElement, element, issues, setting);
                    continue;
                }
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "Key of '" + CheckName.checkName(bpmnElement) + "' could not be resolved. The ruleset specifies the use of key '" + setting.getName() + "'.", null));
                continue;
            }
            if (setting.getId() == null || !setting.getId().equals(bpmnElement.getAttributeValue("id"))) continue;
            this.checkValue(keyPairs, bpmnElement, element, issues, setting);
        }
        return issues;
    }

    private Collection<CheckerIssue> checkOptExtension(ArrayList<String> whiteList, ArrayList<Setting> settings, Map<String, String> keyPairs, BaseElement bpmnElement, BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (Setting setting : settings) {
            this.checkMisconfiguration(setting);
            if (setting.getType() == null || !setting.getType().equals(bpmnElement.getElementType().getInstanceType().getSimpleName()) || setting.getName() == null || !keyPairs.containsKey(setting.getName())) continue;
            if (setting.getId() == null) {
                this.checkValue(keyPairs, bpmnElement, element, issues, setting);
                continue;
            }
            if (setting.getId() == null || !setting.getId().equals(bpmnElement.getAttributeValue("id"))) continue;
            this.checkValue(keyPairs, bpmnElement, element, issues, setting);
        }
        return issues;
    }

    private boolean checkMisconfiguration(Setting setting) {
        boolean misconfigured = false;
        if (setting.getType() != null && setting.getId() != null) {
            misconfigured = true;
            AbstractRunner.setMisconfigured(misconfigured);
            return misconfigured;
        }
        return misconfigured;
    }

    private void checkValue(Map<String, String> keyPairs, BaseElement bpmnElement, BpmnElement element, Collection<CheckerIssue> issues, Setting setting) {
        if (keyPairs.get(setting.getName()) != null && !keyPairs.get(setting.getName()).isEmpty()) {
            String patternString = setting.getValue();
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(keyPairs.get(setting.getName()));
            if (!matcher.matches()) {
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "Key-Value pair of '" + CheckName.checkName(bpmnElement) + "' does not fit the configured setting of the rule set. Check the extension with key '" + setting.getName() + "'.", null));
            }
        } else {
            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "Value of '" + CheckName.checkName(bpmnElement) + "' is empty. Check whether ruleset and model are congruent.", null));
        }
    }
}

