/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.Script;
import org.camunda.bpm.model.bpmn.instance.ScriptTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaScript;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaTaskListener;
import org.codehaus.groovy.control.CompilationFailedException;

public class EmbeddedGroovyScriptChecker
extends AbstractElementChecker {
    public EmbeddedGroovyScriptChecker(Rule rule, BPMNScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        issues.addAll(this.checkScriptTask(element.getProcessdefinition(), baseElement));
        ExtensionElements extensionElements = baseElement.getExtensionElements();
        if (extensionElements != null) {
            issues.addAll(this.checkExecutionListener(element.getProcessdefinition(), baseElement, extensionElements));
            issues.addAll(this.checkTaskListener(element.getProcessdefinition(), baseElement, extensionElements));
        }
        return issues;
    }

    private Collection<CheckerIssue> checkScriptTask(String bpmnFile, BaseElement baseElement) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        if (baseElement instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)baseElement;
            Script script = scriptTask.getScript();
            if (script != null && scriptTask.getCamundaResource() == null) {
                CheckerIssue issueInvalidScript;
                CheckerIssue issueEmptyFormat;
                CheckerIssue issueEmptyScript = this.checkEmptyScriptContent(bpmnFile, baseElement, scriptTask.getScriptFormat(), script.getTextContent());
                if (issueEmptyScript != null) {
                    issues.add(issueEmptyScript);
                }
                if ((issueEmptyFormat = this.checkEmptyScriptFormat(bpmnFile, baseElement, scriptTask.getScriptFormat(), script.getTextContent())) != null) {
                    issues.add(issueEmptyFormat);
                }
                if ((issueInvalidScript = this.checkInvalidScriptContent(bpmnFile, baseElement, scriptTask.getScriptFormat(), script.getTextContent())) != null) {
                    issues.add(issueInvalidScript);
                }
            } else if (scriptTask.getCamundaResource() == null) {
                issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, bpmnFile, null, baseElement.getId(), baseElement.getAttributeValue("name"), null, null, null, "there is an empty script reference", null));
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkExecutionListener(String bpmnFile, BaseElement baseElement, ExtensionElements extensionElements) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaExecutionListener.class).list();
        for (CamundaExecutionListener listener : listenerList) {
            CheckerIssue issueInvalidScript;
            CheckerIssue issueEmptyFormat;
            CamundaScript script = listener.getCamundaScript();
            if (script == null || script.getCamundaResource() != null) continue;
            CheckerIssue issueEmptyScript = this.checkEmptyScriptContent(bpmnFile, baseElement, script.getCamundaScriptFormat(), script.getTextContent());
            if (issueEmptyScript != null) {
                issues.add(issueEmptyScript);
            }
            if ((issueEmptyFormat = this.checkEmptyScriptFormat(bpmnFile, baseElement, script.getCamundaScriptFormat(), script.getTextContent())) != null) {
                issues.add(issueEmptyFormat);
            }
            if ((issueInvalidScript = this.checkInvalidScriptContent(bpmnFile, baseElement, script.getCamundaScriptFormat(), script.getTextContent())) == null) continue;
            issues.add(issueInvalidScript);
        }
        return issues;
    }

    private Collection<CheckerIssue> checkTaskListener(String bpmnFile, BaseElement baseElement, ExtensionElements extensionElements) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaTaskListener.class).list();
        for (CamundaTaskListener listener : listenerList) {
            CheckerIssue issueInvalidScript;
            CheckerIssue issueEmptyFormat;
            CamundaScript script = listener.getCamundaScript();
            if (script == null || script.getCamundaResource() != null) continue;
            CheckerIssue issueEmptyScript = this.checkEmptyScriptContent(bpmnFile, baseElement, script.getCamundaScriptFormat(), script.getTextContent());
            if (issueEmptyScript != null) {
                issues.add(issueEmptyScript);
            }
            if ((issueEmptyFormat = this.checkEmptyScriptFormat(bpmnFile, baseElement, script.getCamundaScriptFormat(), script.getTextContent())) != null) {
                issues.add(issueEmptyFormat);
            }
            if ((issueInvalidScript = this.checkInvalidScriptContent(bpmnFile, baseElement, script.getCamundaScriptFormat(), script.getTextContent())) == null) continue;
            issues.add(issueInvalidScript);
        }
        return issues;
    }

    private CheckerIssue parseGroovyCode(String bpmnFile, BaseElement baseElement, String scriptText) {
        GroovyShell shell = new GroovyShell();
        try {
            shell.evaluate(scriptText);
        }
        catch (MissingPropertyException | CompilationFailedException ex) {
            if (ex instanceof CompilationFailedException) {
                return new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, bpmnFile, null, baseElement.getId(), baseElement.getAttributeValue("name"), null, null, null, ex.getMessage(), null);
            }
            return new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, bpmnFile, null, baseElement.getId(), baseElement.getAttributeValue("name"), null, null, null, "GroovyScript could not be evaluated. '" + ex.getMessage() + "'", null);
        }
        return null;
    }

    private CheckerIssue checkEmptyScriptContent(String bpmnFile, BaseElement baseElement, String scriptFormat, String script) {
        if (scriptFormat != null && (script == null || script.isEmpty())) {
            return new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, bpmnFile, null, baseElement.getId(), baseElement.getAttributeValue("name"), null, null, null, "there is no script content for given script format", null);
        }
        return null;
    }

    private CheckerIssue checkEmptyScriptFormat(String bpmnFile, BaseElement baseElement, String scriptFormat, String script) {
        if (scriptFormat == null && script != null) {
            return new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, bpmnFile, null, baseElement.getId(), baseElement.getAttributeValue("name"), null, null, null, "there is no script format for given script", null);
        }
        return null;
    }

    private CheckerIssue checkInvalidScriptContent(String bpmnFile, BaseElement baseElement, String scriptFormat, String script) {
        if (scriptFormat != null && scriptFormat.toLowerCase().equals("groovy") && script != null) {
            return this.parseGroovyCode(bpmnFile, baseElement, script);
        }
        return null;
    }
}

