/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;

public class DmnTaskChecker
extends AbstractElementChecker {
    public DmnTaskChecker(Rule rule, BPMNScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        if (bpmnElement instanceof BusinessRuleTask) {
            String implementationAttr = this.bpmnScanner.getImplementation(bpmnElement.getId());
            String dmnAttr = bpmnElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "decisionRef");
            if (implementationAttr != null && implementationAttr.equals("camunda:decisionRef")) {
                if (dmnAttr == null || dmnAttr.trim().length() == 0) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "task " + CheckName.checkName(bpmnElement) + " with no dmn reference", null));
                } else {
                    issues.addAll(this.checkDMNFile(element, dmnAttr));
                }
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkDMNFile(BpmnElement element, String dmnName) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        String dmnPath = dmnName.replaceAll("\\.", "/") + ".dmn";
        URL urlDMN = RuntimeConfig.getInstance().getClassLoader().getResource(dmnPath);
        if (urlDMN == null) {
            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), dmnPath, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "dmn file for task " + CheckName.checkName(bpmnElement) + " not found", null));
        }
        return issues;
    }
}

