/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.ConfigItemNotFoundException;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.checker.ElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public final class CheckerFactory {
    private static final Logger LOGGER = Logger.getLogger(CheckerFactory.class.getName());

    public static Collection<ElementChecker> createCheckerInstancesBpmnElement(Map<String, Rule> ruleConf, Collection<String> resourcesNewestVersions, BpmnElement element, BPMNScanner bpmnScanner) throws ConfigItemNotFoundException {
        ArrayList<ElementChecker> checkers = new ArrayList<ElementChecker>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement == null) {
            throw new RuntimeException("Bpmn Element couldn't be found");
        }
        for (Map.Entry<String, Rule> rule : ruleConf.entrySet()) {
            String fullyQualifiedName = CheckerFactory.getFullyQualifiedName(rule);
            if (fullyQualifiedName.isEmpty() || rule.getKey().equals("ProcessVariablesModelChecker")) continue;
            try {
                AbstractElementChecker aChecker;
                Constructor<?> c;
                if (!rule.getKey().equals("VersioningChecker")) {
                    c = Class.forName(fullyQualifiedName).getConstructor(Rule.class, BPMNScanner.class);
                    aChecker = (AbstractElementChecker)c.newInstance(rule.getValue(), bpmnScanner);
                    checkers.add(aChecker);
                    continue;
                }
                c = Class.forName(fullyQualifiedName).getConstructor(Rule.class, BPMNScanner.class, Collection.class);
                aChecker = (AbstractElementChecker)c.newInstance(rule.getValue(), bpmnScanner, resourcesNewestVersions);
                checkers.add(aChecker);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.warning("Class " + fullyQualifiedName + " not found or couldn't be instantiated");
                rule.getValue().deactivate();
            }
        }
        return checkers;
    }

    private static String getFullyQualifiedName(Map.Entry<String, Rule> rule) {
        String fullyQualifiedName = "";
        if (Arrays.asList(RuntimeConfig.getInstance().getViadeeRules()).contains(rule.getKey()) && rule.getValue().isActive()) {
            fullyQualifiedName = "de.viadee.bpm.vPAV.processing.checker." + rule.getValue().getName().trim();
        } else if (rule.getValue().isActive() && rule.getValue().getSettings() != null && rule.getValue().getSettings().containsKey("external_Location")) {
            fullyQualifiedName = rule.getValue().getSettings().get("external_Location").getValue() + "." + rule.getValue().getName().trim();
        }
        if (fullyQualifiedName.isEmpty() && rule.getValue().isActive()) {
            LOGGER.warning("Checker '" + rule.getValue().getName() + "' not found. Please add setting for external_location in ruleSet.xml.");
            rule.getValue().deactivate();
        }
        return fullyQualifiedName;
    }
}

