/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.Builder;
import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Resource;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class BoundaryErrorChecker
extends AbstractElementChecker {
    private static Logger logger = Logger.getLogger(BoundaryErrorChecker.class.getName());

    public BoundaryErrorChecker(Rule rule, BPMNScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        Map<String, String> errorEventDef;
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        String mappedTaskId = null;
        String implementation = null;
        String implementationRef = null;
        if (bpmnElement.getElementType().getTypeName().equals("boundaryEvent") && (errorEventDef = this.bpmnScanner.getErrorEvent(bpmnElement.getId())).size() != 0) {
            mappedTaskId = this.bpmnScanner.getErrorEventMapping(bpmnElement.getId());
            implementation = this.bpmnScanner.getImplementation(mappedTaskId);
            implementationRef = this.bpmnScanner.getImplementationReference(mappedTaskId, implementation);
            if (errorEventDef.entrySet().iterator().next().getKey() == null || errorEventDef.entrySet().iterator().next().getKey().isEmpty()) {
                String errorCode = this.bpmnScanner.getErrorCodeVar(bpmnElement.getId());
                if (errorCode == null || errorCode.isEmpty()) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "BoundaryErrorEvent '" + CheckName.checkName(bpmnElement) + "' with no errorCodeVariable specified", null));
                } else {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "BoundaryErrorEvent '" + CheckName.checkName(bpmnElement) + "' with no error referenced", null));
                }
            } else {
                Map<String, String> errorDef = this.bpmnScanner.getErrorDef(errorEventDef.entrySet().iterator().next().getKey());
                if (errorDef.entrySet().iterator().next().getValue() == null || errorDef.entrySet().iterator().next().getValue().isEmpty()) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "BoundaryErrorEvent '" + CheckName.checkName(bpmnElement) + "' does not provide an ErrorCode", null));
                } else if (implementation != null) {
                    if (implementation.equals("camunda:delegateExpression")) {
                        this.checkBeanMapping(element, issues, bpmnElement, errorDef.entrySet().iterator().next().getValue(), implementationRef);
                    } else if (implementation.equals("camunda:class") && !this.readResourceFile(implementationRef, errorDef.entrySet().iterator().next().getValue())) {
                        issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "ErrorCode of '" + CheckName.checkName(bpmnElement) + "' does not match with throwing declaration of class '" + implementationRef + "'", null));
                    }
                }
                if (errorDef.entrySet().iterator().next().getKey() == null || errorDef.entrySet().iterator().next().getKey().isEmpty()) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "BoundaryErrorEvent '" + CheckName.checkName(bpmnElement) + "' does not provide an ErrorName", null));
                }
                if (errorEventDef.entrySet().iterator().next().getValue() == null || errorEventDef.entrySet().iterator().next().getValue().isEmpty()) {
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.WARNING, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "BoundaryErrorEvent '" + CheckName.checkName(bpmnElement) + "' with no ErrorMessageVariable", null));
                }
            }
        }
        return issues;
    }

    private void checkBeanMapping(BpmnElement element, Collection<CheckerIssue> issues, BaseElement bpmnElement, String errorDefEntry, String implementationRef) {
        if (RuntimeConfig.getInstance().getBeanMapping() != null) {
            Builder treeBuilder = new Builder();
            Tree tree = treeBuilder.build(implementationRef);
            Iterable identifierNodes = tree.getIdentifierNodes();
            if (identifierNodes.iterator().hasNext()) {
                for (IdentifierNode node : identifierNodes) {
                    String classFile = RuntimeConfig.getInstance().getBeanMapping().get(node.getName());
                    if (classFile != null && classFile.trim().length() > 0) {
                        if (this.checkClassFile(classFile)) {
                            if (this.readResourceFile(classFile, errorDefEntry)) continue;
                            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "ErrorCode of '" + CheckName.checkName(bpmnElement) + "' does not match with throwing declaration of bean '" + node.getName() + "'", null));
                            continue;
                        }
                        issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "Corresponding class of associated task could not be loaded or found.", null));
                        continue;
                    }
                    issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "Due to incorrect beanmapping for delegate expression: '" + implementationRef + "' the BoundaryErrorEvent can not be linked to class.", null));
                }
            }
        } else if (!this.checkClassFile(implementationRef)) {
            issues.add(new CheckerIssue(this.rule.getName(), this.rule.getRuleDescription(), CriticalityEnum.ERROR, element.getProcessdefinition(), null, bpmnElement.getAttributeValue("id"), bpmnElement.getAttributeValue("name"), null, null, null, "Class for '" + implementationRef + "' could not be found and therefore not linked to BoundaryErrorEvent '" + CheckName.checkName(bpmnElement) + "'.", null));
        }
    }

    private boolean readResourceFile(String className, String errorCode) {
        String fileName = className.replaceAll("\\.", "/") + ".java";
        boolean matchingErrorCode = false;
        if (fileName != null && fileName.trim().length() > 0) {
            try {
                DirectoryScanner scanner = new DirectoryScanner();
                if (RuntimeConfig.getInstance().isTest()) {
                    if (fileName.endsWith(".java")) {
                        scanner.setBasedir("src/test/java/");
                    } else {
                        scanner.setBasedir("src/test/resources/");
                    }
                } else if (fileName.endsWith(".java")) {
                    scanner.setBasedir("src/main/java/");
                } else {
                    scanner.setBasedir("src/main/resources/");
                }
                Resource s = scanner.getResource(fileName);
                if (s.isExists()) {
                    InputStreamReader resource = new InputStreamReader(new FileInputStream(s.toString()));
                    String methodBody = IOUtils.toString((Reader)resource);
                    return this.validateContent(methodBody, errorCode);
                }
                logger.warning("Class " + fileName + " could not be read or does not exist");
            }
            catch (IOException ex) {
                logger.warning("Resource '" + fileName + "' could not be read: " + ex.getMessage());
            }
        }
        return matchingErrorCode;
    }

    private boolean validateContent(String methodBody, String errorCode) {
        if (methodBody != null && !methodBody.isEmpty() && methodBody.contains("throw new BpmnError")) {
            String temp = methodBody.substring(methodBody.indexOf("throw new BpmnError"));
            String delErrorCode = (temp = temp.substring(0, temp.indexOf(";") + 1)).substring(temp.indexOf("\"") + 1, temp.lastIndexOf("\""));
            if (delErrorCode.equals(errorCode)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkClassFile(String className) {
        String classPath = className.replaceAll("\\.", "/") + ".java";
        try {
            RuntimeConfig.getInstance().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

