/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import de.viadee.bpm.vPAV.BPMNScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.JsOutputWriter;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import de.viadee.bpm.vPAV.processing.ConfigItemNotFoundException;
import de.viadee.bpm.vPAV.processing.ElementGraphBuilder;
import de.viadee.bpm.vPAV.processing.checker.CheckerFactory;
import de.viadee.bpm.vPAV.processing.checker.ElementChecker;
import de.viadee.bpm.vPAV.processing.checker.ProcessVariablesModelChecker;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.graph.IGraph;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.xml.sax.SAXException;

public class BpmnModelDispatcher {
    private BpmnModelDispatcher() {
    }

    public static Collection<CheckerIssue> dispatch(File processdefinition, Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, Map<String, Collection<String>> messageIdToVariables, Map<String, Collection<String>> processIdToVariables, Collection<String> resourcesNewestVersions, Map<String, Rule> conf) throws ConfigItemNotFoundException {
        BPMNScanner bpmnScanner;
        try {
            bpmnScanner = new BPMNScanner(processdefinition.getPath());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Model couldn't be parsed");
        }
        BpmnModelInstance modelInstance = Bpmn.readModelFromFile((File)processdefinition);
        Collection baseElements = modelInstance.getModelElementsByType(BaseElement.class);
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(decisionRefToPathMap, processIdToPathMap, messageIdToVariables, processIdToVariables, bpmnScanner);
        Collection<IGraph> graphCollection = graphBuilder.createProcessGraph(modelInstance, processdefinition.getPath(), new ArrayList<String>());
        Map<AnomalyContainer, List<Path>> invalidPathMap = graphBuilder.createInvalidPaths(graphCollection);
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Rule processVariablesModelRule = conf.get(BpmnModelDispatcher.getClassName(ProcessVariablesModelChecker.class));
        if (processVariablesModelRule == null) {
            throw new ConfigItemNotFoundException(BpmnModelDispatcher.getClassName(ProcessVariablesModelChecker.class) + " not found");
        }
        if (processVariablesModelRule.isActive()) {
            ProcessVariablesModelChecker processVarChecker = new ProcessVariablesModelChecker(processVariablesModelRule, invalidPathMap);
            issues.addAll(processVarChecker.check(modelInstance));
        }
        for (BaseElement baseElement : baseElements) {
            BpmnElement element = graphBuilder.getElement(baseElement.getId());
            if (element == null) {
                element = new BpmnElement(processdefinition.getPath(), baseElement);
            }
            Collection<ElementChecker> checkerCollection = CheckerFactory.createCheckerInstancesBpmnElement(conf, resourcesNewestVersions, element, bpmnScanner);
            for (ElementChecker checker : checkerCollection) {
                issues.addAll(checker.check(element));
            }
        }
        JsOutputWriter jWriter = new JsOutputWriter();
        try {
            jWriter.writeVars(baseElements, graphBuilder, processdefinition);
        }
        catch (OutputWriterException e) {
            e.printStackTrace();
        }
        return issues;
    }

    private static String getClassName(Class<?> clazz) {
        return clazz.getSimpleName();
    }
}

