/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.config.reader;

import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.ElementFieldTypes;
import de.viadee.bpm.vPAV.config.model.ModelConvention;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.config.reader.ConfigReader;
import de.viadee.bpm.vPAV.config.reader.ConfigReaderException;
import de.viadee.bpm.vPAV.config.reader.XmlElementConvention;
import de.viadee.bpm.vPAV.config.reader.XmlElementFieldTypes;
import de.viadee.bpm.vPAV.config.reader.XmlModelConvention;
import de.viadee.bpm.vPAV.config.reader.XmlRule;
import de.viadee.bpm.vPAV.config.reader.XmlRuleSet;
import de.viadee.bpm.vPAV.config.reader.XmlSetting;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public final class XmlConfigReader
implements ConfigReader {
    @Override
    public Map<String, Rule> read(String file) throws ConfigReaderException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlRuleSet.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            InputStream fRuleSet = RuntimeConfig.getInstance().getClassLoader().getResourceAsStream(file);
            if (fRuleSet != null) {
                XmlRuleSet ruleSet = (XmlRuleSet)jaxbUnmarshaller.unmarshal(fRuleSet);
                return XmlConfigReader.transformFromXmlDatastructues(ruleSet);
            }
            throw new ConfigReaderException("ConfigFile could not be found");
        }
        catch (JAXBException e) {
            throw new ConfigReaderException(e);
        }
    }

    public Map<String, Rule> getDeactivatedRuleSet() {
        HashMap<String, Rule> rules = new HashMap<String, Rule>();
        for (String name : RuntimeConfig.getInstance().getViadeeRules()) {
            rules.put(name, new Rule(name, false, null, new HashMap<String, Setting>(), new ArrayList<ElementConvention>(), new ArrayList<ModelConvention>()));
        }
        return rules;
    }

    private static Map<String, Rule> transformFromXmlDatastructues(XmlRuleSet ruleSet) throws ConfigReaderException {
        HashMap<String, Rule> rules = new HashMap<String, Rule>();
        Collection<XmlRule> xmlRules = ruleSet.getRules();
        for (XmlRule rule : xmlRules) {
            String name = rule.getName();
            if (name == null) {
                throw new ConfigReaderException("rule name is not set");
            }
            boolean state = rule.isState();
            String ruleDescription = rule.getDescription();
            Collection<XmlElementConvention> xmlElementConventions = rule.getElementConventions();
            ArrayList<ElementConvention> elementConventions = new ArrayList<ElementConvention>();
            if (xmlElementConventions != null) {
                for (XmlElementConvention xmlElementConvention : xmlElementConventions) {
                    XmlElementFieldTypes xmlElementFieldTypes = xmlElementConvention.getElementFieldTypes();
                    ElementFieldTypes elementFieldTypes = null;
                    if (xmlElementFieldTypes != null) {
                        elementFieldTypes = new ElementFieldTypes(xmlElementFieldTypes.getElementFieldTypes(), xmlElementFieldTypes.isExcluded());
                    }
                    if (!XmlConfigReader.checkRegEx(xmlElementConvention.getPattern())) {
                        throw new ConfigReaderException("RegEx (" + xmlElementConvention.getPattern() + ") of " + name + " (" + xmlElementConvention.getName() + ") is incorrect");
                    }
                    elementConventions.add(new ElementConvention(xmlElementConvention.getName(), elementFieldTypes, xmlElementConvention.getDescription(), xmlElementConvention.getPattern()));
                }
            }
            Collection<XmlModelConvention> xmlModelConventions = rule.getModelConventions();
            ArrayList<ModelConvention> modelConventions = new ArrayList<ModelConvention>();
            if (xmlModelConventions != null) {
                for (XmlModelConvention xmlModelConvention : xmlModelConventions) {
                    modelConventions.add(new ModelConvention(xmlModelConvention.getType()));
                }
            }
            Collection<XmlSetting> xmlSettings = rule.getSettings();
            HashMap<String, Setting> settings = new HashMap<String, Setting>();
            if (xmlSettings != null) {
                for (XmlSetting xmlSetting : xmlSettings) {
                    if (!settings.containsKey(xmlSetting.getName())) {
                        settings.put(xmlSetting.getName(), new Setting(xmlSetting.getName(), xmlSetting.getScript(), xmlSetting.getType(), xmlSetting.getId(), xmlSetting.getRequired(), xmlSetting.getValue()));
                        continue;
                    }
                    ((Setting)settings.get(xmlSetting.getName())).addScriptPlace(xmlSetting.getScript());
                }
            }
            rules.put(name, new Rule(name, state, ruleDescription, settings, elementConventions, modelConventions));
        }
        return rules;
    }

    private static boolean checkRegEx(String regEx) {
        boolean correct = false;
        if (regEx.isEmpty()) {
            return correct;
        }
        try {
            Pattern.compile(regEx);
            correct = true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return correct;
    }
}

