/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.processing.ConfigItemNotFoundException;
import de.viadee.bpm.vPAV.processing.checker.VersioningChecker;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelException;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelException;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;

public class FileScanner {
    private final Set<String> processdefinitions;
    private Set<String> javaResourcesFileInputStream = new HashSet<String>();
    private Set<String> includedFiles = new HashSet<String>();
    private Map<String, String> decisionRefToPathMap;
    private Collection<String> resourcesNewestVersions = new ArrayList<String>();
    private Map<String, String> processIdToPathMap;
    private static String scheme = null;
    private static boolean isDirectory = false;
    private static final Logger LOGGER = Logger.getLogger(FileScanner.class.getName());

    public FileScanner(Map<String, Rule> rules) {
        URL[] urls;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir("src/main/resources/");
        scanner.setIncludes(new String[]{"**/*.bpmn"});
        scanner.scan();
        this.processdefinitions = new HashSet<String>(Arrays.asList(scanner.getIncludedFiles()));
        scanner.setBasedir("src/main/java/");
        scanner.setIncludes(new String[]{"**/*.java"});
        scanner.scan();
        this.javaResourcesFileInputStream = new HashSet<String>(Arrays.asList(scanner.getIncludedFiles()));
        this.processIdToPathMap = FileScanner.createProcessIdToPathMap(this.processdefinitions);
        String versioningScheme = null;
        try {
            versioningScheme = FileScanner.loadVersioningScheme(rules);
        }
        catch (ConfigItemNotFoundException e) {
            LOGGER.log(Level.WARNING, "Versioning Scheme could not be loaded.", e);
        }
        LinkedList files = new LinkedList();
        LinkedList<File> dirs = new LinkedList<File>();
        URLClassLoader ucl = RuntimeConfig.getInstance().getClassLoader() instanceof URLClassLoader ? (URLClassLoader)RuntimeConfig.getInstance().getClassLoader() : (URLClassLoader)RuntimeConfig.getInstance().getClassLoader().getParent();
        for (URL url : urls = ucl.getURLs()) {
            if (!url.getFile().contains("target/classes")) continue;
            File f = new File(url.getFile());
            if (!isDirectory && f.exists()) {
                files = (LinkedList)FileUtils.listFiles((File)f, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                this.addResources(files);
                continue;
            }
            files = (LinkedList)FileUtils.listFilesAndDirs((File)f, (IOFileFilter)DirectoryFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
            dirs.addAll(this.findLastDir(files));
        }
        scanner.setBasedir("src/main/resources/");
        scanner.setIncludes(new String[]{"**/*.dmn"});
        scanner.scan();
        this.decisionRefToPathMap = FileScanner.createDmnKeyToPathMap(new HashSet<String>(Arrays.asList(scanner.getIncludedFiles())));
        Rule rule = rules.get(VersioningChecker.class.getSimpleName());
        if (rule != null && rule.isActive()) {
            if (versioningScheme != null && !isDirectory) {
                scanner.setIncludes(new String[]{"**/*.groovy"});
                scanner.scan();
                this.includedFiles.addAll(Arrays.asList(scanner.getIncludedFiles()));
                this.resourcesNewestVersions = FileScanner.createResourcesToNewestVersions(this.includedFiles, versioningScheme);
            } else {
                for (File file : dirs) {
                    this.includedFiles.add(file.getAbsolutePath());
                }
                this.resourcesNewestVersions = FileScanner.createDirectoriesToNewestVersions(this.includedFiles, versioningScheme);
            }
        }
    }

    private LinkedList<File> findLastDir(LinkedList<File> list) {
        LinkedList<File> returnList = new LinkedList<File>();
        returnList.addAll(list);
        for (File f : list) {
            File[] fileArr;
            if (f.isFile()) {
                returnList.remove(f);
            }
            for (File uF : fileArr = f.listFiles()) {
                if (!uF.isDirectory()) continue;
                returnList.remove(f);
            }
        }
        return returnList;
    }

    private void addResources(LinkedList<File> classes) {
        for (File file : classes) {
            this.includedFiles.add(file.getName());
        }
    }

    public Set<String> getProcessdefinitions() {
        return this.processdefinitions;
    }

    public Map<String, String> getProcessIdToPathMap() {
        return this.processIdToPathMap;
    }

    public Map<String, String> getDecisionRefToPathMap() {
        return this.decisionRefToPathMap;
    }

    public Collection<String> getResourcesNewestVersions() {
        return this.resourcesNewestVersions;
    }

    static ClassLoader getClassLoader(MavenProject project) throws MalformedURLException, DependencyResolutionRequiredException {
        List classPathElements = project.getRuntimeClasspathElements();
        ArrayList<URL> classpathElementUrls = new ArrayList<URL>(classPathElements.size());
        for (String classPathElement : classPathElements) {
            classpathElementUrls.add(new File(classPathElement).toURI().toURL());
        }
        classpathElementUrls.add(new File("src/test/resources/").toURI().toURL());
        classpathElementUrls.add(new File("src/main/java/").toURI().toURL());
        return new URLClassLoader(classpathElementUrls.toArray(new URL[classpathElementUrls.size()]), Thread.currentThread().getContextClassLoader());
    }

    private static Map<String, String> createProcessIdToPathMap(Set<String> paths) {
        HashMap<String, String> keyToPathMap = new HashMap<String, String>();
        for (String path : paths) {
            Collection processes;
            BpmnModelInstance modelInstance = null;
            try {
                modelInstance = Bpmn.readModelFromFile((File)new File("src/main/resources/" + path));
            }
            catch (BpmnModelException ex) {
                throw new RuntimeException("bpmn model couldn't be read", ex);
            }
            if (modelInstance == null || (processes = modelInstance.getModelElementsByType(Process.class)) == null) continue;
            for (Process process : processes) {
                keyToPathMap.put(process.getId(), path);
            }
        }
        return keyToPathMap;
    }

    private static Map<String, String> createDmnKeyToPathMap(Set<String> paths) {
        HashMap<String, String> keyToPathMap = new HashMap<String, String>();
        for (String path : paths) {
            Collection decisions;
            DmnModelInstance modelInstance = null;
            try {
                modelInstance = Dmn.readModelFromFile((File)new File("src/main/resources/" + path));
            }
            catch (DmnModelException ex) {
                throw new RuntimeException("dmn model couldn't be read", ex);
            }
            if (modelInstance == null || (decisions = modelInstance.getModelElementsByType(Decision.class)) == null) continue;
            for (Decision decision : decisions) {
                keyToPathMap.put(decision.getId(), path);
            }
        }
        return keyToPathMap;
    }

    private static Collection<String> createDirectoriesToNewestVersions(Set<String> versionedFiles, String versioningSchema) {
        HashMap<String, String> newestVersionsPathMap = new HashMap<String, String>();
        HashMap<String, String> newestVersionsMap = new HashMap<String, String>();
        if (versionedFiles != null && versioningSchema != null) {
            for (String versionedFile : versionedFiles) {
                Pattern pattern = Pattern.compile(versioningSchema);
                Matcher matcher = pattern.matcher(versionedFile);
                while (matcher.find()) {
                    String temp = matcher.group(0).contains(File.separator) ? versionedFile.replace(matcher.group(0).substring(matcher.group(0).lastIndexOf(File.separator)), "") : versionedFile.replace(matcher.group(0), "");
                    String value = versionedFile.substring(versionedFile.lastIndexOf("classes") + 8);
                    String resource = temp.substring(temp.lastIndexOf("classes") + 8);
                    String oldVersion = (String)newestVersionsMap.get(resource);
                    if (oldVersion != null) {
                        if (oldVersion.compareTo(matcher.group(0)) >= 0) continue;
                        newestVersionsMap.put(resource, matcher.group(0));
                        newestVersionsPathMap.put(resource, value);
                        continue;
                    }
                    newestVersionsMap.put(resource, matcher.group(0));
                    newestVersionsPathMap.put(resource, value);
                }
            }
        }
        return newestVersionsPathMap.values();
    }

    private static Collection<String> createResourcesToNewestVersions(Set<String> versionedFiles, String versioningSchema) {
        HashMap<String, String> newestVersionsMap = new HashMap<String, String>();
        if (versionedFiles != null) {
            for (String versionedFile : versionedFiles) {
                Pattern pattern = Pattern.compile(versioningSchema);
                Matcher matcher = pattern.matcher(versionedFile);
                while (matcher.find()) {
                    String resource = matcher.group(1);
                    String oldVersion = (String)newestVersionsMap.get(resource);
                    if (oldVersion != null) {
                        if (oldVersion.compareTo(versionedFile) >= 0) continue;
                        newestVersionsMap.put(resource, versionedFile);
                        continue;
                    }
                    newestVersionsMap.put(resource, versionedFile);
                }
            }
        }
        return newestVersionsMap.values();
    }

    private static String loadVersioningScheme(Map<String, Rule> rules) throws ConfigItemNotFoundException {
        Rule rule = rules.get(VersioningChecker.class.getSimpleName());
        if (rule != null && rule.isActive()) {
            Setting setting = null;
            Map<String, Setting> settings = rule.getSettings();
            if (settings.containsKey("versioningSchemeClass") && !settings.containsKey("versioningSchemePackage")) {
                setting = settings.get("versioningSchemeClass");
                isDirectory = false;
            } else if (!settings.containsKey("versioningSchemeClass") && settings.containsKey("versioningSchemePackage")) {
                setting = settings.get("versioningSchemePackage");
                isDirectory = true;
            }
            if (setting == null) {
                throw new ConfigItemNotFoundException("Settings for VersioningChecker not found");
            }
            scheme = setting.getValue().trim();
        }
        return scheme;
    }

    public static String getVersioningScheme() {
        return scheme;
    }

    public Set<String> getJavaResourcesFileInputStream() {
        return this.javaResourcesFileInputStream;
    }

    public static boolean getIsDirectory() {
        return isDirectory;
    }

    public static void setIsDirectory(boolean isDirectory) {
        FileScanner.isDirectory = isDirectory;
    }
}

