/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BPMNScanner {
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder;
    private Document doc;
    private ModelVersionEnum modelVersion;

    public BPMNScanner(String path) throws ParserConfigurationException, SAXException, IOException {
        this.factory.setNamespaceAware(true);
        this.builder = this.factory.newDocumentBuilder();
        this.setModelVersion(path);
    }

    private void setModelVersion(String path) throws SAXException, IOException, ParserConfigurationException {
        this.doc = this.builder.parse(path);
        if (this.doc.getElementsByTagName("definitions").getLength() > 0) {
            this.modelVersion = ModelVersionEnum.V1;
        } else if (this.doc.getElementsByTagName("bpmn:definitions").getLength() > 0) {
            this.modelVersion = ModelVersionEnum.V2;
        } else if (this.doc.getElementsByTagName("bpmn2:definitions").getLength() > 0) {
            this.modelVersion = ModelVersionEnum.V3;
        } else {
            throw new ParserConfigurationException("Can't get the version of the BPMN Model");
        }
    }

    public String getImplementation(String id) {
        String returnImplementation = null;
        ArrayList<NodeList> listNodeList = new ArrayList<NodeList>();
        switch (this.modelVersion) {
            case V1: {
                listNodeList.add(this.doc.getElementsByTagName("businessRuleTask"));
                listNodeList.add(this.doc.getElementsByTagName("serviceTask"));
                listNodeList.add(this.doc.getElementsByTagName("sendTask"));
                listNodeList.add(this.doc.getElementsByTagName("endEvent"));
                listNodeList.add(this.doc.getElementsByTagName("intermediateThrowEvent"));
                break;
            }
            case V2: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn:businessRuleTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn:serviceTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn:sendTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn:endEvent"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn:intermediateThrowEvent"));
                break;
            }
            case V3: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:businessRuleTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:serviceTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:sendTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:endEvent"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:intermediateThrowEvent"));
                break;
            }
            default: {
                listNodeList = null;
            }
        }
        for (NodeList list : listNodeList) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element taskElement = (Element)list.item(i);
                NamedNodeMap taskElementAttr = taskElement.getAttributes();
                if (!id.equals(taskElement.getAttribute("id"))) continue;
                if (taskElementAttr.getLength() > 1) {
                    for (int x = 0; x < taskElementAttr.getLength(); ++x) {
                        Node attr = taskElementAttr.item(x);
                        String nodeName = attr.getNodeName();
                        if (!nodeName.equals("camunda:class") && !nodeName.equals("camunda:expression") && !nodeName.equals("camunda:delegateExpression") && !nodeName.equals("camunda:decisionRef") && !nodeName.equals("camunda:type")) continue;
                        returnImplementation = nodeName;
                    }
                }
                if (taskElementAttr.getNamedItem("camunda:class") != null || taskElementAttr.getNamedItem("camunda:expression") != null || taskElementAttr.getNamedItem("camunda:delegateExpression") != null || taskElementAttr.getNamedItem("camunda:decisionRef") != null || taskElementAttr.getNamedItem("camunda:type") != null) continue;
                returnImplementation = "implementation";
            }
        }
        return returnImplementation;
    }

    public String getImplementationReference(String id, String implementation) {
        String implementationReference = "";
        ArrayList<NodeList> listNodeList = new ArrayList<NodeList>();
        switch (this.modelVersion) {
            case V1: {
                listNodeList.add(this.doc.getElementsByTagName("businessRuleTask"));
                listNodeList.add(this.doc.getElementsByTagName("serviceTask"));
                listNodeList.add(this.doc.getElementsByTagName("sendTask"));
                break;
            }
            case V2: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn:businessRuleTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn:serviceTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn:sendTask"));
                break;
            }
            case V3: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:businessRuleTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:serviceTask"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:sendTask"));
                break;
            }
            default: {
                listNodeList = null;
            }
        }
        for (NodeList list : listNodeList) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element taskElement = (Element)list.item(i);
                if (!id.equals(taskElement.getAttribute("id"))) continue;
                if (implementation.equals("camunda:class")) {
                    implementationReference = taskElement.getAttribute("camunda:class");
                    continue;
                }
                if (!implementation.equals("camunda:delegateExpression")) continue;
                implementationReference = taskElement.getAttribute("camunda:delegateExpression");
            }
        }
        return implementationReference;
    }

    public String getEventImplementation(String id) {
        String returnImplementation = null;
        ArrayList<NodeList> listNodeList = new ArrayList<NodeList>();
        switch (this.modelVersion) {
            case V1: {
                listNodeList.add(this.doc.getElementsByTagName("endEvent"));
                listNodeList.add(this.doc.getElementsByTagName("intermediateThrowEvent"));
                break;
            }
            case V2: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn:endEvent"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn:intermediateThrowEvent"));
                break;
            }
            case V3: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:endEvent"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:intermediateThrowEvent"));
                break;
            }
            default: {
                listNodeList = null;
            }
        }
        for (NodeList list : listNodeList) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element taskElement = (Element)list.item(i);
                if (!id.equals(taskElement.getAttribute("id"))) continue;
                NodeList childNodes = taskElement.getChildNodes();
                for (int x = 0; x < childNodes.getLength(); ++x) {
                    if (childNodes.item(x).getLocalName() == null || !childNodes.item(x).getLocalName().equals("messageEventDefinition")) continue;
                    Element event = (Element)childNodes.item(x);
                    if (event.getAttributeNode("camunda:expression") != null) {
                        returnImplementation = event.getAttributeNode("camunda:expression").toString();
                    } else if (event.getAttributeNode("camunda:delegateExpression") != null) {
                        returnImplementation = event.getAttributeNode("camunda:delegateExpression").toString();
                    } else if (event.getAttributeNode("camunda:class") != null) {
                        returnImplementation = event.getAttributeNode("camunda:class").toString();
                    } else if (event.getAttributeNode("camunda:type") != null) {
                        returnImplementation = event.getAttributeNode("camunda:type").toString();
                    }
                    if (event.getAttributeNode("camunda:delegateExpression") != null || event.getAttributeNode("camunda:expression") != null || event.getAttributeNode("camunda:class") != null || event.getAttributeNode("camunda:type") != null) continue;
                    returnImplementation = "implementation";
                }
            }
        }
        return returnImplementation;
    }

    public ArrayList<String> getListener(String id, String listType, String extType) {
        NodeList nodeListExtensionElements;
        ArrayList<String> returnAttrList = new ArrayList<String>();
        switch (this.modelVersion) {
            case V1: {
                nodeListExtensionElements = this.doc.getElementsByTagName("extensionElements");
                break;
            }
            case V2: {
                nodeListExtensionElements = this.doc.getElementsByTagName("bpmn:extensionElements");
                break;
            }
            case V3: {
                nodeListExtensionElements = this.doc.getElementsByTagName("bpmn2:extensionElements");
                break;
            }
            default: {
                nodeListExtensionElements = null;
            }
        }
        for (int i = 0; i < nodeListExtensionElements.getLength(); ++i) {
            if (!((Element)nodeListExtensionElements.item(i).getParentNode()).getAttribute("id").equals(id)) continue;
            NodeList childNodes = nodeListExtensionElements.item(i).getChildNodes();
            for (int x = 0; x < childNodes.getLength(); ++x) {
                String attName;
                if (!childNodes.item(x).getNodeName().equals(extType) || (attName = this.checkAttributesOfNode(childNodes.item(x), listType)) == null) continue;
                returnAttrList.add(attName);
            }
        }
        return returnAttrList;
    }

    private String checkAttributesOfNode(Node node, String listType) {
        NamedNodeMap attributes = node.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            if (!attributes.item(x).getNodeName().equals(listType)) continue;
            return attributes.item(x).getTextContent();
        }
        return null;
    }

    public ArrayList<String> getScriptTypes(String id) {
        ArrayList<String> returnScriptType = new ArrayList<String>();
        NodeList nodeList = this.doc.getElementsByTagName("camunda:script");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i).getParentNode();
            if (!this.idMatch(nodeList.item(i), id)) continue;
            returnScriptType.add(n.getLocalName());
        }
        return returnScriptType;
    }

    private boolean idMatch(Node n, String id) {
        Element e = (Element)n;
        if (e.getAttribute("id").equals(id)) {
            return true;
        }
        while (e.getParentNode() != null && !e.getParentNode().getLocalName().equals("process")) {
            Element check = (Element)e.getParentNode();
            if (check.getAttribute("id").equals(id)) {
                return true;
            }
            e = (Element)e.getParentNode();
        }
        return false;
    }

    public boolean hasScriptInCondExp(String id) {
        NodeList nodeList = null;
        switch (this.modelVersion) {
            case V1: {
                nodeList = this.doc.getElementsByTagName("sequenceFlow");
                break;
            }
            case V2: {
                nodeList = this.doc.getElementsByTagName("bpmn:sequenceFlow");
                break;
            }
            case V3: {
                nodeList = this.doc.getElementsByTagName("bpmn2:sequenceFlow");
            }
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element sequenceElement = (Element)nodeList.item(i);
            if (!sequenceElement.getAttribute("id").equals(id)) continue;
            return this.hasCondExp(sequenceElement);
        }
        return false;
    }

    private boolean hasCondExp(Element sq) {
        NodeList childNodes = null;
        if (sq.hasChildNodes()) {
            childNodes = sq.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element childElement;
                Node childNode = childNodes.item(i);
                if (childNode.getLocalName() == null || !childNode.getLocalName().equals("conditionExpression") || (childElement = (Element)childNode).getAttribute("language").trim().length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getXorGateWays(String id) {
        NodeList nodeList;
        String gateway = "";
        switch (this.modelVersion) {
            case V1: {
                nodeList = this.doc.getElementsByTagName("exclusiveGateway");
                break;
            }
            case V2: {
                nodeList = this.doc.getElementsByTagName("bpmn:exclusiveGateway");
                break;
            }
            case V3: {
                nodeList = this.doc.getElementsByTagName("bpmn2:exclusiveGateway");
                break;
            }
            default: {
                return "";
            }
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element taskElement = (Element)nodeList.item(i);
            if (!id.equals(taskElement.getAttribute("id"))) continue;
            gateway = taskElement.getAttribute("id");
        }
        return gateway;
    }

    public int getOutgoing(String id) {
        NodeList nodeList;
        String out = "";
        int outgoing = 0;
        switch (this.modelVersion) {
            case V1: {
                nodeList = this.doc.getElementsByTagName("exclusiveGateway");
                out = "outgoing";
                break;
            }
            case V2: {
                nodeList = this.doc.getElementsByTagName("bpmn:exclusiveGateway");
                out = "bpmn:outgoing";
                break;
            }
            case V3: {
                nodeList = this.doc.getElementsByTagName("bpmn2:exclusiveGateway");
                out = "bpmn2:outgoing";
                break;
            }
            default: {
                return -1;
            }
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element taskElement = (Element)nodeList.item(i);
            if (!id.equals(taskElement.getAttribute("id"))) continue;
            NodeList childNodeGateway = taskElement.getChildNodes();
            for (int x = 0; x < childNodeGateway.getLength(); ++x) {
                if (!childNodeGateway.item(x).getNodeName().equals(out)) continue;
                ++outgoing;
            }
        }
        return outgoing;
    }

    public ArrayList<Node> getOutgoingEdges(String id) {
        ArrayList<Node> outgoingEdges = new ArrayList<Node>();
        NodeList nodeList = null;
        String out = "";
        switch (this.modelVersion) {
            case V1: {
                nodeList = this.doc.getElementsByTagName("exclusiveGateway");
                out = "outgoing";
                break;
            }
            case V2: {
                nodeList = this.doc.getElementsByTagName("bpmn:exclusiveGateway");
                out = "bpmn:outgoing";
                break;
            }
            case V3: {
                nodeList = this.doc.getElementsByTagName("bpmn2:exclusiveGateway");
                out = "bpmn2:outgoing";
            }
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element taskElement = (Element)nodeList.item(i);
            if (!id.equals(taskElement.getAttribute("id"))) continue;
            NodeList children = taskElement.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals(out)) continue;
                outgoingEdges.add(this.checkNamingOfEdges(children.item(j).getTextContent()));
            }
        }
        return outgoingEdges;
    }

    public Node checkNamingOfEdges(String id) {
        Element edge = null;
        NodeList nodeList = null;
        switch (this.modelVersion) {
            case V1: {
                nodeList = this.doc.getElementsByTagName("sequenceFlow");
                break;
            }
            case V2: {
                nodeList = this.doc.getElementsByTagName("bpmn:sequenceFlow");
                break;
            }
            case V3: {
                nodeList = this.doc.getElementsByTagName("bpmn2:sequenceFlow");
            }
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element taskElement = (Element)nodeList.item(i);
            if (!taskElement.getAttribute("id").equals(id)) continue;
            edge = taskElement;
        }
        return edge;
    }

    public Map<Element, Element> getTimerImplementation(String id) {
        ArrayList<NodeList> listNodeList = new ArrayList<NodeList>();
        switch (this.modelVersion) {
            case V1: {
                listNodeList.add(this.doc.getElementsByTagName("startEvent"));
                listNodeList.add(this.doc.getElementsByTagName("intermediateCatchEvent"));
                listNodeList.add(this.doc.getElementsByTagName("boundaryEvent"));
                break;
            }
            case V2: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn:startEvent"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn:intermediateCatchEvent"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn:boundaryEvent"));
                break;
            }
            case V3: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:startEvent"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:intermediateCatchEvent"));
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:boundaryEvent"));
                break;
            }
            default: {
                listNodeList = null;
            }
        }
        HashMap<Element, Element> timerList = new HashMap<Element, Element>();
        for (NodeList list : listNodeList) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element taskElement = (Element)list.item(i);
                if (!taskElement.getAttribute("id").equals(id)) continue;
                NodeList childNodes = taskElement.getChildNodes();
                for (int x = 0; x < childNodes.getLength(); ++x) {
                    if (childNodes.item(x).getLocalName() == null || !childNodes.item(x).getLocalName().equals("timerEventDefinition")) continue;
                    timerList.put(taskElement, null);
                    Element taskElement2 = (Element)childNodes.item(x);
                    NodeList childChildNodes = taskElement2.getChildNodes();
                    for (int y = 0; y < childChildNodes.getLength(); ++y) {
                        if (childChildNodes.item(y).getLocalName() == null) continue;
                        timerList.put(taskElement, (Element)childChildNodes.item(y));
                    }
                }
            }
        }
        return timerList;
    }

    public String getMessageName(String messageRef) {
        ArrayList<NodeList> listNodeList = new ArrayList<NodeList>();
        String messageName = "";
        switch (this.modelVersion) {
            case V1: {
                listNodeList.add(this.doc.getElementsByTagName("message"));
                break;
            }
            case V2: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn:message"));
                break;
            }
            case V3: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:message"));
                break;
            }
            default: {
                listNodeList = null;
            }
        }
        for (NodeList list : listNodeList) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element taskElement = (Element)list.item(i);
                if (!taskElement.getAttribute("id").equals(messageRef)) continue;
                messageName = taskElement.getAttribute("name");
            }
        }
        return messageName;
    }

    private ArrayList<String> getInOutVariables(String id, String inOut) {
        ArrayList<String> listVariables = new ArrayList<String>();
        NodeList nodeList = this.doc.getElementsByTagName(inOut);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!this.idMatch(node, id)) continue;
            listVariables.add(((Element)node).getAttribute("name"));
        }
        return listVariables;
    }

    public ArrayList<String> getOutputVariables(String id) {
        return this.getInOutVariables(id, "camunda:outputParameter");
    }

    public ArrayList<String> getInOutputVariablesValue(String id) {
        ArrayList<String> variableValues = this.getInOutputVariablesValue(id, "camunda:inputParameter");
        variableValues.addAll(this.getInOutputVariablesValue(id, "camunda:outputParameter"));
        return variableValues;
    }

    private ArrayList<String> getInOutputVariablesValue(String id, String inOut) {
        ArrayList<String> listVariablesValue = new ArrayList<String>();
        NodeList nodeList = this.doc.getElementsByTagName(inOut);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!this.idMatch(node, id)) continue;
            if (node.hasChildNodes() && node.getChildNodes().getLength() > 1) {
                NodeList nodeChilds = node.getChildNodes();
                for (int y = 0; y < nodeChilds.getLength(); ++y) {
                    if (nodeChilds.item(y).getNodeName().equals("camunda:list")) {
                        NodeList listChilds = nodeChilds.item(y).getChildNodes();
                        for (int z = 0; z < listChilds.getLength(); ++z) {
                            if (!listChilds.item(z).getNodeName().equals("camunda:value")) continue;
                            listVariablesValue.add(listChilds.item(z).getTextContent());
                        }
                        continue;
                    }
                    if (!nodeChilds.item(y).getNodeName().equals("camunda:map")) continue;
                    NodeList mapChilds = nodeChilds.item(y).getChildNodes();
                    for (int x = 0; x < mapChilds.getLength(); ++x) {
                        if (!mapChilds.item(x).getNodeName().equals("camunda:entry")) continue;
                        listVariablesValue.add(mapChilds.item(x).getTextContent());
                    }
                }
                continue;
            }
            listVariablesValue.add(node.getTextContent());
        }
        return listVariablesValue;
    }

    public ArrayList<String> getInputVariables(String id) {
        return this.getInOutVariables(id, "camunda:inputParameter");
    }

    public ArrayList<String> getFieldInjectionExpression(String id) {
        ArrayList<String> varNames = new ArrayList<String>();
        NodeList nodeList = this.doc.getElementsByTagName("camunda:field");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!this.idMatch(node, id)) continue;
            for (int y = 0; y < node.getChildNodes().getLength(); ++y) {
                if (!node.getChildNodes().item(y).getNodeName().equals("camunda:expression")) continue;
                varNames.add(node.getChildNodes().item(y).getTextContent());
            }
        }
        return varNames;
    }

    public ArrayList<String> getFieldInjectionVarName(String id) {
        ArrayList<String> varNames = new ArrayList<String>();
        NodeList nodeList = this.doc.getElementsByTagName("camunda:field");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!this.idMatch(node, id)) continue;
            for (int y = 0; y < node.getAttributes().getLength(); ++y) {
                if (!node.getAttributes().item(y).getNodeName().equals("name")) continue;
                varNames.add(node.getAttributes().item(y).getNodeValue());
            }
        }
        return varNames;
    }

    public Map<String, String> getErrorEvent(String id) {
        ArrayList<NodeList> listNodeList = new ArrayList<NodeList>();
        switch (this.modelVersion) {
            case V1: {
                listNodeList.add(this.doc.getElementsByTagName("boundaryEvent"));
                break;
            }
            case V2: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn:boundaryEvent"));
                break;
            }
            case V3: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:boundaryEvent"));
                break;
            }
            default: {
                listNodeList = null;
            }
        }
        HashMap<String, String> boundaryEventList = new HashMap<String, String>();
        for (NodeList list : listNodeList) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element taskElement = (Element)list.item(i);
                if (!taskElement.getAttribute("id").equals(id)) continue;
                NodeList childNodes = taskElement.getChildNodes();
                for (int x = 0; x < childNodes.getLength(); ++x) {
                    if (childNodes.item(x).getLocalName() == null || !childNodes.item(x).getLocalName().equals("errorEventDefinition")) continue;
                    Element taskElement2 = (Element)childNodes.item(x);
                    boundaryEventList.put(taskElement2.getAttribute("errorRef"), taskElement2.getAttribute("camunda:errorMessageVariable"));
                }
            }
        }
        return boundaryEventList;
    }

    public Map<String, String> getErrorDef(String id) {
        NodeList nodeList = null;
        switch (this.modelVersion) {
            case V1: {
                nodeList = this.doc.getElementsByTagName("error");
                break;
            }
            case V2: {
                nodeList = this.doc.getElementsByTagName("bpmn:error");
                break;
            }
            case V3: {
                nodeList = this.doc.getElementsByTagName("bpmn2:error");
                break;
            }
        }
        HashMap<String, String> errorDef = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element taskElement = (Element)nodeList.item(i);
            if (!id.equals(taskElement.getAttribute("id"))) continue;
            errorDef.put(taskElement.getAttribute("name"), taskElement.getAttribute("errorCode"));
        }
        return errorDef;
    }

    public String getErrorCodeVar(String id) {
        ArrayList<NodeList> listNodeList = new ArrayList<NodeList>();
        switch (this.modelVersion) {
            case V1: {
                listNodeList.add(this.doc.getElementsByTagName("boundaryEvent"));
                break;
            }
            case V2: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn:boundaryEvent"));
                break;
            }
            case V3: {
                listNodeList.add(this.doc.getElementsByTagName("bpmn2:boundaryEvent"));
                break;
            }
            default: {
                listNodeList = null;
            }
        }
        String getErrorCodeVar = "";
        for (NodeList list : listNodeList) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element taskElement = (Element)list.item(i);
                if (!taskElement.getAttribute("id").equals(id)) continue;
                NodeList childNodes = taskElement.getChildNodes();
                for (int x = 0; x < childNodes.getLength(); ++x) {
                    if (childNodes.item(x).getLocalName() == null || !childNodes.item(x).getLocalName().equals("errorEventDefinition")) continue;
                    Element taskElement2 = (Element)childNodes.item(x);
                    getErrorCodeVar = taskElement2.getAttribute("camunda:errorCodeVariable");
                }
            }
        }
        return getErrorCodeVar;
    }

    public String getErrorEventMapping(String id) {
        String attachedToTask = "";
        NodeList nodeList = null;
        switch (this.modelVersion) {
            case V1: {
                nodeList = this.doc.getElementsByTagName("boundaryEvent");
                break;
            }
            case V2: {
                nodeList = this.doc.getElementsByTagName("bpmn:boundaryEvent");
                break;
            }
            case V3: {
                nodeList = this.doc.getElementsByTagName("bpmn2:boundaryEvent");
                break;
            }
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element taskElement = (Element)nodeList.item(i);
            if (!id.equals(taskElement.getAttribute("id"))) continue;
            attachedToTask = taskElement.getAttribute("attachedToRef");
        }
        return attachedToTask;
    }

    public Map<String, String> getKeyPairs(String id) {
        HashMap<String, String> keyPairs = new HashMap<String, String>();
        NodeList nodeList = this.doc.getElementsByTagName("camunda:property");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element parent_element = (Element)nodeList.item(i).getParentNode().getParentNode().getParentNode();
            if (!parent_element.getAttribute("id").equals(id)) continue;
            Element extension_node = (Element)nodeList.item(i);
            keyPairs.put(extension_node.getAttribute("name"), extension_node.getAttribute("value"));
        }
        return keyPairs;
    }

    private static enum ModelVersionEnum {
        V1,
        V2,
        V3;

    }
}

