/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Exit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Pattern HOST_PORT_PATTERN = Pattern.compile(".*?\\[?([0-9a-zA-Z\\-%._:]*)\\]?:([0-9]+)");
    public static final String NL = System.getProperty("line.separator");
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static <T extends Comparable<? super T>> List<T> sorted(Collection<T> collection) {
        ArrayList<T> res = new ArrayList<T>(collection);
        Collections.sort(res);
        return Collections.unmodifiableList(res);
    }

    public static String utf8(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String utf8(ByteBuffer buffer, int length) {
        return Utils.utf8(buffer, 0, length);
    }

    public static String utf8(ByteBuffer buffer, int offset, int length) {
        if (buffer.hasArray()) {
            return new String(buffer.array(), buffer.arrayOffset() + buffer.position() + offset, length, StandardCharsets.UTF_8);
        }
        return Utils.utf8(Utils.toArray(buffer, offset, length));
    }

    public static byte[] utf8(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static int abs(int n) {
        return n == Integer.MIN_VALUE ? 0 : Math.abs(n);
    }

    public static long min(long first, long ... rest) {
        long min = first;
        for (long r : rest) {
            if (r >= min) continue;
            min = r;
        }
        return min;
    }

    public static long max(long first, long ... rest) {
        long max = first;
        for (long r : rest) {
            if (r <= max) continue;
            max = r;
        }
        return max;
    }

    public static short min(short first, short second) {
        return (short)Math.min(first, second);
    }

    public static int utf8Length(CharSequence s) {
        int count2 = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                ++count2;
                continue;
            }
            if (ch <= '\u07ff') {
                count2 += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count2 += 4;
                ++i;
                continue;
            }
            count2 += 3;
        }
        return count2;
    }

    public static byte[] toArray(ByteBuffer buffer) {
        return Utils.toArray(buffer, 0, buffer.remaining());
    }

    public static byte[] toArray(ByteBuffer buffer, int size) {
        return Utils.toArray(buffer, 0, size);
    }

    public static byte[] toNullableArray(ByteBuffer buffer) {
        return buffer == null ? null : Utils.toArray(buffer);
    }

    public static ByteBuffer wrapNullable(byte[] array) {
        return array == null ? null : ByteBuffer.wrap(array);
    }

    public static byte[] toArray(ByteBuffer buffer, int offset, int size) {
        byte[] dest = new byte[size];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.position() + buffer.arrayOffset() + offset, dest, 0, size);
        } else {
            int pos = buffer.position();
            buffer.position(pos + offset);
            buffer.get(dest);
            buffer.position(pos);
        }
        return dest;
    }

    public static <T> T notNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static <T> T newInstance(Class<T> c) {
        try {
            return c.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new KafkaException("Could not instantiate class " + c.getName(), e);
        }
        catch (InstantiationException e) {
            throw new KafkaException("Could not instantiate class " + c.getName() + " Does it have a public no-argument constructor?", e);
        }
        catch (NullPointerException e) {
            throw new KafkaException("Requested class was null", e);
        }
    }

    public static <T> T newInstance(String klass, Class<T> base) throws ClassNotFoundException {
        return Utils.newInstance(Class.forName(klass, true, Utils.getContextOrKafkaClassLoader()).asSubclass(base));
    }

    public static int murmur2(byte[] data) {
        int length = data.length;
        int seed = -1756908916;
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int length4 = length / 4;
        for (int i = 0; i < length4; ++i) {
            int i4 = i * 4;
            int k = (data[i4 + 0] & 0xFF) + ((data[i4 + 1] & 0xFF) << 8) + ((data[i4 + 2] & 0xFF) << 16) + ((data[i4 + 3] & 0xFF) << 24);
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        switch (length % 4) {
            case 3: {
                h ^= (data[(length & 0xFFFFFFFC) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (data[(length & 0xFFFFFFFC) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= data[length & 0xFFFFFFFC] & 0xFF;
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }

    public static String getHost(String address) {
        Matcher matcher = HOST_PORT_PATTERN.matcher(address);
        return matcher.matches() ? matcher.group(1) : null;
    }

    public static Integer getPort(String address) {
        Matcher matcher = HOST_PORT_PATTERN.matcher(address);
        return matcher.matches() ? Integer.valueOf(Integer.parseInt(matcher.group(2))) : null;
    }

    public static String formatAddress(String host, Integer port) {
        return host.contains(":") ? "[" + host + "]:" + port : host + ":" + port;
    }

    public static <T> String join(T[] strs, String separator) {
        return Utils.join(Arrays.asList(strs), separator);
    }

    public static <T> String join(Collection<T> list, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static <K, V> String mkString(Map<K, V> map, String begin, String end, String keyValueSeparator, String elementSeparator) {
        StringBuilder bld = new StringBuilder();
        bld.append(begin);
        String prefix = "";
        for (Map.Entry<K, V> entry : map.entrySet()) {
            bld.append(prefix).append(entry.getKey()).append(keyValueSeparator).append(entry.getValue());
            prefix = elementSeparator;
        }
        bld.append(end);
        return bld.toString();
    }

    public static Properties loadProps(String filename) throws IOException, FileNotFoundException {
        Properties props = new Properties();
        try (FileInputStream propStream = new FileInputStream(filename);){
            props.load(propStream);
        }
        return props;
    }

    public static Map<String, String> propsToStringMap(Properties props) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return result;
    }

    public static String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static Thread newThread(String name, Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("Uncaught exception in thread '{}':", (Object)t.getName(), (Object)e);
            }
        });
        return thread;
    }

    public static Thread daemonThread(String name, Runnable runnable) {
        return Utils.newThread(name, runnable, true);
    }

    public static void croak(String message) {
        System.err.println(message);
        Exit.exit(1);
    }

    public static byte[] readBytes(ByteBuffer buffer, int offset, int length) {
        byte[] dest = new byte[length];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset() + offset, dest, 0, length);
        } else {
            buffer.mark();
            buffer.position(offset);
            buffer.get(dest, 0, length);
            buffer.reset();
        }
        return dest;
    }

    public static byte[] readBytes(ByteBuffer buffer) {
        return Utils.readBytes(buffer, 0, buffer.limit());
    }

    public static String readFileAsString(String path, Charset charset) throws IOException {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try (FileInputStream stream = new FileInputStream(new File(path));){
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = charset.decode(bb).toString();
            return string;
        }
    }

    public static String readFileAsString(String path) throws IOException {
        return Utils.readFileAsString(path, Charset.defaultCharset());
    }

    public static ByteBuffer ensureCapacity(ByteBuffer existingBuffer, int newLength) {
        if (newLength > existingBuffer.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocate(newLength);
            existingBuffer.flip();
            newBuffer.put(existingBuffer);
            return newBuffer;
        }
        return existingBuffer;
    }

    @SafeVarargs
    public static <T> Set<T> mkSet(T ... elems) {
        return new HashSet<T>(Arrays.asList(elems));
    }

    @SafeVarargs
    public static <T> List<T> mkList(T ... elems) {
        return Arrays.asList(elems);
    }

    public static void delete(final File file) throws IOException {
        if (file == null) {
            return;
        }
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                if (exc instanceof NoSuchFileException && path.toFile().equals(file)) {
                    return FileVisitResult.TERMINATE;
                }
                throw exc;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException exc) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static <T> List<T> safe(List<T> other) {
        return other == null ? Collections.emptyList() : other;
    }

    public static ClassLoader getKafkaClassLoader() {
        return Utils.class.getClassLoader();
    }

    public static ClassLoader getContextOrKafkaClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return Utils.getKafkaClassLoader();
        }
        return cl;
    }

    public static void atomicMoveWithFallback(Path source, Path target) throws IOException {
        try {
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException outer) {
            try {
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
                log.debug("Non-atomic move of {} to {} succeeded after atomic move failed due to {}", new Object[]{source, target, outer.getMessage()});
            }
            catch (IOException inner) {
                inner.addSuppressed(outer);
                throw inner;
            }
        }
    }

    public static void closeAll(Closeable ... closeables) throws IOException {
        IOException exception = null;
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (exception != null) {
                    exception.addSuppressed(e);
                    continue;
                }
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void closeQuietly(AutoCloseable closeable, String name) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                log.warn("Failed to close {}", (Object)name, (Object)t);
            }
        }
    }

    public static int toPositive(int number) {
        return number & Integer.MAX_VALUE;
    }

    public static int longHashcode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static ByteBuffer sizeDelimited(ByteBuffer buffer, int start2) {
        int size = buffer.getInt(start2);
        if (size < 0) {
            return null;
        }
        ByteBuffer b = buffer.duplicate();
        b.position(start2 + 4);
        b = b.slice();
        b.limit(size);
        b.rewind();
        return b;
    }

    public static void readFullyOrFail(FileChannel channel, ByteBuffer destinationBuffer, long position, String description) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("The file channel position cannot be negative, but it is " + position);
        }
        int expectedReadBytes = destinationBuffer.remaining();
        Utils.readFully(channel, destinationBuffer, position);
        if (destinationBuffer.hasRemaining()) {
            throw new EOFException(String.format("Failed to read `%s` from file channel `%s`. Expected to read %d bytes, but reached end of file after reading %d bytes. Started read from position %d.", description, channel, expectedReadBytes, expectedReadBytes - destinationBuffer.remaining(), position));
        }
    }

    public static void readFully(FileChannel channel, ByteBuffer destinationBuffer, long position) throws IOException {
        int bytesRead;
        if (position < 0L) {
            throw new IllegalArgumentException("The file channel position cannot be negative, but it is " + position);
        }
        long currentPosition = position;
        do {
            bytesRead = channel.read(destinationBuffer, currentPosition);
            currentPosition += (long)bytesRead;
        } while (bytesRead != -1 && destinationBuffer.hasRemaining());
    }

    public static final void readFully(InputStream inputStream, ByteBuffer destinationBuffer) throws IOException {
        int bytesRead;
        if (!destinationBuffer.hasArray()) {
            throw new IllegalArgumentException("destinationBuffer must be backed by an array");
        }
        int initialOffset = destinationBuffer.arrayOffset() + destinationBuffer.position();
        byte[] array = destinationBuffer.array();
        int length = destinationBuffer.remaining();
        int totalBytesRead = 0;
        while ((bytesRead = inputStream.read(array, initialOffset + totalBytesRead, length - totalBytesRead)) != -1 && length > (totalBytesRead += bytesRead)) {
        }
        destinationBuffer.position(destinationBuffer.position() + totalBytesRead);
    }

    public static void writeFully(FileChannel channel, ByteBuffer sourceBuffer) throws IOException {
        while (sourceBuffer.hasRemaining()) {
            channel.write(sourceBuffer);
        }
    }

    public static void writeTo(DataOutput out, ByteBuffer buffer, int length) throws IOException {
        if (buffer.hasArray()) {
            out.write(buffer.array(), buffer.position() + buffer.arrayOffset(), length);
        } else {
            int pos;
            for (int i = pos = buffer.position(); i < length + pos; ++i) {
                out.writeByte(buffer.get(i));
            }
        }
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> res = new ArrayList<T>();
        while (iterator.hasNext()) {
            res.add(iterator.next());
        }
        return res;
    }
}

