/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.runner;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import de.viadee.ki.sparkimporter.exceptions.FaultyConfigurationException;
import de.viadee.ki.sparkimporter.processing.PreprocessingRunner;
import de.viadee.ki.sparkimporter.processing.steps.PipelineStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.AddReducedColumnsToDatasetStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.AddVariableColumnsStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.AggregateProcessInstancesStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.ColumnHashStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.ColumnRemoveStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.CreateColumnsFromJsonStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.DataFilterStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.DetermineProcessVariablesStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.ReduceColumnsStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.TypeCastStep;
import de.viadee.ki.sparkimporter.processing.steps.importing.InitialCleanupStep;
import de.viadee.ki.sparkimporter.processing.steps.output.WriteToDiscStep;
import de.viadee.ki.sparkimporter.runner.SparkRunner;
import de.viadee.ki.sparkimporter.util.SparkImporterCSVArguments;
import de.viadee.ki.sparkimporter.util.SparkImporterLogger;
import de.viadee.ki.sparkimporter.util.SparkImporterUtils;
import de.viadee.ki.sparkimporter.util.SparkImporterVariables;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVImportAndProcessingRunner
extends SparkRunner {
    private static final Logger LOG = LoggerFactory.getLogger(CSVImportAndProcessingRunner.class);
    public static SparkImporterCSVArguments ARGS;

    @Override
    protected void initialize(String[] arguments) {
        SparkImporterVariables.setRunningMode(SparkRunner.RUNNING_MODE.CSV_IMPORT_AND_PROCESSING);
        ARGS = SparkImporterCSVArguments.getInstance();
        JCommander jCommander = JCommander.newBuilder().addObject(SparkImporterCSVArguments.getInstance()).build();
        try {
            jCommander.parse(arguments);
        }
        catch (ParameterException e) {
            LOG.error("Parsing of parameters failed. Error message: " + e.getMessage());
            jCommander.usage();
            System.exit(1);
        }
        SparkImporterVariables.setRunningMode(SparkRunner.RUNNING_MODE.CSV_IMPORT_AND_PROCESSING);
        SparkImporterVariables.setTargetFolder(ARGS.getFileDestination());
        SparkImporterVariables.setDevTypeCastCheckEnabled(ARGS.isDevTypeCastCheckEnabled());
        SparkImporterVariables.setDevProcessStateColumnWorkaroundEnabled(ARGS.isDevProcessStateColumnWorkaroundEnabled());
        SparkImporterVariables.setRevCountEnabled(ARGS.isRevisionCount());
        SparkImporterVariables.setSaveMode(ARGS.getSaveMode() == "append" ? SaveMode.Append : SaveMode.Overwrite);
        SparkImporterVariables.setOutputFormat(ARGS.getOutputFormat());
        SparkImporterVariables.setWorkingDirectory(ARGS.getWorkingDirectory());
        SparkImporterLogger.setLogDirectory(ARGS.getLogDirectory());
        SparkImporterVariables.setProcessFilterDefinitionId(ARGS.getProcessDefinitionFilterId());
        this.dataLevel = "process";
        if (SparkImporterVariables.isDevProcessStateColumnWorkaroundEnabled() && this.dataLevel.equals("activity")) {
            try {
                throw new FaultyConfigurationException("Process state workaround option cannot be used with activity data level.");
            }
            catch (FaultyConfigurationException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        PreprocessingRunner.writeStepResultsIntoFile = ARGS.isWriteStepResultsToCSV();
        if (SparkImporterVariables.getSaveMode().equals((Object)SaveMode.Overwrite)) {
            FileUtils.deleteQuietly((File)new File(ARGS.getFileDestination()));
        }
        SparkImporterLogger.getInstance().writeInfo("Starting CSV import and processing");
        SparkImporterLogger.getInstance().writeInfo("Importing CSV file: " + ARGS.getFileSource());
    }

    @Override
    protected List<PipelineStep> buildDefaultPipeline() {
        ArrayList<PipelineStep> pipelineSteps = new ArrayList<PipelineStep>();
        pipelineSteps.add(new PipelineStep(new DataFilterStep(), ""));
        pipelineSteps.add(new PipelineStep(new ColumnRemoveStep(), "DataFilterStep"));
        pipelineSteps.add(new PipelineStep(new ReduceColumnsStep(), "ColumnRemoveStep"));
        pipelineSteps.add(new PipelineStep(new DetermineProcessVariablesStep(), "ReduceColumnsStep"));
        pipelineSteps.add(new PipelineStep(new AddVariableColumnsStep(), "DetermineProcessVariablesStep"));
        pipelineSteps.add(new PipelineStep(new AggregateProcessInstancesStep(), "AddVariableColumnsStep"));
        pipelineSteps.add(new PipelineStep(new CreateColumnsFromJsonStep(), "AggregateProcessInstancesStep"));
        pipelineSteps.add(new PipelineStep(new AddReducedColumnsToDatasetStep(), "CreateColumnsFromJsonStep"));
        pipelineSteps.add(new PipelineStep(new ColumnHashStep(), "AddReducedColumnsToDatasetStep"));
        pipelineSteps.add(new PipelineStep(new TypeCastStep(), "ColumnHashStep"));
        pipelineSteps.add(new PipelineStep(new WriteToDiscStep(), "TypeCastStep"));
        return pipelineSteps;
    }

    @Override
    protected Dataset<Row> loadInitialDataset() {
        Dataset<Row> dataset = this.sparkSession.read().option("inferSchema", "true").option("delimiter", ARGS.getDelimiter()).option("header", "true").option("ignoreLeadingWhiteSpace", "false").option("ignoreTrailingWhiteSpace", "false").csv(ARGS.getFileSource());
        if (SparkImporterCSVArguments.getInstance().isWriteStepResultsToCSV()) {
            SparkImporterUtils.getInstance().writeDatasetToCSV(dataset, "import_result");
        }
        InitialCleanupStep initialCleanupStep = new InitialCleanupStep();
        dataset = initialCleanupStep.runPreprocessingStep(dataset, false, "process", null);
        return dataset;
    }
}

