/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.processing.aggregation;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.MutableAggregationBuffer;
import org.apache.spark.sql.expressions.UserDefinedAggregateFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class AllButEmptyStringAggregationFunction
extends UserDefinedAggregateFunction {
    private StructType inputSchema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"value", (DataType)DataTypes.StringType, (boolean)true)});
    private StructType bufferSchema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"currentSelection", (DataType)DataTypes.StringType, (boolean)true)});

    public StructType inputSchema() {
        return this.inputSchema;
    }

    public StructType bufferSchema() {
        return this.bufferSchema;
    }

    public DataType dataType() {
        return DataTypes.StringType;
    }

    public boolean deterministic() {
        return true;
    }

    public void initialize(MutableAggregationBuffer buffer) {
        buffer.update(0, (Object)"");
    }

    public void update(MutableAggregationBuffer buffer, Row input) {
        if (!input.isNullAt(0)) {
            String currentValue = buffer.size() == 0 || buffer.getString(0) == null ? "" : buffer.getString(0);
            String value = currentValue.equals("") ? input.getString(0) : currentValue;
            buffer.update(0, (Object)value);
        }
    }

    public void merge(MutableAggregationBuffer buffer1, Row buffer2) {
        String value = "";
        if (!buffer1.isNullAt(0) && !buffer2.isNullAt(0)) {
            String b1 = buffer1.getString(0);
            String b2 = buffer2.getString(0);
            value = b1.equals("") ? b2 : b1;
        } else {
            value = !buffer1.isNullAt(0) ? buffer2.getString(0) : buffer1.getString(0);
        }
        buffer1.update(0, (Object)value);
    }

    public String evaluate(Row buffer) {
        return buffer.getString(0);
    }
}

