/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.processing;

import de.viadee.ki.sparkimporter.processing.steps.PipelineStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class PreprocessingRunner {
    private final List<PipelineStep> pipelineSteps = new ArrayList<PipelineStep>();
    private static int stepCounter = 0;
    public static final String DATASET_INITIAL = "initial";
    public static final Map<String, Dataset<Row>> helper_datasets = new HashMap<String, Dataset<Row>>();
    public static boolean writeStepResultsIntoFile = false;
    public static boolean initialConfigToBeWritten = false;
    public static boolean minimalPipelineToBeBuild = false;

    public Dataset<Row> run(Dataset<Row> dataset, String dataLevel) {
        helper_datasets.clear();
        helper_datasets.put("initial_" + dataLevel, dataset);
        for (PipelineStep ps : this.pipelineSteps) {
            if (ps.getPreprocessingStep() == null) continue;
            dataset = ps.getPreprocessingStep().runPreprocessingStep(dataset, writeStepResultsIntoFile, dataLevel, ps.getStepParameters());
        }
        return dataset;
    }

    public void addPreprocessorStep(PipelineStep step) {
        this.pipelineSteps.add(step);
    }

    public static synchronized int getNextCounter() {
        return ++stepCounter;
    }

    public static synchronized int getCounter() {
        return stepCounter;
    }
}

