/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.runner;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import de.viadee.ki.sparkimporter.exceptions.FaultyConfigurationException;
import de.viadee.ki.sparkimporter.processing.PreprocessingRunner;
import de.viadee.ki.sparkimporter.processing.steps.PipelineStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.AddReducedColumnsToDatasetStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.AddVariablesColumnsStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.AggregateActivityInstancesStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.AggregateProcessInstancesStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.AggregateVariableUpdatesStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.CreateColumnsFromJsonStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.DetermineVariableTypesStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.FillActivityInstancesHistoryStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.ReduceColumnsDatasetStep;
import de.viadee.ki.sparkimporter.processing.steps.dataprocessing.VariablesTypeEscalationStep;
import de.viadee.ki.sparkimporter.processing.steps.output.WriteToDiscStep;
import de.viadee.ki.sparkimporter.processing.steps.userconfig.ColumnHashStep;
import de.viadee.ki.sparkimporter.processing.steps.userconfig.ColumnRemoveStep;
import de.viadee.ki.sparkimporter.processing.steps.userconfig.DataFilterStep;
import de.viadee.ki.sparkimporter.processing.steps.userconfig.JsonVariableFilterStep;
import de.viadee.ki.sparkimporter.processing.steps.userconfig.TypeCastStep;
import de.viadee.ki.sparkimporter.processing.steps.userconfig.VariableFilterStep;
import de.viadee.ki.sparkimporter.processing.steps.userconfig.VariableNameMappingStep;
import de.viadee.ki.sparkimporter.runner.SparkRunner;
import de.viadee.ki.sparkimporter.util.SparkImporterKafkaDataProcessingArguments;
import de.viadee.ki.sparkimporter.util.SparkImporterLogger;
import de.viadee.ki.sparkimporter.util.SparkImporterVariables;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProcessingRunner
extends SparkRunner {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProcessingRunner.class);
    public static SparkImporterKafkaDataProcessingArguments ARGS;

    @Override
    protected void initialize(String[] arguments) {
        ARGS = SparkImporterKafkaDataProcessingArguments.getInstance();
        JCommander jCommander = JCommander.newBuilder().addObject(SparkImporterKafkaDataProcessingArguments.getInstance()).build();
        try {
            jCommander.parse(arguments);
        }
        catch (ParameterException e) {
            LOG.error("Parsing of parameters failed. Error message: " + e.getMessage());
            jCommander.usage();
            System.exit(1);
        }
        SparkImporterVariables.setTargetFolder(ARGS.getFileDestination());
        SparkImporterVariables.setDevTypeCastCheckEnabled(ARGS.isDevTypeCastCheckEnabled());
        SparkImporterVariables.setDevProcessStateColumnWorkaroundEnabled(ARGS.isDevProcessStateColumnWorkaroundEnabled());
        SparkImporterVariables.setRevCountEnabled(ARGS.isRevisionCount());
        SparkImporterVariables.setSaveMode(ARGS.getSaveMode() == "append" ? SaveMode.Append : SaveMode.Overwrite);
        SparkImporterVariables.setOutputFormat(ARGS.getOutputFormat());
        SparkImporterVariables.setWorkingDirectory(ARGS.getWorkingDirectory());
        SparkImporterLogger.setLogDirectory(ARGS.getLogDirectory());
        SparkImporterVariables.setProcessFilterDefinitionId(ARGS.getProcessDefinitionFilterId());
        this.dataLevel = ARGS.getDataLevel();
        if (SparkImporterVariables.isDevProcessStateColumnWorkaroundEnabled() && this.dataLevel.equals("activity")) {
            try {
                throw new FaultyConfigurationException("Process state workaround option cannot be used with activity data level.");
            }
            catch (FaultyConfigurationException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        PreprocessingRunner.writeStepResultsIntoFile = ARGS.isWriteStepResultsToCSV();
        FileUtils.deleteQuietly((File)new File(ARGS.getFileDestination()));
        SparkImporterLogger.getInstance().writeInfo("Starting data processing with data from: " + ARGS.getFileSource());
    }

    @Override
    protected List<PipelineStep> buildDefaultPipeline() {
        ArrayList<PipelineStep> pipelineSteps = new ArrayList<PipelineStep>();
        pipelineSteps.add(new PipelineStep(new DataFilterStep(), ""));
        pipelineSteps.add(new PipelineStep(new ColumnRemoveStep(), "DataFilterStep"));
        pipelineSteps.add(new PipelineStep(new ReduceColumnsDatasetStep(), "ColumnRemoveStep"));
        pipelineSteps.add(new PipelineStep(new VariableFilterStep(), "ReduceColumnsDatasetStep"));
        pipelineSteps.add(new PipelineStep(new VariableNameMappingStep(), "VariableFilterStep"));
        pipelineSteps.add(new PipelineStep(new DetermineVariableTypesStep(), "VariableNameMappingStep"));
        pipelineSteps.add(new PipelineStep(new VariablesTypeEscalationStep(), "DetermineVariableTypesStep"));
        pipelineSteps.add(new PipelineStep(new AggregateVariableUpdatesStep(), "VariablesTypeEscalationStep"));
        pipelineSteps.add(new PipelineStep(new AddVariablesColumnsStep(), "AggregateVariableUpdatesStep"));
        if (this.dataLevel.equals("process")) {
            pipelineSteps.add(new PipelineStep(new AggregateProcessInstancesStep(), "AddVariablesColumnsStep"));
        } else {
            pipelineSteps.add(new PipelineStep(new AggregateActivityInstancesStep(), "AddVariablesColumnsStep"));
        }
        pipelineSteps.add(new PipelineStep(new CreateColumnsFromJsonStep(), this.dataLevel.equals("process") ? "AggregateProcessInstancesStep" : "AggregateActivityInstancesStep"));
        pipelineSteps.add(new PipelineStep(new JsonVariableFilterStep(), "CreateColumnsFromJsonStep"));
        if (this.dataLevel.equals("activity")) {
            pipelineSteps.add(new PipelineStep(new FillActivityInstancesHistoryStep(), "JsonVariableFilterStep"));
        }
        pipelineSteps.add(new PipelineStep(new AddReducedColumnsToDatasetStep(), this.dataLevel.equals("process") ? "JsonVariableFilterStep" : "FillActivityInstancesHistoryStep"));
        pipelineSteps.add(new PipelineStep(new ColumnHashStep(), "AddReducedColumnsToDatasetStep"));
        pipelineSteps.add(new PipelineStep(new TypeCastStep(), "ColumnHashStep"));
        pipelineSteps.add(new PipelineStep(new WriteToDiscStep(), "TypeCastStep"));
        return pipelineSteps;
    }

    @Override
    protected Dataset<Row> loadInitialDataset() {
        Dataset dataset = this.sparkSession.read().option("inferSchema", "true").load(ARGS.getFileSource());
        return dataset;
    }
}

