/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.processing.steps.userconfig;

import de.viadee.ki.sparkimporter.configuration.Configuration;
import de.viadee.ki.sparkimporter.configuration.preprocessing.PreprocessingConfiguration;
import de.viadee.ki.sparkimporter.configuration.preprocessing.VariableNameMapping;
import de.viadee.ki.sparkimporter.configuration.util.ConfigurationUtils;
import de.viadee.ki.sparkimporter.processing.interfaces.PreprocessingStepInterface;
import de.viadee.ki.sparkimporter.util.SparkImporterLogger;
import de.viadee.ki.sparkimporter.util.SparkImporterUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;

public class VariableNameMappingStep
implements PreprocessingStepInterface {
    @Override
    public Dataset<Row> runPreprocessingStep(Dataset<Row> dataset, boolean writeStepResultIntoFile, String dataLevel, Map<String, Object> parameters) {
        PreprocessingConfiguration preprocessingConfiguration;
        HashMap<String, String> variableNameMappings = new HashMap<String, String>();
        Configuration configuration = ConfigurationUtils.getInstance().getConfiguration();
        if (configuration != null && (preprocessingConfiguration = configuration.getPreprocessingConfiguration()) != null) {
            for (VariableNameMapping vm : preprocessingConfiguration.getVariableNameMappings()) {
                if (!vm.getOldName().equals("") && !vm.getNewName().equals("")) {
                    variableNameMappings.put(vm.getOldName(), vm.getNewName());
                    continue;
                }
                SparkImporterLogger.getInstance().writeWarn("Ignoring variable name mapping '" + vm.getOldName() + "' -> '" + vm.getNewName() + "'.");
            }
        }
        for (String oldName : variableNameMappings.keySet()) {
            String newName = (String)variableNameMappings.get(oldName);
            SparkImporterLogger.getInstance().writeInfo("Renaming variable '" + oldName + "' to '" + newName + "' as per user configuration.");
            dataset = dataset.withColumn("name_", functions.when((Column)dataset.col("name_").equalTo((Object)oldName), (Object)functions.lit((Object)newName)).otherwise((Object)dataset.col("name_")));
        }
        if (writeStepResultIntoFile) {
            SparkImporterUtils.getInstance().writeDatasetToCSV(dataset, "variable_name_mapping");
        }
        return dataset;
    }
}

