/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.processing.steps.dataprocessing;

import de.viadee.ki.sparkimporter.configuration.Configuration;
import de.viadee.ki.sparkimporter.configuration.preprocessing.VariableConfiguration;
import de.viadee.ki.sparkimporter.configuration.util.ConfigurationUtils;
import de.viadee.ki.sparkimporter.processing.PreprocessingRunner;
import de.viadee.ki.sparkimporter.processing.interfaces.PreprocessingStepInterface;
import de.viadee.ki.sparkimporter.util.SparkBroadcastHelper;
import de.viadee.ki.sparkimporter.util.SparkImporterLogger;
import de.viadee.ki.sparkimporter.util.SparkImporterUtils;
import java.util.ArrayList;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class VariablesTypeEscalationStep
implements PreprocessingStepInterface {
    @Override
    public Dataset<Row> runPreprocessingStep(Dataset<Row> dataset, boolean writeStepResultIntoFile, String dataLevel, Map<String, Object> parameters) {
        Map variables = (Map)SparkBroadcastHelper.getInstance().getBroadcastVariable(SparkBroadcastHelper.BROADCAST_VARIABLE.PROCESS_VARIABLES_RAW);
        Object lastVariableName = "";
        String lastVariableType = "";
        int lastVariableMaxRevision = 0;
        int variableOccurences = 0;
        for (Object variable : variables.keySet()) {
            String type = (String)variables.get(variable);
            int revision = 0;
            this.processVariable(variables, (String)variable, type, revision, (String)lastVariableName, lastVariableType, lastVariableMaxRevision, variableOccurences);
            if (((String)variable).equals(lastVariableName)) continue;
            lastVariableName = variable;
            lastVariableType = type;
            lastVariableMaxRevision = revision;
            variableOccurences = 1;
        }
        this.processVariable(variables, "", "", 0, (String)lastVariableName, lastVariableType, lastVariableMaxRevision, variableOccurences);
        SparkBroadcastHelper.getInstance().broadcastVariable(SparkBroadcastHelper.BROADCAST_VARIABLE.PROCESS_VARIABLES_ESCALATED, variables);
        ArrayList<Row> filteredVariablesRows = new ArrayList<Row>();
        for (Object key : variables.keySet()) {
            filteredVariablesRows.add(RowFactory.create((Object[])new Object[]{key, variables.get(key)}));
        }
        if (PreprocessingRunner.initialConfigToBeWritten) {
            Configuration configuration = ConfigurationUtils.getInstance().getConfiguration();
            for (String name : variables.keySet()) {
                String type = (String)variables.get(name);
                VariableConfiguration variableConfiguration = new VariableConfiguration();
                variableConfiguration.setVariableName(name);
                variableConfiguration.setVariableType(type);
                variableConfiguration.setUseVariable(true);
                variableConfiguration.setComment("");
                configuration.getPreprocessingConfiguration().getVariableConfiguration().add(variableConfiguration);
            }
        }
        StructType schema = new StructType(new StructField[]{new StructField("name_", DataTypes.StringType, false, Metadata.empty()), new StructField("var_type_", DataTypes.StringType, false, Metadata.empty())});
        SparkSession sparkSession = SparkSession.builder().getOrCreate();
        Dataset helpDataSet = sparkSession.createDataFrame(filteredVariablesRows, schema).toDF().orderBy("name_", new String[0]);
        SparkImporterLogger.getInstance().writeInfo("Found " + helpDataSet.count() + " process variables.");
        SparkImporterUtils.getInstance().writeDatasetToCSV((Dataset<Row>)helpDataSet, "variable_types_escalated");
        return dataset;
    }

    private void processVariable(Map<String, String> variables, String variableName, String variableType, int revision, String lastVariableName, String lastVariableType, int lastVariableMaxRevision, int variableOccurences) {
        if (variableName.equals(lastVariableName)) {
            ++variableOccurences;
            if (lastVariableType.equals("null") || lastVariableType.equals("")) {
                lastVariableType = variableType;
            } else if (!variableType.equals("null") && !variableType.equals("")) {
                lastVariableType = variableType;
            }
            lastVariableMaxRevision = Math.max(revision, lastVariableMaxRevision);
        } else if (variableOccurences == 1) {
            if (lastVariableType.equals("null") || lastVariableType.equals("")) {
                variables.put(lastVariableName, "string");
            } else {
                variables.put(lastVariableName, lastVariableType);
            }
        } else if (variableOccurences > 1) {
            variables.put(lastVariableName, lastVariableType);
        }
    }
}

