/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.processing.steps.dataprocessing;

import de.viadee.ki.sparkimporter.processing.interfaces.PreprocessingStepInterface;
import de.viadee.ki.sparkimporter.util.SparkBroadcastHelper;
import de.viadee.ki.sparkimporter.util.SparkImporterUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;

public class DetermineVariableTypesStep
implements PreprocessingStepInterface {
    @Override
    public Dataset<Row> runPreprocessingStep(Dataset<Row> dataset, boolean writeStepResultIntoFile, String dataLevel, Map<String, Object> parameters) {
        Dataset variablesTypesDataset = dataset.select("name_", new String[]{"var_type_", "rev_"}).groupBy("name_", new String[]{"var_type_"}).agg(functions.max((String)"rev_").alias("rev_"), new Column[0]).filter("name_ <> 'null'");
        HashMap<String, String> variablesAndTypes = new HashMap<String, String>();
        Iterator it = variablesTypesDataset.toLocalIterator();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            variablesAndTypes.put(row.getString(0), row.getString(1));
        }
        SparkBroadcastHelper.getInstance().broadcastVariable(SparkBroadcastHelper.BROADCAST_VARIABLE.PROCESS_VARIABLES_RAW, variablesAndTypes);
        if (writeStepResultIntoFile) {
            SparkImporterUtils.getInstance().writeDatasetToCSV((Dataset<Row>)variablesTypesDataset, "variables_types_help");
        }
        return dataset;
    }
}

