/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.processing.steps.dataprocessing;

import de.viadee.ki.sparkimporter.processing.interfaces.PreprocessingStepInterface;
import de.viadee.ki.sparkimporter.util.SparkBroadcastHelper;
import de.viadee.ki.sparkimporter.util.SparkImporterUtils;
import de.viadee.ki.sparkimporter.util.SparkImporterVariables;
import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;

public class AddVariablesColumnsStep
implements PreprocessingStepInterface {
    @Override
    public Dataset<Row> runPreprocessingStep(Dataset<Row> dataset, boolean writeStepResultIntoFile, String dataLevel, Map<String, Object> parameters) {
        Map varMap = (Map)SparkBroadcastHelper.getInstance().getBroadcastVariable(SparkBroadcastHelper.BROADCAST_VARIABLE.PROCESS_VARIABLES_ESCALATED);
        Set variables = varMap.keySet();
        for (String v : variables) {
            dataset = dataset.withColumn(v, functions.when((Column)dataset.col("name_").equalTo((Object)v), (Object)functions.when((Column)dataset.col("var_type_").equalTo((Object)"string"), (Object)dataset.col("text_")).when(dataset.col("var_type_").equalTo((Object)"null"), (Object)dataset.col("text_")).when(dataset.col("var_type_").equalTo((Object)"boolean"), (Object)dataset.col("long_")).when(dataset.col("var_type_").equalTo((Object)"integer"), (Object)dataset.col("long_")).when(dataset.col("var_type_").equalTo((Object)"long"), (Object)dataset.col("long_")).when(dataset.col("var_type_").equalTo((Object)"double"), (Object)dataset.col("double_")).when(dataset.col("var_type_").equalTo((Object)"date"), (Object)dataset.col("long_")).otherwise((Object)dataset.col("text2_"))).otherwise(null));
            if (!dataLevel.equals("process") || !SparkImporterVariables.isRevCountEnabled()) continue;
            dataset = dataset.withColumn(v + "_rev", functions.when((Column)dataset.col("name_").equalTo((Object)v), (Object)dataset.col("rev_")).otherwise((Object)"0"));
        }
        dataset = dataset.drop(new String[]{"var_type_", "rev_", "double_", "long_", "text_", "text2_"});
        if (!SparkImporterVariables.isDevProcessStateColumnWorkaroundEnabled()) {
            dataset = dataset.drop("name_");
        }
        if (writeStepResultIntoFile) {
            SparkImporterUtils.getInstance().writeDatasetToCSV((Dataset<Row>)dataset, "add_var_columns");
        }
        return dataset;
    }
}

