/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.processing.steps;

import de.viadee.ki.sparkimporter.exceptions.FaultyConfigurationException;
import de.viadee.ki.sparkimporter.processing.steps.PipelineStep;
import de.viadee.ki.sparkimporter.util.SparkImporterLogger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class PipelineManager {
    private List<PipelineStep> pipelineSteps;
    LinkedList<PipelineStep> orderedPipeline = new LinkedList();

    public PipelineManager(List<PipelineStep> pipelineSteps) throws FaultyConfigurationException {
        this.pipelineSteps = pipelineSteps;
        this.buildPipeline();
        SparkImporterLogger.getInstance().writeInfo("Resulting pipeline from configuration: " + this.orderedPipeline.toString());
    }

    public LinkedList<PipelineStep> getOrderedPipeline() {
        return this.orderedPipeline;
    }

    private void buildPipeline() throws FaultyConfigurationException {
        String message;
        HashMap<String, String> pipelineStepsIdCheck = new HashMap<String, String>();
        for (PipelineStep pipelineStep : this.pipelineSteps) {
            if (!pipelineStep.hasPredecessor()) {
                if (this.orderedPipeline.size() > 0) {
                    SparkImporterLogger.getInstance().writeError("More that one starting processing step found!");
                } else {
                    this.orderedPipeline.add(pipelineStep);
                }
            }
            pipelineStepsIdCheck.put(pipelineStep.getId(), pipelineStep.getClassName());
        }
        if (this.orderedPipeline.size() == 0) {
            message = "No starting processing step found!";
            SparkImporterLogger.getInstance().writeError(message);
            throw new FaultyConfigurationException(message);
        }
        if (this.pipelineSteps.size() != pipelineStepsIdCheck.size()) {
            message = "Duplicate step IDs found in step configuration!";
            SparkImporterLogger.getInstance().writeError(message);
            throw new FaultyConfigurationException(message);
        }
        while (this.orderedPipeline.size() != this.pipelineSteps.size()) {
            boolean elementFound = false;
            block2: for (PipelineStep ps : this.pipelineSteps) {
                if (this.orderedPipeline.contains(ps)) continue;
                int listIndex = 0;
                for (PipelineStep psgraph : this.orderedPipeline) {
                    if (ps.hasPredecessor() && ps.getDependsOn().equals(psgraph.getId())) {
                        this.orderedPipeline.add(listIndex + 1, ps);
                        elementFound = true;
                        continue block2;
                    }
                    ++listIndex;
                }
            }
            if (elementFound) continue;
            String string = "Could not add all steps to pipeline. Please check the step configuration! Pipeline before exception: " + this.orderedPipeline.toString();
            SparkImporterLogger.getInstance().writeError(string);
            throw new FaultyConfigurationException(string);
        }
    }
}

