/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.ki.sparkimporter.configuration.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.viadee.ki.sparkimporter.configuration.Configuration;
import de.viadee.ki.sparkimporter.configuration.dataextraction.DataExtractionConfiguration;
import de.viadee.ki.sparkimporter.configuration.modellearning.ModelLearningConfiguration;
import de.viadee.ki.sparkimporter.configuration.modelprediction.ModelPredictionConfiguration;
import de.viadee.ki.sparkimporter.configuration.preprocessing.PreprocessingConfiguration;
import de.viadee.ki.sparkimporter.util.SparkImporterLogger;
import de.viadee.ki.sparkimporter.util.SparkImporterVariables;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigurationUtils {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final String CONFIGURATION_FILE_NAME = "pipeline_configuration.json";
    private Configuration configuration = null;
    private static ConfigurationUtils instance;

    private ConfigurationUtils() {
    }

    public static synchronized ConfigurationUtils getInstance() {
        if (instance == null) {
            instance = new ConfigurationUtils();
        }
        return instance;
    }

    public String getConfigurationFileName() {
        return "pipeline_configuration.json";
    }

    public Configuration getConfiguration() {
        return this.getConfiguration(false);
    }

    public Configuration getConfiguration(boolean reload) {
        if (reload) {
            this.configuration = null;
        }
        if (this.configuration == null && new File(SparkImporterVariables.getWorkingDirectory() + "/" + "pipeline_configuration.json").exists()) {
            try (FileReader reader = new FileReader(SparkImporterVariables.getWorkingDirectory() + "/" + "pipeline_configuration.json");){
                this.configuration = (Configuration)this.gson.fromJson((Reader)reader, Configuration.class);
            }
            catch (IOException e) {
                SparkImporterLogger.getInstance().writeError("An error occurred while reading the configuration file: " + e.getMessage());
            }
        }
        return this.configuration;
    }

    public void createEmptyConfig() {
        SparkImporterLogger.getInstance().writeInfo("No config file found. Creating default config file for dataset.");
        PreprocessingConfiguration preprocessingConfiguration = new PreprocessingConfiguration();
        DataExtractionConfiguration dataExtractionConfiguration = new DataExtractionConfiguration();
        ModelLearningConfiguration modelLearningConfiguration = new ModelLearningConfiguration();
        ModelPredictionConfiguration modelPredictionConfiguration = new ModelPredictionConfiguration();
        this.configuration = new Configuration();
        this.configuration.setDataExtractionConfiguration(dataExtractionConfiguration);
        this.configuration.setPreprocessingConfiguration(preprocessingConfiguration);
        this.configuration.setModelLearningConfiguration(modelLearningConfiguration);
        this.configuration.setModelPredictionConfiguration(modelPredictionConfiguration);
        try (FileWriter writer = new FileWriter(SparkImporterVariables.getWorkingDirectory() + "/" + "pipeline_configuration.json");){
            this.gson.toJson((Object)this.configuration, (Appendable)writer);
        }
        catch (IOException e) {
            SparkImporterLogger.getInstance().writeError("An error occurred while writing the configuration file: " + e.getMessage());
        }
    }

    public void writeConfigurationToFile() {
        try (FileWriter writer = new FileWriter(SparkImporterVariables.getWorkingDirectory() + "/" + "pipeline_configuration.json");){
            this.gson.toJson((Object)this.configuration, (Appendable)writer);
        }
        catch (IOException e) {
            SparkImporterLogger.getInstance().writeError("An error occurred while writing the configuration file: " + e.getMessage());
        }
    }
}

