/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.camunda.extension;

import de.viadee.camunda.extension.ExternalTaskSubscription;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.StartupEvent;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.camunda.bpm.client.ExternalTaskClient;
import org.camunda.bpm.client.task.ExternalTaskHandler;

@ApplicationScoped
public class HandlerSubscriber {
    @Inject
    ExternalTaskClient externalTaskClient;

    public void registerHandlers(@Observes StartupEvent ev) {
        Arc.container().select(ExternalTaskHandler.class, new Annotation[0]).handles().forEach(instanceHandle -> {
            Optional<Annotation> annotation = Arrays.stream(instanceHandle.getBean().getBeanClass().getAnnotations()).filter(a -> a instanceof ExternalTaskSubscription).findFirst();
            if (annotation.isEmpty()) {
                return;
            }
            ExternalTaskSubscription castAnnotation = (ExternalTaskSubscription)annotation.get();
            this.registerHandler((ExternalTaskHandler)instanceHandle.get(), castAnnotation);
        });
    }

    private void registerHandler(ExternalTaskHandler externalTaskHandler, ExternalTaskSubscription subscription) {
        this.externalTaskClient.subscribe(subscription.topicName()).variables(subscription.variableNames()).localVariables(subscription.localVariables()).businessKey(subscription.businessKey()).processDefinitionId(subscription.processDefinitionId()).processDefinitionIdIn(subscription.processDefinitionIdIn()).processDefinitionKey(subscription.processDefinitionKey()).processDefinitionKeyIn(subscription.processDefinitionKeyIn()).processDefinitionVersionTag(subscription.processDefinitionVersionTag()).tenantIdIn(subscription.tenantIdIn()).includeExtensionProperties(subscription.includeExtensionProperties()).handler(externalTaskHandler).open();
    }
}

