/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.util.helper;

import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;

public class SparkBroadcastHelper {
    private static SparkBroadcastHelper instance;
    private static final Map<BROADCAST_VARIABLE, Broadcast<Object>> BROADCAST_VARIABLES;

    private SparkBroadcastHelper() {
    }

    public static synchronized SparkBroadcastHelper getInstance() {
        if (instance == null) {
            instance = new SparkBroadcastHelper();
        }
        return instance;
    }

    public <T> void broadcastVariable(BROADCAST_VARIABLE name, T varToBroadcast) {
        JavaSparkContext jsc = JavaSparkContext.fromSparkContext((SparkContext)SparkSession.builder().getOrCreate().sparkContext());
        Broadcast broadcastedVar = jsc.broadcast(varToBroadcast);
        BROADCAST_VARIABLES.put(name, (Broadcast<Object>)broadcastedVar);
    }

    public Object getBroadcastVariable(BROADCAST_VARIABLE name) {
        if (BROADCAST_VARIABLES.get((Object)name) != null) {
            return BROADCAST_VARIABLES.get((Object)name).value();
        }
        return null;
    }

    static {
        BROADCAST_VARIABLES = new HashMap<BROADCAST_VARIABLE, Broadcast<Object>>();
    }

    public static enum BROADCAST_VARIABLE {
        PROCESS_VARIABLES_RAW,
        PROCESS_VARIABLES_ESCALATED,
        PROCESS_INSTANCE_TIMESTAMP_MAP;

    }
}

