/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.runner.impl;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import de.viadee.bpmnai.core.exceptions.FaultyConfigurationException;
import de.viadee.bpmnai.core.processing.steps.PipelineStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.AddReducedColumnsToDatasetStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.AddVariableColumnsStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.AggregateProcessInstancesStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.ColumnHashStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.ColumnRemoveStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.CreateColumnsFromJsonStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.DataFilterStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.DetermineProcessVariablesStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.ReduceColumnsStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.TypeCastStep;
import de.viadee.bpmnai.core.processing.steps.importing.InitialCleanupStep;
import de.viadee.bpmnai.core.processing.steps.output.WriteToDiscStep;
import de.viadee.bpmnai.core.runner.SparkRunner;
import de.viadee.bpmnai.core.runner.config.SparkRunnerConfig;
import de.viadee.bpmnai.core.util.BpmnaiUtils;
import de.viadee.bpmnai.core.util.arguments.CSVImportAndProcessingArguments;
import de.viadee.bpmnai.core.util.logging.BpmnaiLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVImportAndProcessingRunner
extends SparkRunner {
    private static final Logger LOG = LoggerFactory.getLogger(CSVImportAndProcessingRunner.class);

    public CSVImportAndProcessingRunner() {
    }

    public CSVImportAndProcessingRunner(SparkRunnerConfig config) {
        super(config);
    }

    @Override
    protected void initialize(String[] arguments) {
        CSVImportAndProcessingArguments csvImportAndProcessingArguments = CSVImportAndProcessingArguments.getInstance();
        JCommander jCommander = JCommander.newBuilder().addObject((Object)CSVImportAndProcessingArguments.getInstance()).build();
        try {
            jCommander.parse(arguments);
        }
        catch (ParameterException e) {
            LOG.error("Parsing of parameters failed. Error message: " + e.getMessage());
            jCommander.usage();
            System.exit(1);
        }
        csvImportAndProcessingArguments.createOrUpdateSparkRunnerConfig(this.sparkRunnerConfig);
        if (this.sparkRunnerConfig.isDevProcessStateColumnWorkaroundEnabled() && this.sparkRunnerConfig.getDataLevel().equals("activity")) {
            try {
                throw new FaultyConfigurationException("Process state workaround option cannot be used with activity data level.");
            }
            catch (FaultyConfigurationException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        if (this.sparkRunnerConfig.getSaveMode().equals((Object)SaveMode.Overwrite)) {
            FileUtils.deleteQuietly((File)new File(this.sparkRunnerConfig.getTargetFolder()));
        }
        BpmnaiLogger.getInstance().writeInfo("Starting CSV import and processing");
        BpmnaiLogger.getInstance().writeInfo("Importing CSV file: " + this.sparkRunnerConfig.getSourceFolder());
    }

    @Override
    protected List<PipelineStep> buildDefaultPipeline() {
        ArrayList<PipelineStep> pipelineSteps = new ArrayList<PipelineStep>();
        pipelineSteps.add(new PipelineStep(new DataFilterStep(), ""));
        pipelineSteps.add(new PipelineStep(new ColumnRemoveStep(), "DataFilterStep"));
        pipelineSteps.add(new PipelineStep(new ReduceColumnsStep(), "ColumnRemoveStep"));
        pipelineSteps.add(new PipelineStep(new DetermineProcessVariablesStep(), "ReduceColumnsStep"));
        pipelineSteps.add(new PipelineStep(new AddVariableColumnsStep(), "DetermineProcessVariablesStep"));
        pipelineSteps.add(new PipelineStep(new AggregateProcessInstancesStep(), "AddVariableColumnsStep"));
        pipelineSteps.add(new PipelineStep(new CreateColumnsFromJsonStep(), "AggregateProcessInstancesStep"));
        pipelineSteps.add(new PipelineStep(new AddReducedColumnsToDatasetStep(), "CreateColumnsFromJsonStep"));
        pipelineSteps.add(new PipelineStep(new ColumnHashStep(), "AddReducedColumnsToDatasetStep"));
        pipelineSteps.add(new PipelineStep(new TypeCastStep(), "ColumnHashStep"));
        pipelineSteps.add(new PipelineStep(new WriteToDiscStep(), "TypeCastStep"));
        return pipelineSteps;
    }

    @Override
    protected Dataset<Row> loadInitialDataset() {
        Dataset dataset = this.sparkSession.read().option("inferSchema", "true").option("delimiter", this.sparkRunnerConfig.getDelimiter()).option("header", "true").option("ignoreLeadingWhiteSpace", "false").option("ignoreTrailingWhiteSpace", "false").csv(this.sparkRunnerConfig.getSourceFolder());
        if (this.sparkRunnerConfig.isWriteStepResultsIntoFile()) {
            BpmnaiUtils.getInstance().writeDatasetToCSV((Dataset<Row>)dataset, "import_result", this.sparkRunnerConfig);
        }
        InitialCleanupStep initialCleanupStep = new InitialCleanupStep();
        dataset = initialCleanupStep.runPreprocessingStep((Dataset<Row>)dataset, null, this.sparkRunnerConfig);
        dataset = dataset.withColumn("source_", functions.lit((Object)"variableUpdate"));
        return dataset;
    }
}

