/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.runner;

import de.viadee.bpmnai.core.configuration.Configuration;
import de.viadee.bpmnai.core.configuration.modelprediction.ModelPredictionConfiguration;
import de.viadee.bpmnai.core.configuration.preprocessing.PipelineStepConfiguration;
import de.viadee.bpmnai.core.configuration.preprocessing.Step;
import de.viadee.bpmnai.core.configuration.util.ConfigurationUtils;
import de.viadee.bpmnai.core.exceptions.FaultyConfigurationException;
import de.viadee.bpmnai.core.processing.PreprocessingRunner;
import de.viadee.bpmnai.core.processing.aggregation.AllButEmptyStringAggregationFunction;
import de.viadee.bpmnai.core.processing.aggregation.ProcessStatesAggregationFunction;
import de.viadee.bpmnai.core.processing.steps.PipelineManager;
import de.viadee.bpmnai.core.processing.steps.PipelineStep;
import de.viadee.bpmnai.core.runner.config.SparkRunnerConfig;
import de.viadee.bpmnai.core.util.BpmnaiUtils;
import de.viadee.bpmnai.core.util.logging.BpmnaiLogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.expressions.UserDefinedAggregateFunction;
import org.apache.spark.sql.types.DataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.primitives.Longs;

public abstract class SparkPredictionServiceRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SparkPredictionServiceRunner.class);
    private PipelineManager pipelineManager = null;
    protected SparkSession sparkSession = null;
    protected SparkRunnerConfig sparkRunnerConfig;
    private List<PipelineStep> pipelineSteps = new ArrayList<PipelineStep>();

    protected abstract void initialize();

    protected abstract List<PipelineStep> buildDefaultPipeline();

    private void checkConfig() {
        if (ConfigurationUtils.getInstance().getConfiguration(true, this.sparkRunnerConfig) == null) {
            this.sparkRunnerConfig.setInitialConfigToBeWritten(true);
            ConfigurationUtils.getInstance().createEmptyConfig(this.sparkRunnerConfig);
        } else {
            BpmnaiLogger.getInstance().writeInfo("Configuration file found: " + this.sparkRunnerConfig.getWorkingDirectory() + "/" + ConfigurationUtils.getInstance().getConfigurationFileName(this.sparkRunnerConfig));
        }
    }

    private void writeConfig() {
        if (this.sparkRunnerConfig.isInitialConfigToBeWritten()) {
            ConfigurationUtils.getInstance().writeConfigurationToFile(this.sparkRunnerConfig);
        }
    }

    protected void registerUDFs() {
        this.sparkSession.udf().register("AllButEmptyString", (UserDefinedAggregateFunction)new AllButEmptyStringAggregationFunction());
        this.sparkSession.udf().register("ProcessState", (UserDefinedAggregateFunction)new ProcessStatesAggregationFunction());
        this.sparkSession.udf().register("isALong", (UDF1)new UDF1<Object, Boolean>(){

            public Boolean call(Object o) throws Exception {
                if (o instanceof Long) {
                    return true;
                }
                if (o instanceof String && Longs.tryParse((String)((String)o)) != null) {
                    return true;
                }
                return false;
            }
        }, DataTypes.BooleanType);
        this.sparkSession.udf().register("timestampStringToLong", (UDF1)new UDF1<Object, Long>(){

            public Long call(Object o) throws Exception {
                if (o instanceof String && Longs.tryParse((String)((String)o)) != null) {
                    return Longs.tryParse((String)((String)o)) / 1000L;
                }
                return null;
            }
        }, DataTypes.LongType);
    }

    public void setup(SparkRunnerConfig sparkRunnerConfig) throws FaultyConfigurationException {
        this.sparkRunnerConfig = sparkRunnerConfig;
        this.sparkSession = SparkSession.builder().getOrCreate();
        this.initialize();
        this.registerUDFs();
        this.checkConfig();
        this.configurePipelineSteps();
    }

    public Dataset<Row> run(Dataset dataset) {
        Configuration configuration = ConfigurationUtils.getInstance().getConfiguration(this.sparkRunnerConfig);
        List<String> predictionVars = configuration.getModelPredictionConfiguration().getPredictionVariables();
        ArrayList<Column> usedColumns = new ArrayList<Column>();
        for (String string : predictionVars) {
            usedColumns.add(new Column(string));
        }
        dataset = dataset.select(BpmnaiUtils.getInstance().asSeq(usedColumns));
        PreprocessingRunner preprocessingRunner = new PreprocessingRunner();
        for (PipelineStep ps : this.pipelineManager.getOrderedPipeline()) {
            preprocessingRunner.addPreprocessorStep(ps);
        }
        Dataset<Row> dataset2 = preprocessingRunner.run((Dataset<Row>)dataset, this.sparkRunnerConfig);
        this.writeConfig();
        return dataset2;
    }

    public void configurePipelineSteps() throws FaultyConfigurationException {
        PipelineStepConfiguration pipelineStepConfiguration;
        ModelPredictionConfiguration modelPredictionConfiguration;
        List<Step> steps = null;
        Configuration configuration = ConfigurationUtils.getInstance().getConfiguration(this.sparkRunnerConfig);
        if (this.sparkRunnerConfig.isInitialConfigToBeWritten()) {
            this.pipelineSteps = this.buildDefaultPipeline();
            ModelPredictionConfiguration modelPredictionConfiguration2 = configuration.getModelPredictionConfiguration();
            PipelineStepConfiguration pipelineStepConfiguration2 = modelPredictionConfiguration2.getPipelineStepConfiguration();
            ArrayList<Step> configSteps = new ArrayList<Step>();
            for (PipelineStep ps : this.pipelineSteps) {
                Step s = new Step();
                s.setClassName(ps.getClassName());
                s.setDependsOn(ps.getDependsOn());
                s.setId(ps.getId());
                s.setParameters(ps.getStepParameters());
                s.setComment("");
                s.setActive(true);
                configSteps.add(s);
            }
            pipelineStepConfiguration2.setSteps(configSteps);
        } else if (configuration != null && (modelPredictionConfiguration = configuration.getModelPredictionConfiguration()) != null && (pipelineStepConfiguration = modelPredictionConfiguration.getPipelineStepConfiguration()) != null && (steps = pipelineStepConfiguration.getSteps()) != null) {
            for (Step cs : steps) {
                this.pipelineSteps.add(new PipelineStep(cs));
            }
        }
        this.pipelineManager = new PipelineManager(this.pipelineSteps);
    }
}

