/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.processing.steps;

import de.viadee.bpmnai.core.annotation.PreprocessingStepDescription;
import de.viadee.bpmnai.core.annotation.PreprocessingStepParameter;
import de.viadee.bpmnai.core.annotation.PreprocessingStepParameters;
import de.viadee.bpmnai.core.processing.steps.ParameterDefinition;
import de.viadee.bpmnai.core.processing.steps.PipelineStepDefinition;
import io.github.classgraph.AnnotationEnumValue;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.List;

public class PipelineStepCollector {
    public static List<PipelineStepDefinition> collectAllAvailablePipelineSteps() {
        ArrayList<PipelineStepDefinition> pipelineSteps = new ArrayList<PipelineStepDefinition>();
        String pkg = "de.viadee";
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableAnnotationInfo().whitelistPackages(new String[]{pkg}).scan();){
            for (ClassInfo routeClassInfo : scanResult.getClassesWithAnnotation(PreprocessingStepDescription.class.getCanonicalName())) {
                AnnotationInfo annotationInfo = routeClassInfo.getAnnotationInfo(PreprocessingStepDescription.class.getCanonicalName());
                AnnotationParameterValueList paramVals = annotationInfo.getParameterValues();
                PipelineStepDefinition step = new PipelineStepDefinition();
                step.setId(routeClassInfo.getSimpleName());
                step.setClassName(routeClassInfo.getPackageName() + "." + routeClassInfo.getSimpleName());
                for (AnnotationParameterValue parameterValue : paramVals) {
                    if (parameterValue.getName().equals("name")) {
                        step.setName((String)parameterValue.getValue());
                        continue;
                    }
                    if (!parameterValue.getName().equals("description")) continue;
                    step.setDescription((String)parameterValue.getValue());
                }
                annotationInfo = routeClassInfo.getAnnotationInfo(PreprocessingStepParameter.class.getCanonicalName());
                if (annotationInfo != null) {
                    paramVals = annotationInfo.getParameterValues();
                    ArrayList<ParameterDefinition> stepParameters = new ArrayList<ParameterDefinition>();
                    ParameterDefinition stepParam = new ParameterDefinition();
                    for (AnnotationParameterValue parameterValue : paramVals) {
                        if (parameterValue.getName().equals("name")) {
                            stepParam.setName((String)parameterValue.getValue());
                            continue;
                        }
                        if (parameterValue.getName().equals("description")) {
                            stepParam.setDescription((String)parameterValue.getValue());
                            continue;
                        }
                        if (parameterValue.getName().equals("required")) {
                            stepParam.setRequired((Boolean)parameterValue.getValue());
                            continue;
                        }
                        if (!parameterValue.getName().equals("dataType")) continue;
                        stepParam.setDataType((PreprocessingStepParameter.DATA_TYPE)((Object)((AnnotationEnumValue)parameterValue.getValue()).loadClassAndReturnEnumValue()));
                    }
                    stepParameters.add(stepParam);
                    step.setParameters(stepParameters);
                }
                if ((annotationInfo = routeClassInfo.getAnnotationInfo(PreprocessingStepParameters.class.getCanonicalName())) != null) {
                    paramVals = annotationInfo.getParameterValues();
                    for (AnnotationParameterValue parameterValue : paramVals) {
                        Object[] params;
                        ArrayList<ParameterDefinition> stepParameters = new ArrayList<ParameterDefinition>();
                        for (Object p : params = (Object[])parameterValue.getValue()) {
                            AnnotationInfo annoInfo = (AnnotationInfo)p;
                            ParameterDefinition stepParam = new ParameterDefinition();
                            if (annoInfo != null) {
                                paramVals = annoInfo.getParameterValues();
                                for (AnnotationParameterValue pv : paramVals) {
                                    if (pv.getName().equals("name")) {
                                        stepParam.setName((String)pv.getValue());
                                        continue;
                                    }
                                    if (pv.getName().equals("description")) {
                                        stepParam.setDescription((String)pv.getValue());
                                        continue;
                                    }
                                    if (pv.getName().equals("required")) {
                                        stepParam.setRequired((Boolean)pv.getValue());
                                        continue;
                                    }
                                    if (!pv.getName().equals("dataType")) continue;
                                    stepParam.setDataType((PreprocessingStepParameter.DATA_TYPE)((Object)((AnnotationEnumValue)pv.getValue()).loadClassAndReturnEnumValue()));
                                }
                            }
                            stepParameters.add(stepParam);
                        }
                        step.setParameters(stepParameters);
                    }
                }
                pipelineSteps.add(step);
            }
        }
        return pipelineSteps;
    }
}

