/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.processing.steps;

import de.viadee.bpmnai.core.configuration.preprocessing.Step;
import de.viadee.bpmnai.core.processing.interfaces.PreprocessingStepInterface;
import de.viadee.bpmnai.core.util.logging.BpmnaiLogger;
import java.util.Map;
import java.util.Objects;

public class PipelineStep {
    private PreprocessingStepInterface preprocessingStep;
    private String id;
    private String className;
    private String dependsOn;
    private Map<String, Object> stepParameters;

    public PipelineStep(Step cs) {
        Class<?> step = null;
        try {
            step = Class.forName(cs.getClassName());
        }
        catch (ClassNotFoundException e) {
            BpmnaiLogger.getInstance().writeError("Could not find the class '" + cs.getClassName() + "' for custom step '" + cs.getId() + "' " + e.getMessage());
        }
        if (step != null) {
            try {
                this.preprocessingStep = (PreprocessingStepInterface)step.newInstance();
            }
            catch (InstantiationException e) {
                BpmnaiLogger.getInstance().writeError("Could not find instantiate class '" + cs.getClassName() + "' for custom step '" + cs.getId() + "' " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                BpmnaiLogger.getInstance().writeError("Could not find instantiate class '" + cs.getClassName() + "' for custom step '" + cs.getId() + "'. " + e.getMessage());
            }
        }
        this.id = cs.getId();
        this.className = cs.getClassName();
        this.dependsOn = cs.getDependsOn();
        this.stepParameters = cs.getParameters();
    }

    public PipelineStep(PreprocessingStepInterface s, String dependsOn) {
        this.preprocessingStep = s;
        this.id = s.getClass().getSimpleName();
        this.className = s.getClass().getCanonicalName();
        this.dependsOn = dependsOn;
        this.stepParameters = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public boolean hasPredecessor() {
        return this.dependsOn != null && !this.dependsOn.equals("");
    }

    public PreprocessingStepInterface getPreprocessingStep() {
        return this.preprocessingStep;
    }

    public Map<String, Object> getStepParameters() {
        return this.stepParameters;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineStep that = (PipelineStep)o;
        return Objects.equals(this.getClassName(), that.getClassName()) && Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getClassName(), this.getId());
    }
}

