/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.processing;

import de.viadee.bpmnai.core.processing.steps.PipelineStep;
import de.viadee.bpmnai.core.runner.config.SparkRunnerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class PreprocessingRunner {
    private final List<PipelineStep> pipelineSteps = new ArrayList<PipelineStep>();
    public static final String DATASET_INITIAL = "initial";
    public static final Map<String, Dataset<Row>> helper_datasets = new HashMap<String, Dataset<Row>>();

    public Dataset<Row> run(Dataset<Row> dataset, SparkRunnerConfig config) {
        helper_datasets.clear();
        helper_datasets.put("initial_" + config.getDataLevel(), dataset);
        for (PipelineStep ps : this.pipelineSteps) {
            if (ps.getPreprocessingStep() == null) continue;
            dataset = ps.getPreprocessingStep().runPreprocessingStep(dataset, ps.getStepParameters(), config);
        }
        return dataset;
    }

    public void addPreprocessorStep(PipelineStep step) {
        this.pipelineSteps.add(step);
    }
}

