/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.configuration.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.viadee.bpmnai.core.configuration.Configuration;
import de.viadee.bpmnai.core.configuration.dataextraction.DataExtractionConfiguration;
import de.viadee.bpmnai.core.configuration.modellearning.ModelLearningConfiguration;
import de.viadee.bpmnai.core.configuration.modelprediction.ModelPredictionConfiguration;
import de.viadee.bpmnai.core.configuration.preprocessing.PreprocessingConfiguration;
import de.viadee.bpmnai.core.runner.SparkRunner;
import de.viadee.bpmnai.core.runner.config.SparkRunnerConfig;
import de.viadee.bpmnai.core.util.logging.BpmnaiLogger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigurationUtils {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final String CONFIGURATION_FILE_NAME = "pipeline_configuration";
    private Configuration configuration = null;
    private static ConfigurationUtils instance;

    private ConfigurationUtils() {
    }

    public static synchronized ConfigurationUtils getInstance() {
        if (instance == null) {
            instance = new ConfigurationUtils();
        }
        return instance;
    }

    public String getConfigurationFileName(SparkRunnerConfig config) {
        return "pipeline_configuration_" + config.getRunningMode().getModeString() + ".json";
    }

    public String getConfigurationFilePath(SparkRunnerConfig config) {
        return config.getWorkingDirectory() + "/" + this.getConfigurationFileName(config);
    }

    public Configuration getConfiguration(SparkRunnerConfig config) {
        return this.getConfiguration(false, config);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration(boolean reload, SparkRunnerConfig config) {
        if (reload) {
            this.configuration = null;
        }
        if (this.configuration == null && new File(this.getConfigurationFilePath(config)).exists()) {
            try (FileReader reader = new FileReader(this.getConfigurationFilePath(config));){
                this.configuration = (Configuration)this.gson.fromJson((Reader)reader, Configuration.class);
            }
            catch (IOException e) {
                BpmnaiLogger.getInstance().writeError("An error occurred while reading the configuration file: " + e.getMessage());
            }
        }
        return this.configuration;
    }

    public void createEmptyConfig(SparkRunnerConfig config) {
        String pipelineType = "default";
        if (!config.getRunningMode().equals((Object)SparkRunner.RUNNING_MODE.KAFKA_IMPORT)) {
            pipelineType = "minimal";
        }
        BpmnaiLogger.getInstance().writeInfo("No config file found. Creating " + pipelineType + " config file for dataset at " + config.getWorkingDirectory() + "/" + this.getConfigurationFileName(config));
        PreprocessingConfiguration preprocessingConfiguration = new PreprocessingConfiguration();
        DataExtractionConfiguration dataExtractionConfiguration = new DataExtractionConfiguration();
        ModelLearningConfiguration modelLearningConfiguration = new ModelLearningConfiguration();
        ModelPredictionConfiguration modelPredictionConfiguration = new ModelPredictionConfiguration();
        this.configuration = new Configuration();
        this.configuration.setDataExtractionConfiguration(dataExtractionConfiguration);
        this.configuration.setPreprocessingConfiguration(preprocessingConfiguration);
        this.configuration.setModelLearningConfiguration(modelLearningConfiguration);
        this.configuration.setModelPredictionConfiguration(modelPredictionConfiguration);
        try (FileWriter writer = new FileWriter(config.getWorkingDirectory() + "/" + this.getConfigurationFileName(config));){
            this.gson.toJson((Object)this.configuration, (Appendable)writer);
        }
        catch (IOException e) {
            BpmnaiLogger.getInstance().writeError("An error occurred while writing the configuration file: " + e.getMessage());
        }
    }

    public void writeConfigurationToFile(SparkRunnerConfig config) {
        try (FileWriter writer = new FileWriter(config.getWorkingDirectory() + "/" + this.getConfigurationFileName(config));){
            this.gson.toJson((Object)this.configuration, (Appendable)writer);
        }
        catch (IOException e) {
            BpmnaiLogger.getInstance().writeError("An error occurred while writing the configuration file: " + e.getMessage());
        }
    }

    public void validateConfigurationFileVsSparkRunnerConfig(SparkRunnerConfig config) {
        if (this.configuration.getPreprocessingConfiguration().getDataLevel().equals("")) {
            BpmnaiLogger.getInstance().writeInfo("No data level set in configuration file. Setting it to run parameter (" + config.getDataLevel() + ")");
            this.configuration.getPreprocessingConfiguration().setDataLevel(config.getDataLevel());
            this.writeConfigurationToFile(config);
            return;
        }
        if (!config.getDataLevel().equals(this.configuration.getPreprocessingConfiguration().getDataLevel())) {
            String message = "The data level from the run parameters (" + config.getDataLevel() + ") does not match the one from the existing configuration file (" + this.configuration.getPreprocessingConfiguration().getDataLevel() + ")! Exiting...";
            BpmnaiLogger.getInstance().writeError(message);
            throw new RuntimeException(message);
        }
    }
}

