/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.runner.impl;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import de.viadee.bpmnai.core.processing.steps.PipelineStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.AddReducedColumnsToDatasetStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.AddVariableColumnsStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.AggregateActivityInstancesStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.AggregateProcessInstancesStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.ColumnHashStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.ColumnRemoveStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.CreateColumnsFromJsonStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.DataFilterStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.DetermineProcessVariablesStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.FillActivityInstancesHistoryStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.ReduceColumnsStep;
import de.viadee.bpmnai.core.processing.steps.dataprocessing.TypeCastStep;
import de.viadee.bpmnai.core.processing.steps.output.WriteToDiscStep;
import de.viadee.bpmnai.core.runner.SparkRunner;
import de.viadee.bpmnai.core.runner.config.SparkRunnerConfig;
import de.viadee.bpmnai.core.util.BpmnaiUtils;
import de.viadee.bpmnai.core.util.arguments.KafkaProcessingArguments;
import de.viadee.bpmnai.core.util.logging.BpmnaiLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProcessingRunner
extends SparkRunner {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProcessingRunner.class);

    public KafkaProcessingRunner() {
    }

    public KafkaProcessingRunner(SparkRunnerConfig config) {
        super(config);
    }

    @Override
    protected void initialize(String[] arguments) {
        KafkaProcessingArguments kafkaProcessingArguments = KafkaProcessingArguments.getInstance();
        JCommander jCommander = JCommander.newBuilder().addObject((Object)KafkaProcessingArguments.getInstance()).build();
        try {
            jCommander.parse(arguments);
        }
        catch (ParameterException e) {
            LOG.error("Parsing of parameters failed. Error message: " + e.getMessage());
            jCommander.usage();
            System.exit(1);
        }
        kafkaProcessingArguments.createOrUpdateSparkRunnerConfig(this.sparkRunnerConfig);
        FileUtils.deleteQuietly((File)new File(this.sparkRunnerConfig.getTargetFolder()));
        BpmnaiLogger.getInstance().writeInfo("Starting data processing with data from: " + this.sparkRunnerConfig.getSourceFolder());
    }

    @Override
    protected List<PipelineStep> buildDefaultPipeline() {
        ArrayList<PipelineStep> pipelineSteps = new ArrayList<PipelineStep>();
        pipelineSteps.add(new PipelineStep(new DataFilterStep(), ""));
        pipelineSteps.add(new PipelineStep(new ColumnRemoveStep(), "DataFilterStep"));
        pipelineSteps.add(new PipelineStep(new ReduceColumnsStep(), "ColumnRemoveStep"));
        pipelineSteps.add(new PipelineStep(new DetermineProcessVariablesStep(), "ReduceColumnsStep"));
        pipelineSteps.add(new PipelineStep(new AddVariableColumnsStep(), "DetermineProcessVariablesStep"));
        if (this.sparkRunnerConfig.getDataLevel().equals("process")) {
            pipelineSteps.add(new PipelineStep(new AggregateProcessInstancesStep(), "AddVariableColumnsStep"));
        } else {
            pipelineSteps.add(new PipelineStep(new AggregateActivityInstancesStep(), "AddVariableColumnsStep"));
        }
        pipelineSteps.add(new PipelineStep(new CreateColumnsFromJsonStep(), this.sparkRunnerConfig.getDataLevel().equals("process") ? "AggregateProcessInstancesStep" : "AggregateActivityInstancesStep"));
        if (this.sparkRunnerConfig.getDataLevel().equals("activity")) {
            pipelineSteps.add(new PipelineStep(new FillActivityInstancesHistoryStep(), "CreateColumnsFromJsonStep"));
        }
        pipelineSteps.add(new PipelineStep(new AddReducedColumnsToDatasetStep(), this.sparkRunnerConfig.getDataLevel().equals("process") ? "CreateColumnsFromJsonStep" : "FillActivityInstancesHistoryStep"));
        pipelineSteps.add(new PipelineStep(new ColumnHashStep(), "AddReducedColumnsToDatasetStep"));
        pipelineSteps.add(new PipelineStep(new TypeCastStep(), "ColumnHashStep"));
        pipelineSteps.add(new PipelineStep(new WriteToDiscStep(), "TypeCastStep"));
        return pipelineSteps;
    }

    @Override
    protected Dataset<Row> loadInitialDataset() {
        Dataset dataset = this.sparkSession.read().option("inferSchema", "true").load(this.sparkRunnerConfig.getSourceFolder());
        if (this.sparkRunnerConfig.isWriteStepResultsIntoFile()) {
            BpmnaiUtils.getInstance().writeDatasetToCSV((Dataset<Row>)dataset, "initial_dataset", this.sparkRunnerConfig);
        }
        return dataset;
    }
}

