/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.runner.config;

import de.viadee.bpmnai.core.runner.SparkRunner;
import de.viadee.bpmnai.core.util.logging.BpmnaiLogger;
import java.io.Serializable;
import org.apache.spark.sql.SaveMode;

public class SparkRunnerConfig
implements Serializable {
    private boolean initialConfigToBeWritten = false;
    private boolean minimalPipelineToBeBuild = false;
    private boolean writeStepResultsIntoFile = false;
    private int stepCounter = 1;
    private String workingDirectory = ".";
    private String logDirectory = ".";
    private String sourceFolder = ".";
    private String targetFolder = ".";
    private boolean devTypeCastCheckEnabled = false;
    private boolean devProcessStateColumnWorkaroundEnabled = false;
    private boolean revCountEnabled = false;
    private SaveMode saveMode = SaveMode.Append;
    private String dataLevel = "process";
    private String outputFormat = "parquet";
    private String delimiter = "|";
    private String outputDelimiter = "|";
    private String processDefinitionFilter = "";
    private boolean batchMode = true;
    private String kafkaBroker = "";
    private String processFilterDefinitionId = null;
    private String pipelineMode = "learn";
    private SparkRunner.RUNNING_MODE runningMode = null;
    private boolean generateResultPreview = false;
    private int resultPreviewLineCount = 100;
    private boolean closeSparkSessionAfterRun = true;

    public SparkRunnerConfig() {
        this.initializeWithEnvironmentVariables();
    }

    private void initializeWithEnvironmentVariables() {
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.WORKING_DIRECTORY)) != null) {
            this.setWorkingDirectory(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.WORKING_DIRECTORY)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.LOG_DIRECTORY)) != null) {
            this.setLogDirectory(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.LOG_DIRECTORY)));
            BpmnaiLogger.getInstance().setLogDirectory(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.LOG_DIRECTORY)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.FILE_SOURCE)) != null) {
            this.setSourceFolder(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.FILE_SOURCE)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.FILE_DESTINATION)) != null) {
            this.setTargetFolder(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.FILE_DESTINATION)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.SAVE_MODE)) != null) {
            this.setSaveMode(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.SAVE_MODE)) == "append" ? SaveMode.Append : SaveMode.Overwrite);
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.DATA_LEVEL)) != null) {
            this.setDataLevel(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.DATA_LEVEL)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.OUTPUT_FORMAT)) != null) {
            this.setOutputFormat(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.OUTPUT_FORMAT)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.WRITE_STEP_RESULTS)) != null) {
            this.setWriteStepResultsIntoFile(true);
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.DELIMITER)) != null) {
            this.setDelimiter(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.DELIMITER)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.OUTPUT_DELIMITER)) != null) {
            this.setOutputDelimiter(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.OUTPUT_DELIMITER)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.PROCESS_DEFINITION_FILTER)) != null) {
            this.setProcessFilterDefinitionId(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.PROCESS_DEFINITION_FILTER)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.BATCH_MODE)) != null) {
            this.setBatchMode(true);
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.KAFKA_BOOTSTRAP_SERVERS)) != null) {
            this.setKafkaBroker(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.KAFKA_BOOTSTRAP_SERVERS)));
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.JSON_PREVIEW)) != null) {
            this.setGenerateResultPreview(true);
        }
        if (System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.JSON_PREVIEW_LINES)) != null) {
            this.setResultPreviewLineCount(Integer.parseInt(System.getenv(String.valueOf((Object)ENVIRONMENT_VARIABLES.JSON_PREVIEW_LINES))));
        }
    }

    public boolean isInitialConfigToBeWritten() {
        return this.initialConfigToBeWritten;
    }

    public void setInitialConfigToBeWritten(boolean initialConfigToBeWritten) {
        this.initialConfigToBeWritten = initialConfigToBeWritten;
    }

    public boolean isMinimalPipelineToBeBuild() {
        return this.minimalPipelineToBeBuild;
    }

    public void setMinimalPipelineToBeBuild(boolean minimalPipelineToBeBuild) {
        this.minimalPipelineToBeBuild = minimalPipelineToBeBuild;
    }

    public boolean isWriteStepResultsIntoFile() {
        return this.writeStepResultsIntoFile;
    }

    public void setWriteStepResultsIntoFile(boolean writeStepResultsIntoFile) {
        this.writeStepResultsIntoFile = writeStepResultsIntoFile;
    }

    public int getAndRaiseStepCounter() {
        return this.stepCounter++;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public boolean isDevTypeCastCheckEnabled() {
        return this.devTypeCastCheckEnabled;
    }

    public void setDevTypeCastCheckEnabled(boolean devTypeCastCheckEnabled) {
        this.devTypeCastCheckEnabled = devTypeCastCheckEnabled;
    }

    public boolean isDevProcessStateColumnWorkaroundEnabled() {
        return this.devProcessStateColumnWorkaroundEnabled;
    }

    public void setDevProcessStateColumnWorkaroundEnabled(boolean devProcessStateColumnWorkaroundEnabled) {
        this.devProcessStateColumnWorkaroundEnabled = devProcessStateColumnWorkaroundEnabled;
    }

    public boolean isRevCountEnabled() {
        return this.revCountEnabled;
    }

    public void setRevCountEnabled(boolean revCountEnabled) {
        this.revCountEnabled = revCountEnabled;
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
    }

    public String getDataLevel() {
        return this.dataLevel;
    }

    public void setDataLevel(String dataLevel) {
        this.dataLevel = dataLevel;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getOutputDelimiter() {
        return this.outputDelimiter;
    }

    public void setOutputDelimiter(String outputDelimiter) {
        this.outputDelimiter = outputDelimiter;
    }

    public String getProcessDefinitionFilter() {
        return this.processDefinitionFilter;
    }

    public void setProcessDefinitionFilter(String processDefinitionFilter) {
        this.processDefinitionFilter = processDefinitionFilter;
    }

    public String getProcessFilterDefinitionId() {
        return this.processFilterDefinitionId;
    }

    public void setProcessFilterDefinitionId(String processFilterDefinitionId) {
        this.processFilterDefinitionId = processFilterDefinitionId;
    }

    public String getPipelineMode() {
        return this.pipelineMode;
    }

    public void setPipelineMode(String pipelineMode) {
        this.pipelineMode = pipelineMode;
    }

    public SparkRunner.RUNNING_MODE getRunningMode() {
        return this.runningMode;
    }

    public void setRunningMode(SparkRunner.RUNNING_MODE runningMode) {
        this.runningMode = runningMode;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public String getKafkaBroker() {
        return this.kafkaBroker;
    }

    public void setKafkaBroker(String kafkaBroker) {
        this.kafkaBroker = kafkaBroker;
    }

    public boolean isGenerateResultPreview() {
        return this.generateResultPreview;
    }

    public void setGenerateResultPreview(boolean generateResultPreview) {
        this.generateResultPreview = generateResultPreview;
    }

    public int getResultPreviewLineCount() {
        return this.resultPreviewLineCount;
    }

    public void setResultPreviewLineCount(int resultPreviewLineCount) {
        this.resultPreviewLineCount = resultPreviewLineCount;
    }

    public boolean isCloseSparkSessionAfterRun() {
        return this.closeSparkSessionAfterRun;
    }

    public void setCloseSparkSessionAfterRun(boolean closeSparkSessionAfterRun) {
        this.closeSparkSessionAfterRun = closeSparkSessionAfterRun;
    }

    public static enum ENVIRONMENT_VARIABLES {
        WORKING_DIRECTORY,
        LOG_DIRECTORY,
        FILE_SOURCE,
        FILE_DESTINATION,
        REVISION_COUNT,
        SAVE_MODE,
        DATA_LEVEL,
        OUTPUT_FORMAT,
        WRITE_STEP_RESULTS,
        DELIMITER,
        OUTPUT_DELIMITER,
        PROCESS_DEFINITION_FILTER,
        BATCH_MODE,
        KAFKA_BOOTSTRAP_SERVERS,
        JSON_PREVIEW,
        JSON_PREVIEW_LINES;

    }
}

