/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpmnai.core.annotation;

import de.viadee.bpmnai.core.processing.interfaces.PreprocessingStepInterface;
import de.viadee.bpmnai.core.processing.steps.PipelineStepCollector;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class AnnotationCollectorTest {
    public static void main(String[] args) throws URISyntaxException, IOException, ClassNotFoundException {
        Iterable<Class> classes = AnnotationCollectorTest.getClasses("de.viadee");
        for (Class c : classes) {
            if (!PreprocessingStepInterface.class.isAssignableFrom(c)) continue;
            System.out.println(c.getSimpleName());
        }
        PipelineStepCollector.collectAllAvailablePipelineSteps();
    }

    private static Iterable<Class> getClasses(String packageName) throws ClassNotFoundException, IOException, URISyntaxException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            URI uri = new URI(resource.toString());
            dirs.add(new File(uri.getPath()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(AnnotationCollectorTest.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(AnnotationCollectorTest.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

