/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.model.MBFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBBundlesZipper {
    public static void zip(List<MBFile> files, OutputStream out) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(out);
        zipOut.setComment(files.size() + " nls files (copied: " + new Timestamp(System.currentTimeMillis()) + ")");
        for (MBFile file : files) {
            String fname = file.getName().endsWith(".xml") ? file.getName() : file.getName() + ".xml";
            ZipEntry entry = new ZipEntry(fname);
            byte[] bytes = file.getContent().getBytes();
            entry.setTime(file.getLastModified());
            entry.setSize(bytes.length);
            zipOut.putNextEntry(entry);
            zipOut.write(bytes);
            zipOut.closeEntry();
        }
        zipOut.close();
    }

    public static List<MBFile> unzipFiles(InputStream fin) throws IOException {
        ZipEntry entry;
        ZipInputStream zipIn = new ZipInputStream(fin);
        ArrayList<MBFile> files = new ArrayList<MBFile>();
        while ((entry = zipIn.getNextEntry()) != null) {
            int size;
            byte[] buf = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((size = zipIn.read(buf)) != -1) {
                baos.write(buf, 0, size);
            }
            baos.close();
            String fileName = entry.getName();
            if (!fileName.endsWith(".xml")) {
                fileName = fileName + ".xml";
            }
            MBFile file = new MBFile();
            file.setName(fileName);
            file.setContent(baos.toString());
            file.setLastModified(entry.getTime());
            files.add(file);
            zipIn.closeEntry();
        }
        return files;
    }

    public static List<MBFile> unzipFiles(byte[] zipped) throws IOException {
        return MBBundlesZipper.unzipFiles(new ByteArrayInputStream(zipped));
    }
}

