/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MergeLocaleTask
extends Task {
    private String from;
    private String with;
    private String to;
    private String locales;
    protected MBBundles loadedBundles;
    protected MBBundles translatedBundles;

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getWith() {
        return this.with;
    }

    public void setWith(String xmlWithNewLocale) {
        this.with = xmlWithNewLocale;
    }

    public String getLocales() {
        return this.locales;
    }

    public void setLocales(String locales) {
        this.locales = locales;
    }

    public void execute() {
        try {
            this.loadExecute();
            this.processExecute();
            this.outputExecute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void processExecute() {
        if (this.loadedBundles != null) {
            for (MBBundle bundle : this.loadedBundles.getBundles()) {
                for (MBEntry entry : bundle.getEntries()) {
                    StringTokenizer tokens = new StringTokenizer(this.locales, ";,");
                    while (tokens.hasMoreTokens()) {
                        MBText translatedText;
                        String locale = tokens.nextToken();
                        MBText tmpText = null;
                        for (MBText text : entry.getTexts()) {
                            if (!text.getLocale().equals(locale)) continue;
                            tmpText = text;
                        }
                        if (tmpText == null) {
                            tmpText = new MBText();
                            tmpText.setLocale(locale);
                            tmpText.setValue("");
                            entry.getTexts().add(tmpText);
                        }
                        if ((translatedText = this.findMBTextForLocale(entry.getKey(), locale, this.translatedBundles)) == null) continue;
                        tmpText.setValue(translatedText.getValue());
                    }
                }
            }
        }
    }

    protected void outputExecute() throws Exception {
        MBPersistencer.saveFile(this.loadedBundles, new File(this.to));
        this.log("Writing to bundles to file " + this.to, 2);
    }

    protected void loadExecute() throws Exception {
        this.log("Reading Bundles from " + this.from, 2);
        this.loadedBundles = MBPersistencer.loadFile(new File(this.from));
        this.log("Reading Bundles from " + this.with, 2);
        this.translatedBundles = MBPersistencer.loadFile(new File(this.with));
    }

    protected MBText findMBTextForLocale(String key, String locale, MBBundles bundles) {
        if (bundles != null) {
            for (MBBundle bundle : bundles.getBundles()) {
                for (MBEntry entry : bundle.getEntries()) {
                    if (!entry.getKey().equals(key)) continue;
                    for (MBText text : entry.getTexts()) {
                        if (!text.getLocale().equals(locale)) continue;
                        return text;
                    }
                }
            }
        }
        return null;
    }
}

