/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriter;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import de.viaboxx.nlstools.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWriterSqlOracle
extends BundleWriter {
    public BundleWriterSqlOracle(Task task, String configFile, MBBundle currentBundle, String outputPath, BundleWriter.FileType fileType, Set<String> allowedLocales) {
        super(task, configFile, currentBundle, outputPath, fileType, allowedLocales);
    }

    private File getSQLFile() {
        return this.currentBundle.getSqldomain() == null ? null : new File(this.getOutputPath(), this.currentBundle.getSqldomain() + this.suffix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeOutputFiles() throws IOException {
        File file = this.getSQLFile();
        if (file == null) {
            return;
        }
        String domain = this.currentBundle.getSqldomain();
        this.mkdirs(file.getPath());
        Writer fw = FileUtils.openFileWriterUTF8(file);
        this.task.log("writing statements for SQLDomain " + domain + " to: " + file, 2);
        try {
            fw.write("DELETE FROM NLSTEXT t WHERE EXISTS (SELECT 1 FROM NLSBUNDLE b WHERE DOMAIN='" + domain + "' AND t.BUNDLEID=b.ID);\n");
            fw.write("DELETE FROM NLSBUNDLE WHERE DOMAIN='" + domain + "';\n");
            this.writeSeqNextVal(domain, fw);
            for (MBEntry theEntry : this.getCurrentBundle().getEntries()) {
                String name = theEntry.getKey();
                Iterator<MBText> texts = theEntry.getTexts().iterator();
                String theKey = name.replace('.', '_');
                while (texts.hasNext()) {
                    MBText theText = texts.next();
                    String lang = theText.getLocale();
                    fw.write("INSERT INTO NLSTEXT (ID, KEY, TRANSLATED, LOCALE, BundleID) SELECT " + this.nextVal() + ",");
                    fw.write("'" + theKey + "','" + theText.getValue() + "', '" + lang + "', b.ID FROM NLSBUNDLE b WHERE b.DOMAIN = '" + domain + "';\n");
                }
            }
        }
        finally {
            fw.close();
        }
    }

    protected String nextVal() {
        return "SEQ_NLSBundle.NEXTVAL";
    }

    protected void writeSeqNextVal(String domain, Writer fw) throws IOException {
        fw.write("INSERT INTO NLSBUNDLE (ID, DOMAIN) SELECT " + this.nextVal() + ",'" + domain + "' FROM DUAL;\n");
    }

    @Override
    protected boolean needsNewFiles() throws FileNotFoundException {
        File outfile = this.getSQLFile();
        if (outfile == null) {
            return false;
        }
        if (!outfile.exists()) {
            return true;
        }
        File infile = new File(this.configFile);
        if (!infile.exists()) {
            throw new FileNotFoundException(infile + " not found");
        }
        return infile.lastModified() > outfile.lastModified();
    }

    @Override
    protected String suffix() {
        return ".sql";
    }
}

